/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.io.IOException;
import java.rmi.MarshalledObject;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.server.ChainedMBeanServer;

public class UnmarshallingMBeanServer
extends ChainedMBeanServer {
    public UnmarshallingMBeanServer(MBeanServer server) {
        super(server);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.createMBean(className, objectName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (IOException x3) {
            throw new ReflectionException(x3);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.createMBean(className, objectName, loaderName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (IOException x3) {
            throw new ReflectionException(x3);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            attribute = this.unmarshalAttribute(attribute);
            super.setAttribute(objectName, attribute);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (IOException x3) {
            throw new ReflectionException(x3);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            AttributeList list = new AttributeList();
            int i2 = 0;
            while (i2 < attributes.size()) {
                Attribute attribute = (Attribute)attributes.get(i2);
                attribute = this.unmarshalAttribute(attribute);
                list.add(attribute);
                ++i2;
            }
            return super.setAttributes(objectName, list);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (IOException x3) {
            throw new ReflectionException(x3);
        }
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.invoke(objectName, methodName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x2) {
            throw new ReflectionException(x2);
        }
        catch (IOException x3) {
            throw new ReflectionException(x3);
        }
    }

    private Object[] unmarshalObjects(Object[] args) throws ClassNotFoundException, IOException {
        if (args == null) {
            return null;
        }
        Object[] unmarshalled = new Object[args.length];
        int i2 = 0;
        while (i2 < unmarshalled.length) {
            Object arg = args[i2];
            unmarshalled[i2] = this.unmarshalObject(arg);
            ++i2;
        }
        return unmarshalled;
    }

    private Object unmarshalObject(Object obj) throws ClassNotFoundException, IOException {
        if (obj instanceof MarshalledObject) {
            return ((MarshalledObject)obj).get();
        }
        return obj;
    }

    private Attribute unmarshalAttribute(Attribute attribute) throws ClassNotFoundException, IOException {
        Object unmarshalled;
        Object value = attribute.getValue();
        if (value != (unmarshalled = this.unmarshalObject(value))) {
            attribute = new Attribute(attribute.getName(), unmarshalled);
        }
        return attribute;
    }
}

