/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeOperationsException;
import mx4j.log.Logger;

public class Log {
    private static Logger m_prototype;
    private static Map m_prototypeMap;
    private static Map m_loggerCache;
    private static int m_defaultPriority;

    private Log() {
    }

    public static void setDefaultPriority(int priority) {
        switch (priority) {
            case 0: {
                m_defaultPriority = 0;
                break;
            }
            case 10: {
                m_defaultPriority = 10;
                break;
            }
            case 20: {
                m_defaultPriority = 20;
                break;
            }
            case 30: {
                m_defaultPriority = 30;
                break;
            }
            case 40: {
                m_defaultPriority = 40;
                break;
            }
            case 50: {
                m_defaultPriority = 50;
                break;
            }
            default: {
                m_defaultPriority = 30;
            }
        }
    }

    public static int getDefaultPriority() {
        return m_defaultPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String category) {
        if (category == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Category cannot be null"));
        }
        Map map = m_loggerCache;
        synchronized (map) {
            Logger logger = (Logger)m_loggerCache.get(category);
            if (logger == null) {
                Logger prototype = null;
                Map map2 = m_prototypeMap;
                synchronized (map2) {
                    prototype = (Logger)m_prototypeMap.get(category);
                }
                logger = prototype == null ? (m_prototype != null ? Log.createLogger(m_prototype, category) : Log.createLogger(null, category)) : Log.createLogger(prototype, category);
                m_loggerCache.put(category, logger);
            }
            return logger;
        }
    }

    private static Logger createLogger(Logger prototype, String category) {
        Logger logger = null;
        try {
            logger = prototype == null ? new Logger() : (Logger)prototype.getClass().newInstance();
        }
        catch (Exception x2) {
            x2.printStackTrace();
            logger = new Logger();
        }
        logger.setCategory(category);
        logger.setPriority(m_defaultPriority);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirectTo(Logger prototype) {
        m_prototype = prototype;
        Map map = m_loggerCache;
        synchronized (map) {
            m_loggerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirectTo(Logger prototype, String category) {
        if (category == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Category cannot be null"));
        }
        if (prototype == null) {
            Map map = m_prototypeMap;
            synchronized (map) {
                m_prototypeMap.remove(category);
            }
            Map map2 = m_loggerCache;
            synchronized (map2) {
                m_loggerCache.remove(category);
            }
        }
        Map map = m_prototypeMap;
        synchronized (map) {
            m_prototypeMap.put(category, prototype);
        }
        Map map3 = m_loggerCache;
        synchronized (map3) {
            m_loggerCache.remove(category);
        }
    }

    static {
        block2: {
            m_prototypeMap = new HashMap();
            m_loggerCache = new HashMap();
            String priority = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.log.priority");
                }
            });
            m_defaultPriority = "trace".equalsIgnoreCase(priority) ? 0 : ("debug".equalsIgnoreCase(priority) ? 10 : ("info".equalsIgnoreCase(priority) ? 20 : ("warn".equalsIgnoreCase(priority) ? 30 : ("error".equalsIgnoreCase(priority) ? 40 : ("fatal".equalsIgnoreCase(priority) ? 50 : 30)))));
            String prototype = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.log.prototype");
                }
            });
            if (prototype == null || prototype.trim().length() <= 0) break block2;
            try {
                ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
                Class<?> cls = cl2.loadClass(prototype);
                Log.redirectTo((Logger)cls.newInstance());
            }
            catch (Exception x2) {
                x2.printStackTrace();
            }
        }
    }
}

