/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import mx4j.log.Logger;

public class MBeanLogger
extends Logger {
    private MBeanServer m_server;
    private ObjectName m_name;

    public MBeanLogger(MBeanServer server, ObjectName objectName) throws MBeanException {
        boolean found;
        block7: {
            if (server == null) {
                throw new MBeanException(new IllegalArgumentException("MBeanServer cannot be null"));
            }
            if (objectName == null) {
                throw new MBeanException(new IllegalArgumentException("ObjectName cannot be null"));
            }
            this.m_server = server;
            this.m_name = objectName;
            found = false;
            try {
                MBeanInfo info = this.m_server.getMBeanInfo(this.m_name);
                MBeanOperationInfo[] opers = info.getOperations();
                if (opers == null) break block7;
                int i2 = 0;
                while (i2 < opers.length) {
                    MBeanParameterInfo[] params;
                    MBeanOperationInfo oper = opers[i2];
                    if (oper.getName().equals("log") && (params = oper.getSignature()).length == 3 && params[0].getType().equals("int") && params[1].getType().equals("java.lang.Object") && params[2].getType().equals("java.lang.Throwable")) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
            }
            catch (Exception x2) {
                x2.printStackTrace();
            }
        }
        if (!found) {
            throw new MBeanException(new ServiceNotFoundException("MBean does not have an operation log(int,Object,Throwable)"));
        }
    }

    protected void log(int priority, Object message, Throwable t2) {
        try {
            this.m_server.invoke(this.m_name, "log", new Object[]{new Integer(priority), message, t2}, new String[]{"int", "java.lang.Object", "java.lang.Throwable"});
        }
        catch (Exception x2) {
            x2.printStackTrace();
        }
    }
}

