/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.heartbeat;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import mx4j.connector.RemoteMBeanServer;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.heartbeat.ConnectorException;
import mx4j.tools.heartbeat.HeartBeatConnectorFactory;
import mx4j.tools.heartbeat.HeartBeatMBean;

public class HeartBeat
implements HeartBeatMBean {
    private HashMap m_listeners = new HashMap();
    private String m_name = "type=heartBeat";
    private int m_period = 10;
    private int m_retries = 3;
    private ObjectName m_objectName;
    private HeartBeatThread m_hbThread = new HeartBeatThread();
    private Thread m_t;
    private boolean[] m_started = new boolean[1];

    public HeartBeat(String name) {
        this.m_name = name;
        try {
            this.m_objectName = new ObjectName(this.m_name);
        }
        catch (Exception ex2) {
            // empty catch block
        }
        Properties env = System.getProperties();
        String p2 = env.getProperty("mx4j.heartbeat.tries");
        if (p2 != null) {
            this.m_retries = new Integer(p2);
        }
        if ((p2 = env.getProperty("mx4j.heartbeat.period")) != null) {
            this.m_period = new Integer(p2);
        }
        this.m_started[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        this.m_t = new Thread((Runnable)this.m_hbThread, this.m_name);
        this.m_t.start();
        boolean[] blArray = this.m_started;
        synchronized (this.m_started) {
            while (!this.m_started[0]) {
                try {
                    this.m_started.wait();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace(this.getClass().getName() + ".stop");
        }
        this.m_hbThread.stop();
        this.m_t.interrupt();
        Thread.currentThread();
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeartBeatListener(String listenerName, Object connectorType, Object listenerAddress) {
        block6: {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("HeartBeat.addHeartBeatListener: connType=" + connectorType);
            }
            try {
                RemoteMBeanServer conn = HeartBeatConnectorFactory.getFactory().getConnector(connectorType, listenerAddress);
                HeartBeatSession session = new HeartBeatSession(conn);
                HashMap hashMap = this.m_listeners;
                synchronized (hashMap) {
                    this.m_listeners.put(listenerName, session);
                }
            }
            catch (ConnectorException ex2) {
                if (!logger.isEnabledFor(10)) break block6;
                logger.debug("HeartBeat.addHeartBeatListener exception", ex2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeartBeatListener(String heartBeatListenerName) {
        HashMap hashMap = this.m_listeners;
        synchronized (hashMap) {
            this.m_listeners.remove(heartBeatListenerName);
        }
    }

    public int getPeriod() {
        return this.m_period;
    }

    public void setPeriod(int period) {
        this.m_period = period;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int nretries) {
        this.m_retries = nretries;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private class HeartBeatSession {
        private RemoteMBeanServer m_conn;
        private int m_failCount = 0;

        public HeartBeatSession(RemoteMBeanServer conn) {
            this.m_conn = conn;
        }

        public void reset() {
            this.m_failCount = 0;
        }

        public boolean shouldContinue() {
            ++this.m_failCount;
            return this.m_failCount <= HeartBeat.this.m_retries;
        }

        public RemoteMBeanServer getConnection() {
            return this.m_conn;
        }
    }

    private class HeartBeatThread
    implements Runnable {
        private boolean m_stop = false;

        private HeartBeatThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean[] blArray = HeartBeat.this.m_started;
            synchronized (blArray) {
                ((HeartBeat)HeartBeat.this).m_started[0] = true;
                HeartBeat.this.m_started.notifyAll();
            }
            Logger logger = HeartBeat.this.getLogger();
            do {
                block20: {
                    HeartBeatSession sess = null;
                    String listener = null;
                    Object[] params = new Object[1];
                    String[] signature = new String[1];
                    params[0] = HeartBeat.this.m_objectName.getCanonicalName();
                    signature[0] = "java.lang.String";
                    try {
                        HashMap listeners;
                        HashMap hashMap = HeartBeat.this.m_listeners;
                        synchronized (hashMap) {
                            listeners = (HashMap)HeartBeat.this.m_listeners.clone();
                        }
                        Set keys = listeners.keySet();
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            listener = (String)it.next();
                            sess = (HeartBeatSession)listeners.get(listener);
                            RemoteMBeanServer conn = sess.getConnection();
                            if (logger.isEnabledFor(10)) {
                                logger.debug("HeartBeatThread.run: calling " + listener);
                            }
                            try {
                                conn.invoke(new ObjectName(listener), "processHeartBeat", params, signature);
                                sess.reset();
                            }
                            catch (RemoteException ex2) {
                                if (logger.isEnabledFor(10)) {
                                    logger.debug("HeartBeatThread.run: ConnectorException listnr=" + listener);
                                }
                                if (sess.shouldContinue()) continue;
                                HashMap hashMap2 = HeartBeat.this.m_listeners;
                                synchronized (hashMap2) {
                                    HeartBeat.this.m_listeners.remove(listener);
                                    if (logger.isEnabledFor(10)) {
                                        logger.debug("HeartBeatThread.run: removed listenr=" + listener);
                                    }
                                }
                                listeners.remove(listener);
                            }
                        }
                    }
                    catch (Exception ex3) {
                        if (!logger.isEnabledFor(10)) break block20;
                        logger.debug("HeartBeatThread.run exception", ex3);
                    }
                }
                try {
                    Thread.sleep(1000 * HeartBeat.this.m_period);
                }
                catch (Exception ex4) {
                    // empty catch block
                }
            } while (!this.m_stop);
        }

        public void stop() {
            this.m_stop = true;
        }
    }
}

