/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.NameValue;
import com.ireasoning.protocol.snmp.SnmpBits;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpOctetString;
import com.ireasoning.protocol.snmp.SnmpV1Trap;
import com.ireasoning.util.CTreeNode;
import com.ireasoning.util.Logger;
import com.ireasoning.util.MibParseException;
import com.ireasoning.util.MibTreeNode;
import com.ireasoning.util.Syntax;
import com.ireasoning.util.ed;
import com.ireasoning.util.fb;
import com.ireasoning.util.he;
import com.ireasoning.util.ld;
import com.ireasoning.util.od;
import com.ireasoning.util.qd;
import com.ireasoning.util.tb;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Set;
import java.util.Vector;

public final class MibUtil {
    private MibUtil() {
    }

    public static void setResolveSyntax(boolean bl) {
        ed.setResolveSyntax(bl);
    }

    public static void loadMibs(String[] stringArray) throws IOException, MibParseException {
        MibUtil.loadMibs(stringArray, true);
    }

    public static void loadMibs(String[] stringArray, boolean bl) throws IOException, MibParseException {
        ld.loadMibs(stringArray, bl);
    }

    public static void loadMibs(String[] stringArray, String string) throws IOException, MibParseException {
        MibUtil.loadMibs(stringArray, true, string);
    }

    public static void loadMibs(String[] stringArray, boolean bl, String string) throws IOException, MibParseException {
        ld.loadMibs(stringArray, bl, string);
    }

    public static void loadMib(String string) throws IOException, MibParseException {
        MibUtil.loadMib(string, null);
    }

    public static void loadMib(String string, String string2) throws IOException, MibParseException {
        MibUtil.loadMib(string, true, string2);
    }

    public static void loadMib(String string, boolean bl) throws IOException, MibParseException {
        MibUtil.loadMib(string, bl, null);
    }

    public static void loadMib(String string, boolean bl, String string2) throws IOException, MibParseException {
        ld.loadMib(string, bl, string2);
    }

    public static void loadMib(Reader reader, boolean bl) throws IOException, MibParseException {
        ld.loadMib(reader, bl, null);
    }

    public static void loadMib(Reader reader, boolean bl, String string) throws IOException, MibParseException {
        ld.loadMib(reader, bl, string);
    }

    public static void loadMibs(Reader[] readerArray, boolean bl) throws IOException, MibParseException {
        ld.loadMibs(readerArray, bl, null);
    }

    public static void loadMib2() {
        boolean bl = tb.b;
        try {
            URL uRL;
            Reader reader;
            block8: {
                block7: {
                    reader = od.getResourceAsReader("RFC1213.MIB");
                    if (bl) break block7;
                    if (reader != null) break block8;
                    Logger.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                }
                return;
            }
            URL uRL2 = uRL = od.getResource("RFC1213.MIB");
            if (!bl) {
                if (uRL2 == null) {
                    Logger.warn("Loading MIB-II from resource bundle failed. You may need to use loadMib method to load MIB-II explicitly.");
                    return;
                }
                uRL2 = uRL;
            }
            String string = uRL2.toString();
            ld.loadMib(reader, string);
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    public static void unloadMib(String string) {
        ld.unloadMib(string);
    }

    public static void unloadAllMibs() {
        ld.unloadAllMibs();
    }

    public static boolean isMibFileLoaded(String string) {
        return ed.isMibFileLoaded(string);
    }

    public static boolean isMibFileLoaded() {
        return ed.isMibFileLoaded();
    }

    public static SnmpOID lookupOID(String string) {
        return MibUtil.lookupOID(string, null, true);
    }

    public static SnmpOID lookupOID(String string, boolean bl) {
        return MibUtil.lookupOID(string, null, bl);
    }

    public static SnmpOID lookupOID(String string, String string2) {
        return MibUtil.lookupOID(string, string2, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static SnmpOID lookupOID(String var0, String var1_1, boolean var2_2) {
        block57: {
            block58: {
                block59: {
                    block49: {
                        block56: {
                            block54: {
                                block55: {
                                    block53: {
                                        block45: {
                                            block43: {
                                                block52: {
                                                    block51: {
                                                        block50: {
                                                            block48: {
                                                                block47: {
                                                                    var17_3 = tb.b;
                                                                    v0 = var0.startsWith(".");
                                                                    if (!var17_3) {
                                                                        if (v0 != 0) {
                                                                            var0 = var0.substring(1);
                                                                        }
                                                                        v0 = var0.equals("ccitt.0");
                                                                    }
                                                                    if (!var17_3) {
                                                                        if (v0 != 0) {
                                                                            return new SnmpOID(".0.0");
                                                                        }
                                                                        v0 = var0.indexOf(".");
                                                                    }
                                                                    if ((var3_4 = v0) >= 0) break block47;
                                                                    var4_5 = null;
                                                                    v1 = var1_1;
                                                                    if (var17_3) ** GOTO lbl19
                                                                    if (v1 == null) {
                                                                        var4_5 = ld.lookupOID(var0);
                                                                    } else {
                                                                        v1 = var0 + ":" + var1_1;
lbl19:
                                                                        // 2 sources

                                                                        var4_5 = ld.lookupOID(v1);
                                                                    }
                                                                    return var4_5;
                                                                }
                                                                var4_6 = var0.substring(0, var3_4);
                                                                var5_7 = var0.substring(var3_4 + 1);
                                                                v2 = qd.isDigit(var4_6);
                                                                if (!var17_3) {
                                                                    if (v2 != 0) {
                                                                        return new SnmpOID(var0);
                                                                    }
                                                                    v2 = qd.isDigit(var5_7);
                                                                }
                                                                if (var17_3) break block48;
                                                                if (v2 != 0) break block49;
                                                                v2 = var0.indexOf(".", var3_4 + 1);
                                                            }
                                                            v3 = var6_8 = v2;
                                                            if (var17_3) break block50;
                                                            if (v3 >= 0) break block51;
                                                            v3 = var0.length();
                                                        }
                                                        var6_8 = v3;
                                                    }
                                                    v4 = var7_10 = var0.substring(var3_4 + 1, var6_8);
                                                    if (var17_3) break block52;
                                                    if (qd.isDigit(v4)) break block49;
                                                    v4 = var0;
                                                }
                                                var8_11 = he.parse(v4, '.', false, true);
                                                var9_12 = ld.getRoots();
                                                var10_13 = var9_12.size();
                                                var11_14 = null;
                                                var12_15 = var8_11[0];
                                                var13_16 = 0;
                                                block0: while (true) {
                                                    v5 = var13_16;
                                                    block1: while (v5 < var10_13) {
                                                        var14_18 = (MibTreeNode)var9_12.get(var13_16);
                                                        v6 = var11_14 = var14_18.searchIgnoreCase(var12_15);
                                                        if (var17_3) break block43;
                                                        if (v6 != null) {
                                                            for (var15_20 = 1; var15_20 < var8_11.length; ++var15_20) {
                                                                block44: {
                                                                    v5 = (int)qd.isDigit(var8_11[var15_20]);
                                                                    if (var17_3) continue block1;
                                                                    if (v5 != 0 && !var17_3) break block0;
                                                                    for (var11_14 = (MibTreeNode)var11_14.getFirstChild(); var11_14 != null; var11_14 = (MibTreeNode)var11_14.getNextSibling()) {
                                                                        v7 = (int)var8_11[var15_20].equalsIgnoreCase(var11_14.getName().toString());
                                                                        if (!var17_3) {
                                                                            if (v7 != 0 && !var17_3) break;
                                                                            if (!var17_3) continue;
                                                                        }
                                                                        break block44;
                                                                    }
                                                                    if (var11_14 == null) break;
                                                                    v7 = var15_20;
                                                                }
                                                                if (v7 == var8_11.length - 1 && !var17_3) break block0;
                                                                if (!var17_3) continue;
                                                            }
                                                        }
                                                        ++var13_16;
                                                        if (!var17_3) continue block0;
                                                    }
                                                    break;
                                                }
                                                v6 = var11_14;
                                            }
                                            if (!var17_3) {
                                                if (v6 == null) {
                                                    return null;
                                                }
                                                v6 = var11_14;
                                            }
                                            var13_17 = v6.getOID();
                                            for (var14_19 = var8_11.length - 1; var14_19 >= 0; --var14_19) {
                                                v8 = (int)qd.isDigit(var8_11[var14_19]);
                                                if (!var17_3) {
                                                    if (v8 == 0 && !var17_3) break;
                                                    if (!var17_3) continue;
                                                }
                                                break block45;
                                            }
                                            v8 = var14_19;
                                        }
                                        if (!var17_3) {
                                            block46: {
                                                if (v8 != var8_11.length - 1) {
                                                    var15_21 = "";
                                                    for (var16_22 = var14_19 + 1; var16_22 < var8_11.length; ++var16_22) {
                                                        var15_21 = var15_21 + "." + var8_11[var16_22];
                                                        if (!var17_3) {
                                                            if (!var17_3) continue;
                                                        }
                                                        break block46;
                                                    }
                                                    var13_17.append(var15_21);
                                                }
                                            }
                                            v8 = (int)var2_2;
                                        }
                                        if (var17_3) break block53;
                                        if (v8 == 0) break block54;
                                        v8 = (int)var11_14.isScalarNode();
                                    }
                                    if (var17_3) break block55;
                                    if (v8 == 0) break block54;
                                    v9 = var13_17;
                                    if (var17_3) break block56;
                                    v8 = (int)v9.endsWith(".0");
                                }
                                if (v8 == 0) {
                                    var13_17.append(".0");
                                }
                            }
                            v9 = var13_17;
                        }
                        return v9;
                    }
                    var6_9 = null;
                    v10 = var1_1;
                    if (var17_3) ** GOTO lbl127
                    if (v10 == null) {
                        var6_9 = ld.lookupOID(var4_6);
                    } else {
                        v10 = var4_6 + ":" + var1_1;
lbl127:
                        // 2 sources

                        var6_9 = ld.lookupOID(v10);
                    }
                    v11 = var6_9;
                    if (var17_3) ** GOTO lbl134
                    if (v11 == null) {
                        v12 = null;
                    } else {
                        v11 = var6_9;
lbl134:
                        // 2 sources

                        v12 = v11.append(var5_7);
                    }
                    v13 = var6_9 = v12;
                    if (var17_3) break block57;
                    if (v13 == null) break block58;
                    v14 = ld.isScalarNode(var4_6);
                    if (var17_3) break block59;
                    if (!v14) break block58;
                    v13 = var6_9;
                    if (var17_3) break block57;
                    v14 = v13.endsWith(".0.0");
                }
                if (v14) {
                    var6_9 = var6_9.suboid(0, var6_9.getLength() - 1);
                }
            }
            v13 = var6_9;
        }
        return v13;
    }

    public static String translateOID(String string, boolean bl) {
        MibTreeNode mibTreeNode;
        block5: {
            MibTreeNode mibTreeNode2;
            block4: {
                mibTreeNode2 = mibTreeNode = ld.get(string);
                if (tb.b) break block4;
                if (mibTreeNode2 != null) break block5;
                mibTreeNode2 = mibTreeNode = ld.searchOther(new SnmpOID(string));
            }
            if (mibTreeNode2 == null) {
                return null;
            }
        }
        return MibUtil.a(string, mibTreeNode, bl);
    }

    public static String translateOID(SnmpOID snmpOID, boolean bl) {
        return MibUtil.translateOID(snmpOID.toString(), bl);
    }

    public static String translateSnmpV1Trap(SnmpV1Trap snmpV1Trap) {
        return MibUtil.translateSnmpV1Trap(snmpV1Trap.getEnterprise(), snmpV1Trap.getGeneric(), snmpV1Trap.getSpecific());
    }

    public static String translateSnmpV1Trap(SnmpOID snmpOID, int n2, int n3) {
        int n4;
        block12: {
            block13: {
                int n5;
                block14: {
                    boolean bl = tb.b;
                    n4 = n2;
                    if (bl) break block12;
                    if (n4 >= 6) break block13;
                    n4 = n2;
                    if (!bl) {
                        if (n4 == 0) {
                            return "coldStart";
                        }
                        n4 = 1;
                    }
                    n5 = n2;
                    if (!bl) {
                        if (n4 == n5) {
                            return "warmStart";
                        }
                        n4 = 2;
                        n5 = n2;
                    }
                    if (!bl) {
                        if (n4 == n5) {
                            return "linkDown";
                        }
                        n4 = 3;
                        n5 = n2;
                    }
                    if (!bl) {
                        if (n4 == n5) {
                            return "linkUp";
                        }
                        n4 = 4;
                        n5 = n2;
                    }
                    if (bl) break block14;
                    if (n4 == n5) {
                        return "authenticationFailure";
                    }
                    n4 = 5;
                    if (bl) break block12;
                    n5 = n2;
                }
                if (n4 == n5) {
                    return "egpNeighborLoss";
                }
            }
            n4 = n3;
        }
        long l2 = (long)n4 & 0xFFFFFFFFL;
        String string = snmpOID.toString() + ".0." + l2;
        return ld.getSnmpV1TrapName(string);
    }

    public static String translateValue(String string, String string2) {
        String string3 = string2;
        if (!tb.b) {
            if (string3 == null) {
                return null;
            }
            string3 = string;
        }
        MibTreeNode mibTreeNode = ld.get(string3);
        return MibUtil.translateValue(mibTreeNode, string2);
    }

    public static String translateValue(MibTreeNode mibTreeNode, String string) {
        String string2;
        String string3 = string2 = MibUtil.a(string, mibTreeNode);
        if (!tb.b) {
            if (string3 == null) {
                string2 = string;
            }
            string3 = string2;
        }
        return string3;
    }

    public static String translateValue(SnmpOID snmpOID, String string) {
        return MibUtil.translateValue(snmpOID.toString(), string);
    }

    public static NameValue translate(String string, String string2, boolean bl) {
        String string3;
        String string4 = string3 = MibUtil.translateOID(string, bl);
        if (!tb.b) {
            if (string4 == null) {
                string3 = string;
            }
            string4 = MibUtil.translateValue(string, string2);
        }
        string2 = string4;
        return new NameValue(string3, string2);
    }

    public static NameValue translate(SnmpOID snmpOID, String string, boolean bl) {
        return MibUtil.translate(snmpOID.toString(), string, bl);
    }

    public static MibTreeNode parseMib(String string) throws IOException, MibParseException {
        return MibUtil.parseMib(string, true);
    }

    public static MibTreeNode parseMib(Reader reader, boolean bl) throws IOException, MibParseException {
        fb fb2;
        ed ed2 = ed.loadMib(reader, bl);
        fb fb3 = fb2 = (fb)ed2.getRoot();
        if (!tb.b) {
            if (fb3 != null) {
                fb2.setTrapNodes(ed2.getTraps());
            }
            fb3 = fb2;
        }
        return fb3;
    }

    public static MibTreeNode parseMibs(Reader[] readerArray, boolean bl) throws IOException, MibParseException {
        fb fb2;
        block11: {
            fb fb3;
            block10: {
                boolean bl2 = tb.b;
                ed ed2 = ed.loadMib(readerArray[0], bl);
                fb3 = (fb)ed2.getRoot();
                Vector vector = new Vector();
                vector.addAll(ed2.getTraps());
                for (int i2 = 1; i2 < readerArray.length; ++i2) {
                    ed ed3 = ed.loadMib(readerArray[i2]);
                    if (!bl2) {
                        fb fb4;
                        MibTreeNode mibTreeNode;
                        ed ed4 = ed3;
                        if (!bl2) {
                            if (ed4 == null) continue;
                            vector.addAll(ed3.getTraps());
                            ed4 = ed3;
                        }
                        if ((mibTreeNode = ed4.getRoot()) == null) continue;
                        CTreeNode cTreeNode = fb3;
                        if (!bl2) {
                            if (cTreeNode == null) {
                                fb3 = (fb)mibTreeNode;
                                ed2 = ed3;
                                if (!bl2) continue;
                            }
                            cTreeNode = mibTreeNode.getFirstChild();
                        }
                        if ((fb4 = cTreeNode) == null) continue;
                        ed2.addOtherSubTree((MibTreeNode)fb4.getFirstChild());
                        if (!bl2) continue;
                    }
                    break block10;
                }
                fb2 = fb3;
                if (bl2) break block11;
                if (fb2 != null) {
                    fb3.setTrapNodes(vector);
                }
            }
            fb2 = fb3;
        }
        return fb2;
    }

    public static MibTreeNode parseMib(String string, boolean bl) throws IOException, MibParseException {
        fb fb2;
        ed ed2 = ed.loadMib(string, bl);
        fb fb3 = fb2 = (fb)ed2.getRoot();
        if (!tb.b) {
            if (fb3 != null) {
                fb2.setTrapNodes(ed2.getTraps());
            }
            fb3 = fb2;
        }
        return fb3;
    }

    public static MibTreeNode parseMibs(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibs(stringArray, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MibTreeNode parseMibs(String[] stringArray, boolean bl) throws IOException, MibParseException {
        fb fb2;
        block19: {
            fb fb3;
            block18: {
                boolean bl2 = tb.b;
                ed ed2 = null;
                try {
                    ed2 = ed.loadMib(stringArray[0], bl);
                }
                catch (MibParseException mibParseException) {
                    MibParseException mibParseException2 = mibParseException;
                    if (!bl2) {
                        if (mibParseException2.getMibModuleName() == null) {
                            mibParseException.setMibModuleName(stringArray[0]);
                        }
                        mibParseException2 = mibParseException;
                    }
                    throw mibParseException2;
                }
                fb3 = (fb)ed2.getRoot();
                Vector vector = new Vector();
                vector.addAll(ed2.getTraps());
                for (int i2 = 1; i2 < stringArray.length; ++i2) {
                    try {
                        ed ed3 = ed.loadMib(stringArray[i2]);
                        if (!bl2) {
                            fb fb4;
                            MibTreeNode mibTreeNode;
                            ed ed4 = ed3;
                            if (!bl2) {
                                if (ed4 == null && !bl2) continue;
                                vector.addAll(ed3.getTraps());
                                ed4 = ed3;
                            }
                            if ((mibTreeNode = ed4.getRoot()) == null && !bl2) continue;
                            CTreeNode cTreeNode = fb3;
                            if (!bl2) {
                                if (cTreeNode == null) {
                                    fb3 = (fb)mibTreeNode;
                                    ed2 = ed3;
                                    if (!bl2) continue;
                                }
                                cTreeNode = fb4 = mibTreeNode.getFirstChild();
                            }
                            if (bl2 || fb4 == null && !bl2) continue;
                            ed2.addOtherSubTree((MibTreeNode)fb4.getFirstChild());
                            continue;
                        }
                        break block18;
                    }
                    catch (MibParseException mibParseException) {
                        MibParseException mibParseException3 = mibParseException;
                        if (!bl2) {
                            if (mibParseException3.getMibModuleName() == null) {
                                mibParseException.setMibModuleName(stringArray[i2]);
                            }
                            mibParseException3 = mibParseException;
                        }
                        throw mibParseException3;
                    }
                }
                fb2 = fb3;
                if (bl2) break block19;
                if (fb2 != null) {
                    fb3.setTrapNodes(vector);
                }
            }
            fb2 = fb3;
        }
        return fb2;
    }

    public static MibTreeNode[] parseMibsWithoutMerge(String[] stringArray) throws IOException, MibParseException {
        return MibUtil.parseMibsWithoutMerge(stringArray, true);
    }

    public static MibTreeNode[] parseMibsWithoutMerge(String[] stringArray, boolean bl) throws IOException, MibParseException {
        MibTreeNode[] mibTreeNodeArray;
        block2: {
            boolean bl2 = tb.b;
            MibTreeNode[] mibTreeNodeArray2 = new MibTreeNode[stringArray.length];
            for (int i2 = 0; i2 < mibTreeNodeArray2.length; ++i2) {
                mibTreeNodeArray = mibTreeNodeArray2;
                if (!bl2) {
                    mibTreeNodeArray[i2] = MibUtil.parseMib(stringArray[i2], bl);
                    if (!bl2) continue;
                }
                break block2;
            }
            mibTreeNodeArray = mibTreeNodeArray2;
        }
        return mibTreeNodeArray;
    }

    public static Set getModulesInfo() {
        return ed.getModulesInfo();
    }

    private static String a(String string, MibTreeNode mibTreeNode) {
        String string2;
        block16: {
            block15: {
                String string3;
                Syntax syntax;
                boolean bl;
                block14: {
                    Syntax syntax2;
                    block13: {
                        String string4;
                        block11: {
                            block12: {
                                String string5;
                                bl = tb.b;
                                MibTreeNode mibTreeNode2 = mibTreeNode;
                                if (!bl) {
                                    if (mibTreeNode2 == null) {
                                        return null;
                                    }
                                    mibTreeNode2 = mibTreeNode;
                                }
                                syntax2 = mibTreeNode2.getSyntax();
                                string4 = string5 = mibTreeNode.getSyntaxType();
                                if (!bl) {
                                    if (string4 == null) {
                                        return null;
                                    }
                                    string4 = string5;
                                }
                                if (bl) break block11;
                                if (string4.equals("BITS")) break block12;
                                string4 = string5;
                                if (bl) break block11;
                                if (!string4.equals("FcPortFCClass")) break block13;
                            }
                            string4 = MibUtil.b(string, mibTreeNode);
                        }
                        return string4;
                    }
                    syntax = syntax2;
                    if (bl) break block14;
                    if (syntax == null) break block15;
                    syntax = syntax2;
                }
                string2 = string3 = syntax.get(string);
                if (bl) break block16;
                if (string2 != null) {
                    string = string3;
                }
            }
            string2 = string;
        }
        return string2;
    }

    private static String b(String string, MibTreeNode mibTreeNode) {
        String string2;
        block10: {
            boolean bl = tb.b;
            int n2 = string.indexOf("{");
            SnmpBits snmpBits = new SnmpBits();
            int n3 = n2;
            if (!bl) {
                if (n3 < 0) {
                    byte[] byArray = SnmpOctetString.getBytes(string);
                    snmpBits.setValue(byArray);
                    string = snmpBits.toString();
                    n2 = string.indexOf("{");
                }
                n3 = string.indexOf("}");
            }
            int n4 = n3;
            string = string.substring(n2 + 1, n4);
            String[] stringArray = he.parse(string, ',', true);
            Syntax syntax = mibTreeNode.getSyntax();
            string2 = "{";
            boolean bl2 = true;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string3;
                block12: {
                    Syntax syntax2;
                    block11: {
                        string3 = null;
                        if (bl) break block10;
                        syntax2 = syntax;
                        if (bl) break block11;
                        if (syntax2 == null) break block12;
                        syntax2 = syntax;
                    }
                    string3 = syntax2.get(stringArray[i2]);
                }
                boolean bl3 = bl2;
                if (!bl) {
                    if (!bl3) {
                        string2 = string2 + ", ";
                    }
                    bl3 = false;
                }
                bl2 = bl3;
                String string4 = string3;
                if (!bl) {
                    if (string4 != null) {
                        string2 = string2 + string3;
                        if (!bl) continue;
                    }
                    string4 = string2 + stringArray[i2];
                }
                string2 = string4;
                if (!bl) continue;
            }
            string2 = string2 + "}";
        }
        return string2;
    }

    private static String a(String string, MibTreeNode mibTreeNode, boolean bl) {
        boolean bl2 = tb.b;
        MibTreeNode mibTreeNode2 = mibTreeNode;
        if (!bl2) {
            if (mibTreeNode2 == null) {
                return null;
            }
            mibTreeNode2 = mibTreeNode;
        }
        SnmpOID snmpOID = mibTreeNode2.getOID();
        SnmpOID snmpOID2 = new SnmpOID(string);
        String string2 = "";
        int n2 = snmpOID.getLength();
        if (!bl2) {
            if (n2 < snmpOID2.getLength()) {
                SnmpOID snmpOID3 = snmpOID2.suboid(snmpOID.getLength(), snmpOID2.getLength());
                string2 = snmpOID3.toString();
            }
            n2 = bl ? 1 : 0;
        }
        return n2 != 0 ? mibTreeNode.getFullName() + string2 : mibTreeNode.getName().toString() + string2;
    }
}

