/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class LOKI91
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("LOKI91");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("LOKI91", 2, 3);
    private static final int BLOCK_SIZE = 8;
    private static final int ROUNDS = 16;
    private static final byte[] S = new byte[4096];
    private static final int[] P = new int[256];
    private long native_cookie;
    private Object native_lock;
    private int[] sKey = new int[16];

    private static void debug(String string) {
        err.println("LOKI91: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(LOKI91.getLibMajorVersion(), LOKI91.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    LOKI91.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                LOKI91.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    private static final byte exp31(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        int n4 = n2;
        n2 = LOKI91.mult(n2, n2, n3);
        n4 = LOKI91.mult(n4, n2, n3);
        n2 = LOKI91.mult(n2, n2, n3);
        n4 = LOKI91.mult(n4, n2, n3);
        n2 = LOKI91.mult(n2, n2, n3);
        n4 = LOKI91.mult(n4, n2, n3);
        n2 = LOKI91.mult(n2, n2, n3);
        return (byte)LOKI91.mult(n4, n2, n3);
    }

    private static final int mult(int n2, int n3, int n4) {
        int n5 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                n5 ^= n2;
            }
            if ((n2 <<= 1) > 255) {
                n2 ^= n4;
            }
            n3 >>>= 1;
        }
        return n5;
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    LOKI91.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 8;
                    n4 += 8;
                    ++n6;
                }
            }
        } else if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                this.blockEncrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n5) {
                this.blockDecrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n8;
            }
        }
        return n3;
    }

    private synchronized void makeKey(Key key) throws KeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null LOKI91 key");
        }
        if (byArray.length < 8) {
            throw new KeyException("Invalid LOKI91 user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        LOKI91.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.sKey[0] = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.sKey[1] = this.sKey[0] << 12 | this.sKey[0] >>> 20;
        this.sKey[2] = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.sKey[3] = this.sKey[2] << 12 | this.sKey[2] >>> 20;
        int n2 = 4;
        while (n2 < 16) {
            this.sKey[n2] = this.sKey[n2 - 3] << 13 | this.sKey[n2 - 3] >>> 19;
            this.sKey[n2 + 1] = this.sKey[n2] << 12 | this.sKey[n2] >>> 20;
            this.sKey[n2 + 2] = this.sKey[n2 - 1] << 13 | this.sKey[n2 - 1] >>> 19;
            this.sKey[n2 + 3] = this.sKey[n2 + 2] << 12 | this.sKey[n2 + 2] >>> 20;
            n2 += 4;
        }
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
        int n6 = 0;
        while (n6 < 16) {
            int n7 = n5 ^ this.sKey[n6++];
            n4 ^= P[S[n7 & 0xFFF] & 0xFF] | P[S[n7 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n7 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n7 >>> 24 | n7 << 8) & 0xFFF] & 0xFF] << 3;
            n7 = n4 ^ this.sKey[n6++];
            n5 ^= P[S[n7 & 0xFFF] & 0xFF] | P[S[n7 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n7 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n7 >>> 24 | n7 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n3++] = (byte)(n5 >>> 24);
        byArray2[n3++] = (byte)(n5 >>> 16);
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)(n4 >>> 24);
        byArray2[n3++] = (byte)(n4 >>> 16);
        byArray2[n3++] = (byte)(n4 >>> 8);
        byArray2[n3] = (byte)n4;
    }

    private void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        int n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
        int n6 = 16;
        while (n6 > 0) {
            int n7 = n5 ^ this.sKey[--n6];
            n4 ^= P[S[n7 & 0xFFF] & 0xFF] | P[S[n7 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n7 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n7 >>> 24 | n7 << 8) & 0xFFF] & 0xFF] << 3;
            n7 = n4 ^ this.sKey[--n6];
            n5 ^= P[S[n7 & 0xFFF] & 0xFF] | P[S[n7 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n7 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n7 >>> 24 | n7 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n3++] = (byte)(n5 >>> 24);
        byArray2[n3++] = (byte)(n5 >>> 16);
        byArray2[n3++] = (byte)(n5 >>> 8);
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)(n4 >>> 24);
        byArray2[n3++] = (byte)(n4 >>> 16);
        byArray2[n3++] = (byte)(n4 >>> 8);
        byArray2[n3] = (byte)n4;
    }

    public LOKI91() {
        super(false, false, "Cryptix");
        this.link();
    }

    static {
        int[] nArray = new int[]{375, 379, 391, 395, 397, 415, 419, 425, 433, 445, 451, 463, 471, 477, 487, 499};
        int n2 = 0;
        while (n2 < 4096) {
            int n3 = n2 >>> 8 & 0xC | n2 & 3;
            int n4 = n2 >>> 2 & 0xFF;
            int n5 = n4 + (n3 * 17 ^ 0xFF) & 0xFF;
            LOKI91.S[n2] = LOKI91.exp31(n5, nArray[n3]);
            ++n2;
        }
        int[] nArray2 = new int[]{31, 23, 15, 7, 30, 22, 14, 6, 29, 21, 13, 5, 28, 20, 12, 4, 27, 19, 11, 3, 26, 18, 10, 2, 25, 17, 9, 1, 24, 16, 8, 0};
        int n6 = 0;
        while (n6 < 256) {
            int n7 = 0;
            int n8 = 0;
            while (n8 < 32) {
                n7 |= (n6 >>> nArray2[n8] & 1) << 31 - n8;
                ++n8;
            }
            LOKI91.P[n6] = n7;
            ++n6;
        }
    }
}

