/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.CryptixException;
import java.security.MessageDigest;

abstract class BlockMessageDigest
extends MessageDigest {
    private static final long MAX_COUNT = 0x1FFFFFFFFFFFFFFFL;
    private byte[] buffer;
    private int buffered;
    private long count;
    private int data_length = this.engineGetDataLength();

    protected long bitcount() {
        return this.count * 8L;
    }

    protected void engineReset() {
        this.buffered = 0;
        this.count = 0L;
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4;
        this.count += (long)n3;
        if (this.count > 0x1FFFFFFFFFFFFFFFL) {
            throw new CryptixException(this.getAlgorithm() + ": Maximum input length exceeded");
        }
        int n5 = this.data_length;
        while (n3 >= (n4 = n5 - this.buffered)) {
            System.arraycopy(byArray, n2, this.buffer, this.buffered, n4);
            this.engineTransform(this.buffer);
            n3 -= n4;
            n2 += n4;
            this.buffered = 0;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n2, this.buffer, this.buffered, n3);
            this.buffered += n3;
        }
    }

    protected byte[] engineDigest() {
        return this.engineDigest(this.buffer, this.buffered);
    }

    protected abstract byte[] engineDigest(byte[] var1, int var2);

    protected abstract void engineTransform(byte[] var1);

    protected abstract int engineGetDataLength();

    protected BlockMessageDigest(String string) {
        super(string);
        this.buffer = new byte[this.data_length];
    }
}

