/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.BlockMessageDigest;
import cryptix.util.core.Debug;
import java.io.PrintWriter;

public final class MD5
extends BlockMessageDigest
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("MD5");
    private static final PrintWriter err = Debug.getOutput();
    private static final int HASH_LENGTH = 16;
    private static final int DATA_LENGTH = 64;
    private static String[] texts = new String[]{"", "message digest", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"};
    private static byte[][] hashs = new byte[][]{{-44, 29, -116, -39, -113, 0, -78, 4, -23, -128, 9, -104, -20, -8, 66, 126}, {-7, 107, 105, 125, 124, -73, -109, -115, 82, 90, 47, 49, -86, -15, 97, -48}, {-47, 116, -85, -104, -46, 119, -39, -11, -91, 97, 28, 44, -97, 65, -99, -97}};
    private int[] data;
    private int[] digest;
    private byte[] tmp;

    private static void debug(String string) {
        err.println("MD5: " + string);
    }

    protected int engineGetDigestLength() {
        return 16;
    }

    protected int engineGetDataLength() {
        return 64;
    }

    private void java_init() {
        this.digest = new int[4];
        this.data = new int[16];
        this.tmp = new byte[64];
    }

    public Object clone() {
        return new MD5(this);
    }

    protected void engineReset() {
        super.engineReset();
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
    }

    protected void engineTransform(byte[] byArray) {
        this.java_transform(byArray);
    }

    private void java_transform(byte[] byArray) {
        MD5.byte2int(byArray, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    protected byte[] engineDigest(byte[] byArray, int n2) {
        byte[] byArray2 = this.java_digest(byArray, n2);
        this.engineReset();
        return byArray2;
    }

    private byte[] java_digest(byte[] byArray, int n2) {
        if (n2 != 0) {
            System.arraycopy(byArray, 0, this.tmp, 0, n2);
        }
        this.tmp[n2++] = -128;
        if (n2 > 56) {
            while (n2 < 64) {
                this.tmp[n2++] = 0;
            }
            MD5.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            n2 = 0;
        }
        while (n2 < 56) {
            this.tmp[n2++] = 0;
        }
        MD5.byte2int(this.tmp, 0, this.data, 0, 14);
        long l2 = this.bitcount();
        this.data[14] = (int)l2;
        this.data[15] = (int)(l2 >>> 32);
        this.transform(this.data);
        byte[] byArray2 = new byte[16];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 4) {
            int n5 = this.digest[n4];
            byArray2[n3++] = (byte)n5;
            byArray2[n3++] = (byte)(n5 >>> 8);
            byArray2[n3++] = (byte)(n5 >>> 16);
            byArray2[n3++] = (byte)(n5 >>> 24);
            ++n4;
        }
        return byArray2;
    }

    protected static int F(int n2, int n3, int n4) {
        return n4 ^ n2 & (n3 ^ n4);
    }

    protected static int G(int n2, int n3, int n4) {
        return n3 ^ n4 & (n2 ^ n3);
    }

    protected static int H(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    protected static int I(int n2, int n3, int n4) {
        return n3 ^ (n2 | ~n4);
    }

    protected static int FF(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n2 += n6 + n8 + MD5.F(n3, n4, n5);
        n2 = n2 << n7 | n2 >>> -n7;
        return n2 + n3;
    }

    protected static int GG(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n2 += n6 + n8 + MD5.G(n3, n4, n5);
        n2 = n2 << n7 | n2 >>> -n7;
        return n2 + n3;
    }

    protected static int HH(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n2 += n6 + n8 + MD5.H(n3, n4, n5);
        n2 = n2 << n7 | n2 >>> -n7;
        return n2 + n3;
    }

    protected static int II(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n2 += n6 + n8 + MD5.I(n3, n4, n5);
        n2 = n2 << n7 | n2 >>> -n7;
        return n2 + n3;
    }

    protected void transform(int[] nArray) {
        if (debuglevel > 5) {
            MD5.debug("d1 " + this.digest[0] + " d1 " + this.digest[1] + " d2 " + this.digest[2] + " d3 " + this.digest[3]);
        }
        if (debuglevel > 8) {
            int n2 = 0;
            while (n2 < 16) {
                MD5.debug("      " + n2 + "= " + nArray[n2]);
                ++n2;
            }
        }
        int n3 = this.digest[0];
        int n4 = this.digest[1];
        int n5 = this.digest[2];
        int n6 = this.digest[3];
        n3 = MD5.FF(n3, n4, n5, n6, nArray[0], 7, -680876936);
        n6 = MD5.FF(n6, n3, n4, n5, nArray[1], 12, -389564586);
        n5 = MD5.FF(n5, n6, n3, n4, nArray[2], 17, 606105819);
        n4 = MD5.FF(n4, n5, n6, n3, nArray[3], 22, -1044525330);
        n3 = MD5.FF(n3, n4, n5, n6, nArray[4], 7, -176418897);
        n6 = MD5.FF(n6, n3, n4, n5, nArray[5], 12, 1200080426);
        n5 = MD5.FF(n5, n6, n3, n4, nArray[6], 17, -1473231341);
        n4 = MD5.FF(n4, n5, n6, n3, nArray[7], 22, -45705983);
        n3 = MD5.FF(n3, n4, n5, n6, nArray[8], 7, 1770035416);
        n6 = MD5.FF(n6, n3, n4, n5, nArray[9], 12, -1958414417);
        n5 = MD5.FF(n5, n6, n3, n4, nArray[10], 17, -42063);
        n4 = MD5.FF(n4, n5, n6, n3, nArray[11], 22, -1990404162);
        n3 = MD5.FF(n3, n4, n5, n6, nArray[12], 7, 1804603682);
        n6 = MD5.FF(n6, n3, n4, n5, nArray[13], 12, -40341101);
        n5 = MD5.FF(n5, n6, n3, n4, nArray[14], 17, -1502002290);
        n4 = MD5.FF(n4, n5, n6, n3, nArray[15], 22, 1236535329);
        n3 = MD5.GG(n3, n4, n5, n6, nArray[1], 5, -165796510);
        n6 = MD5.GG(n6, n3, n4, n5, nArray[6], 9, -1069501632);
        n5 = MD5.GG(n5, n6, n3, n4, nArray[11], 14, 643717713);
        n4 = MD5.GG(n4, n5, n6, n3, nArray[0], 20, -373897302);
        n3 = MD5.GG(n3, n4, n5, n6, nArray[5], 5, -701558691);
        n6 = MD5.GG(n6, n3, n4, n5, nArray[10], 9, 38016083);
        n5 = MD5.GG(n5, n6, n3, n4, nArray[15], 14, -660478335);
        n4 = MD5.GG(n4, n5, n6, n3, nArray[4], 20, -405537848);
        n3 = MD5.GG(n3, n4, n5, n6, nArray[9], 5, 568446438);
        n6 = MD5.GG(n6, n3, n4, n5, nArray[14], 9, -1019803690);
        n5 = MD5.GG(n5, n6, n3, n4, nArray[3], 14, -187363961);
        n4 = MD5.GG(n4, n5, n6, n3, nArray[8], 20, 1163531501);
        n3 = MD5.GG(n3, n4, n5, n6, nArray[13], 5, -1444681467);
        n6 = MD5.GG(n6, n3, n4, n5, nArray[2], 9, -51403784);
        n5 = MD5.GG(n5, n6, n3, n4, nArray[7], 14, 1735328473);
        n4 = MD5.GG(n4, n5, n6, n3, nArray[12], 20, -1926607734);
        n3 = MD5.HH(n3, n4, n5, n6, nArray[5], 4, -378558);
        n6 = MD5.HH(n6, n3, n4, n5, nArray[8], 11, -2022574463);
        n5 = MD5.HH(n5, n6, n3, n4, nArray[11], 16, 1839030562);
        n4 = MD5.HH(n4, n5, n6, n3, nArray[14], 23, -35309556);
        n3 = MD5.HH(n3, n4, n5, n6, nArray[1], 4, -1530992060);
        n6 = MD5.HH(n6, n3, n4, n5, nArray[4], 11, 1272893353);
        n5 = MD5.HH(n5, n6, n3, n4, nArray[7], 16, -155497632);
        n4 = MD5.HH(n4, n5, n6, n3, nArray[10], 23, -1094730640);
        n3 = MD5.HH(n3, n4, n5, n6, nArray[13], 4, 681279174);
        n6 = MD5.HH(n6, n3, n4, n5, nArray[0], 11, -358537222);
        n5 = MD5.HH(n5, n6, n3, n4, nArray[3], 16, -722521979);
        n4 = MD5.HH(n4, n5, n6, n3, nArray[6], 23, 76029189);
        n3 = MD5.HH(n3, n4, n5, n6, nArray[9], 4, -640364487);
        n6 = MD5.HH(n6, n3, n4, n5, nArray[12], 11, -421815835);
        n5 = MD5.HH(n5, n6, n3, n4, nArray[15], 16, 530742520);
        n4 = MD5.HH(n4, n5, n6, n3, nArray[2], 23, -995338651);
        n3 = MD5.II(n3, n4, n5, n6, nArray[0], 6, -198630844);
        n6 = MD5.II(n6, n3, n4, n5, nArray[7], 10, 1126891415);
        n5 = MD5.II(n5, n6, n3, n4, nArray[14], 15, -1416354905);
        n4 = MD5.II(n4, n5, n6, n3, nArray[5], 21, -57434055);
        n3 = MD5.II(n3, n4, n5, n6, nArray[12], 6, 1700485571);
        n6 = MD5.II(n6, n3, n4, n5, nArray[3], 10, -1894986606);
        n5 = MD5.II(n5, n6, n3, n4, nArray[10], 15, -1051523);
        n4 = MD5.II(n4, n5, n6, n3, nArray[1], 21, -2054922799);
        n3 = MD5.II(n3, n4, n5, n6, nArray[8], 6, 1873313359);
        n6 = MD5.II(n6, n3, n4, n5, nArray[15], 10, -30611744);
        n5 = MD5.II(n5, n6, n3, n4, nArray[6], 15, -1560198380);
        n4 = MD5.II(n4, n5, n6, n3, nArray[13], 21, 1309151649);
        n3 = MD5.II(n3, n4, n5, n6, nArray[4], 6, -145523070);
        n6 = MD5.II(n6, n3, n4, n5, nArray[11], 10, -1120210379);
        n5 = MD5.II(n5, n6, n3, n4, nArray[2], 15, 718787259);
        n4 = MD5.II(n4, n5, n6, n3, nArray[9], 21, -343485551);
        this.digest[0] = this.digest[0] + n3;
        this.digest[1] = this.digest[1] + n4;
        this.digest[2] = this.digest[2] + n5;
        this.digest[3] = this.digest[3] + n6;
        if (debuglevel > 4) {
            MD5.debug("d1 " + this.digest[0] + " d1 " + this.digest[1] + " d2 " + this.digest[2] + " d3 " + this.digest[3]);
        }
    }

    private static void byte2int(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        while (n4-- > 0) {
            nArray[n3++] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            MD5.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static final void self_test() throws Exception {
        int n2 = hashs[0].length;
        int n3 = 0;
        while (n3 < texts.length) {
            MD5 mD5 = new MD5();
            byte[] byArray = texts[n3].getBytes();
            int n4 = 0;
            while (n4 < texts[n3].length()) {
                mD5.engineUpdate(byArray[n4]);
                ++n4;
            }
            if (MD5.notEquals(mD5.engineDigest(), hashs[n3])) {
                throw new Exception("hash #" + n3 + " failed");
            }
            ++n3;
        }
    }

    private static final boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public MD5() {
        super("MD5");
        this.java_init();
        this.reset();
    }

    private MD5(MD5 mD5) {
        this();
        this.data = (int[])mD5.data.clone();
        this.digest = (int[])mD5.digest.clone();
        this.tmp = (byte[])mD5.tmp.clone();
    }
}

