/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.core;

import cryptix.util.core.ArrayUtil;
import java.io.PrintWriter;

public class Hex {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toString(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        int n5 = n2;
        while (n5 < n2 + n3) {
            byte by = byArray[n5];
            cArray[n4++] = hexDigits[by >>> 4 & 0xF];
            cArray[n4++] = hexDigits[by & 0xF];
            ++n5;
        }
        return new String(cArray);
    }

    public static String toString(byte[] byArray) {
        return Hex.toString(byArray, 0, byArray.length);
    }

    public static String toString(int[] nArray, int n2, int n3) {
        char[] cArray = new char[n3 * 8];
        int n4 = 0;
        int n5 = n2;
        while (n5 < n2 + n3) {
            int n6 = nArray[n5];
            cArray[n4++] = hexDigits[n6 >>> 28 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 24 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 20 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 16 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 12 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 8 & 0xF];
            cArray[n4++] = hexDigits[n6 >>> 4 & 0xF];
            cArray[n4++] = hexDigits[n6 & 0xF];
            ++n5;
        }
        return new String(cArray);
    }

    public static String toString(int[] nArray) {
        return Hex.toString(nArray, 0, nArray.length);
    }

    public static String toReversedString(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        int n5 = n2 + n3 - 1;
        while (n5 >= n2) {
            cArray[n4++] = hexDigits[byArray[n5] >>> 4 & 0xF];
            cArray[n4++] = hexDigits[byArray[n5] & 0xF];
            --n5;
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] byArray) {
        return Hex.toReversedString(byArray, 0, byArray.length);
    }

    public static byte[] fromString(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[(n2 + 1) / 2];
        int n3 = 0;
        int n4 = 0;
        if (n2 % 2 == 1) {
            byArray[n4++] = (byte)Hex.fromDigit(string.charAt(n3++));
        }
        while (n3 < n2) {
            byArray[n4++] = (byte)(Hex.fromDigit(string.charAt(n3++)) << 4 | Hex.fromDigit(string.charAt(n3++)));
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] fromReversedString(String var0) {
        var1_1 = var0.length();
        var2_2 = new byte[(var1_1 + 1) / 2];
        var3_3 = 0;
        if (var1_1 % 2 != 1) ** GOTO lbl7
        throw new IllegalArgumentException("string must have an even number of digits");
lbl-1000:
        // 1 sources

        {
            var2_2[var3_3++] = (byte)(Hex.fromDigit(var0.charAt(--var1_1)) | Hex.fromDigit(var0.charAt(--var1_1)) << 4);
lbl7:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl8:
        // 1 sources

        return var2_2;
    }

    public static char toDigit(int n2) {
        try {
            return hexDigits[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(n2 + " is out of range for a hex digit");
        }
    }

    public static int fromDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + c2 + "'");
    }

    public static String byteToString(int n2) {
        char[] cArray = new char[]{hexDigits[n2 >>> 4 & 0xF], hexDigits[n2 & 0xF]};
        return new String(cArray);
    }

    public static String shortToString(int n2) {
        char[] cArray = new char[]{hexDigits[n2 >>> 12 & 0xF], hexDigits[n2 >>> 8 & 0xF], hexDigits[n2 >>> 4 & 0xF], hexDigits[n2 & 0xF]};
        return new String(cArray);
    }

    public static String intToString(int n2) {
        char[] cArray = new char[8];
        int n3 = 7;
        while (n3 >= 0) {
            cArray[n3] = hexDigits[n2 & 0xF];
            n2 >>>= 4;
            --n3;
        }
        return new String(cArray);
    }

    public static String longToString(long l2) {
        char[] cArray = new char[16];
        int n2 = 15;
        while (n2 >= 0) {
            cArray[n2] = hexDigits[(int)l2 & 0xF];
            l2 >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    public static String dumpString(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null) {
            return string + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 > 32) {
            stringBuffer.append(string).append("Hexadecimal dump of ").append(n3).append(" bytes...\n");
        }
        int n4 = n2 + n3;
        int n5 = Integer.toString(n3).length();
        if (n5 < 4) {
            n5 = 4;
        }
        while (n2 < n4) {
            if (n3 > 32) {
                String string2 = "         " + n2;
                stringBuffer.append(string).append(string2.substring(string2.length() - n5)).append(": ");
            }
            int n6 = 0;
            while (n6 < 32 && n2 + n6 + 7 < n4) {
                stringBuffer.append(Hex.toString(byArray, n2 + n6, 8)).append(' ');
                n6 += 8;
            }
            if (n6 < 32) {
                while (n6 < 32 && n2 + n6 < n4) {
                    stringBuffer.append(Hex.byteToString(byArray[n2 + n6]));
                    ++n6;
                }
            }
            stringBuffer.append('\n');
            n2 += 32;
        }
        return stringBuffer.toString();
    }

    public static String dumpString(byte[] byArray) {
        return byArray == null ? "null\n" : Hex.dumpString(byArray, 0, byArray.length, "");
    }

    public static String dumpString(byte[] byArray, String string) {
        return byArray == null ? "null\n" : Hex.dumpString(byArray, 0, byArray.length, string);
    }

    public static String dumpString(byte[] byArray, int n2, int n3) {
        return Hex.dumpString(byArray, n2, n3, "");
    }

    public static String dumpString(int[] nArray, int n2, int n3, String string) {
        if (nArray == null) {
            return string + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 > 8) {
            stringBuffer.append(string).append("Hexadecimal dump of ").append(n3).append(" integers...\n");
        }
        int n4 = n2 + n3;
        int n5 = Integer.toString(n3).length();
        if (n5 < 8) {
            n5 = 8;
        }
        while (n2 < n4) {
            if (n3 > 8) {
                String string2 = "         " + n2;
                stringBuffer.append(string).append(string2.substring(string2.length() - n5)).append(": ");
            }
            int n6 = 0;
            while (n6 < 8 && n2 < n4) {
                stringBuffer.append(Hex.intToString(nArray[n2++])).append(' ');
                ++n6;
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String dumpString(int[] nArray) {
        return Hex.dumpString(nArray, 0, nArray.length, "");
    }

    public static String dumpString(int[] nArray, String string) {
        return Hex.dumpString(nArray, 0, nArray.length, string);
    }

    public static String dumpString(int[] nArray, int n2, int n3) {
        return Hex.dumpString(nArray, n2, n3, "");
    }

    public static void main(String[] stringArray) {
        Hex.self_test(new PrintWriter(System.out, true));
    }

    public static void self_test(PrintWriter printWriter) {
        String string = "Hello. This is a test string with more than 32 characters.";
        byte[] byArray = new byte[string.length()];
        int n2 = 0;
        while (n2 < string.length()) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        String string2 = Hex.toString(byArray);
        printWriter.println("Hex.toString(buf) = " + string2);
        byte[] byArray2 = Hex.fromString(string2);
        if (!ArrayUtil.areEqual(byArray, byArray2)) {
            System.out.println("buf != buf2");
        }
        string2 = Hex.toReversedString(byArray);
        printWriter.println("Hex.toReversedString(buf) = " + string2);
        byArray2 = Hex.fromReversedString(string2);
        if (!ArrayUtil.areEqual(byArray, byArray2)) {
            printWriter.println("buf != buf2");
        }
        printWriter.print("Hex.dumpString(buf, 0, 28) =\n" + Hex.dumpString(byArray, 0, 28));
        printWriter.print("Hex.dumpString(null) =\n" + Hex.dumpString(null));
        printWriter.print(Hex.dumpString(byArray, "+++"));
        printWriter.flush();
    }

    private Hex() {
    }
}

