/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.io;

import cryptix.util.core.Debug;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;

public class DosFilter
implements FilenameFilter {
    private static final boolean DEBUG = true;
    private static int debuglevel = Debug.getLevel("DosFilter");
    private static final PrintWriter err = Debug.getOutput();
    private char[] nameMask;
    private char[] extMask;

    private static void debug(String string) {
        err.println("DosFilter: " + string);
    }

    public boolean accept(File file, String string) {
        char c2;
        if (new File(file, string).isDirectory()) {
            return true;
        }
        if (debuglevel >= 3) {
            DosFilter.debug("filtering " + file.getAbsolutePath() + File.separator + string);
        }
        char[] cArray = null;
        char[] cArray2 = null;
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            if (this.extMask != null) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 1\n");
                }
                return false;
            }
            cArray = string.toCharArray();
        } else {
            cArray = string.substring(0, n2).toCharArray();
            cArray2 = string.substring(n2 + 1).toCharArray();
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (this.nameMask != null && n3 < cArray.length) {
            c2 = this.nameMask[n4];
            if (c2 == '*') {
                n3 = cArray.length;
                n4 = this.nameMask.length;
                continue;
            }
            if (c2 != '?' && c2 != cArray[n3]) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 2\n");
                }
                return false;
            }
            if (++n4 != this.nameMask.length || ++n3 >= cArray.length) continue;
            if (debuglevel >= 4) {
                DosFilter.debug(string + " FAILED 3\n");
            }
            return false;
        }
        bl = false;
        n3 = 0;
        n4 = 0;
        while (this.extMask != null && n3 < cArray2.length) {
            c2 = this.extMask[n4];
            if (c2 == '*') {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " OK 1\n");
                }
                return true;
            }
            if (c2 != '?' && c2 != cArray2[n3]) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 4\n");
                }
                return false;
            }
            if (++n4 != this.extMask.length || ++n3 >= cArray2.length) continue;
            if (debuglevel >= 4) {
                DosFilter.debug(string + " FAILED 5\n");
            }
            return false;
        }
        if (debuglevel >= 4) {
            DosFilter.debug(string + " OK 2\n");
        }
        return true;
    }

    public void reset() {
        this.extMask = null;
        this.nameMask = null;
    }

    public void setMask(String string) {
        int n2;
        if (string.startsWith(".")) {
            string = "*" + string;
        }
        if (string.endsWith(".")) {
            string = string + "*";
        }
        if ((n2 = string.indexOf(".")) == -1) {
            n2 = string.indexOf("*");
            this.nameMask = n2 == -1 ? string.toCharArray() : string.substring(0, n2 + 1).toCharArray();
        } else {
            String string2 = string.substring(0, n2);
            this.nameMask = (n2 = string2.indexOf("*")) == -1 ? string2.toCharArray() : string2.substring(0, n2 + 1).toCharArray();
            string2 = string.substring(n2 + 2);
            n2 = string2.indexOf("*");
            char[] cArray = this.extMask = n2 == -1 ? string2.toCharArray() : string2.substring(0, n2 + 1).toCharArray();
        }
        if (debuglevel >= 3) {
            DosFilter.debug("set filter file name: \"" + this.nameMask + "\"");
        }
        if (debuglevel >= 3) {
            DosFilter.debug("           file ext.: \"" + this.extMask + "\"");
        }
    }

    public String getMask() {
        return (this.nameMask != null ? new String(this.nameMask) : "*") + "." + (this.extMask != null ? new String(this.extMask) : "*");
    }

    public String toString() {
        return this.getMask();
    }

    public DosFilter() {
        this.reset();
    }

    public DosFilter(String string) {
        this.setMask(string);
    }
}

