/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.checksum.PRZ24;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class Base64OutputStream
extends FilterOutputStream {
    private static final int MAX_LINE_LENGTH = 64;
    private static final char[] BASE64_CHARSET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char PADDING = '=';
    private Checksum crc;
    private int crcLength;
    private byte[] inBuf;
    private int inOff;
    private int lineLength;

    public synchronized void write(int n2) throws IOException {
        this.inBuf[this.inOff++] = (byte)n2;
        if (this.crc != null) {
            this.crc.update(n2);
        }
        if (this.inOff == 3) {
            this.writeQuadruplet();
        }
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.write(byArray[n2++]);
            ++n4;
        }
    }

    public synchronized void close() throws IOException {
        this.writePadding();
        if (this.lineLength != 0) {
            this.writeln();
        }
        if (this.crc != null) {
            long l2 = this.crc.getValue();
            super.write(61);
            this.crc = null;
            int n2 = this.crcLength - 1;
            while (n2 >= 0) {
                this.write((int)(l2 >>> n2 * 8) & 0xFF);
                --n2;
            }
            this.writePadding();
            this.writeln();
        }
        super.flush();
        super.close();
    }

    private void init(Checksum checksum, int n2) {
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("length < 0 || length > 8");
        }
        this.inOff = 0;
        this.lineLength = 0;
        this.inBuf = new byte[3];
        this.crc = checksum;
        this.crcLength = n2;
    }

    private void writePadding() throws IOException {
        if (this.inOff != 0) {
            int n2 = this.inOff;
            while (n2 < 3) {
                this.inBuf[n2] = 0;
                ++n2;
            }
            this.writeQuadruplet();
        }
    }

    private void writeQuadruplet() throws IOException {
        int n2 = BASE64_CHARSET[(this.inBuf[0] & 0xFF) >> 2];
        super.write(n2);
        n2 = BASE64_CHARSET[(this.inBuf[0] & 3) << 4 | (this.inBuf[1] & 0xFF) >> 4];
        super.write(n2);
        n2 = this.inOff > 1 ? BASE64_CHARSET[(this.inBuf[1] & 0xF) << 2 | (this.inBuf[2] & 0xCF) >> 6] : 61;
        super.write(n2);
        n2 = this.inOff > 2 ? BASE64_CHARSET[this.inBuf[2] & 0x3F] : 61;
        super.write(n2);
        this.inOff = 0;
        this.lineLength += 4;
        if (this.lineLength >= 64) {
            this.writeln();
        }
    }

    private void writeln() throws IOException {
        super.write(13);
        super.write(10);
        this.lineLength = 0;
    }

    public Base64OutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.init(bl ? new PRZ24() : null, 3);
    }

    public Base64OutputStream(OutputStream outputStream) {
        super(outputStream);
        this.init(null, 0);
    }

    public Base64OutputStream(OutputStream outputStream, Checksum checksum, int n2) {
        super(outputStream);
        checksum.reset();
        this.init(checksum, n2);
    }
}

