/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private OutputStream os;
    private Cipher c;
    private byte[] encBuf;
    private byte[] ba = new byte[1];

    protected CipherOutputStream(OutputStream outputStream) {
        this(outputStream, new NullCipher());
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.os = outputStream;
        this.c = cipher;
    }

    public void close() throws IOException {
        try {
            this.encBuf = this.c.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        this.os.write(this.encBuf);
        this.os.flush();
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void write(int n2) throws IOException {
        this.ba[0] = (byte)n2;
        this.write(this.ba, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.encBuf = this.c.update(byArray, n2, n3);
        if (this.encBuf != null) {
            this.os.write(this.encBuf);
        }
    }
}

