/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("currClass", class$java$lang$String == null ? (class$java$lang$String = DescriptorSupport.class$("java.lang.String")) : class$java$lang$String)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    HashMap descriptor;
    private static final int DEFAULT_SIZE = 20;
    private static String currClass;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$String;

    public DescriptorSupport() {
        if (this.tracing()) {
            this.trace("Descriptor()", "Constructor");
        }
        this.descriptor = new HashMap(20);
    }

    public DescriptorSupport(int n2) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(maxNumFields = " + n2 + ")", "Constructor");
        }
        if (n2 <= 0) {
            if (this.tracing()) {
                this.trace("Descriptor(maxNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor field limit is invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(n2);
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        if (this.tracing()) {
            this.trace("Descriptor(Descriptor)", "Constructor");
        }
        this.descriptor = descriptorSupport == null || descriptorSupport.descriptor == null ? new HashMap(20) : new HashMap(descriptorSupport.descriptor);
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (this.tracing()) {
            this.trace("Descriptor(String ='" + string + "'", "Constructor");
        }
        if (string == null) {
            if (this.tracing()) {
                this.trace("Descriptor(String = null)", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("String in parameter is null"), "Exception occured trying to construct a descriptor");
        }
        if (string.toLowerCase().indexOf("<descriptor>") != 0 || string.toLowerCase().indexOf("</descriptor>") + 13 != string.length()) {
            throw new XMLParseException("No <descriptor> , </descriptor> pair");
        }
        this.descriptor = new HashMap(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/FIELD")) {
                if (string2 != null && string3 != null) {
                    string2 = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
                    string3 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
                    this.setField(string2.toLowerCase(), string3);
                }
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (string4.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n2 = string4.indexOf("=");
            if (n2 > 0) {
                String string5 = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string2 = string6;
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string3 = string6;
                    continue;
                }
                throw new XMLParseException("expected a field value, received '" + string4 + "'");
            }
            throw new XMLParseException("expected keyword=value, received '" + string4 + "'");
        }
        if (this.tracing()) {
            this.trace("Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Constructor");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor(String[],Object[])", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames or FieldValues are null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.setField(stringArray[i2], objectArray[i2]);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray) {
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Constructor");
        }
        if (stringArray == null || stringArray.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        this.descriptor = new HashMap(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) continue;
            int n2 = stringArray[i2].indexOf("=");
            if (n2 < 0) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: field does not have '=' as a name and value separator");
                }
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
            }
            String string = stringArray[i2].substring(0, n2);
            String string2 = null;
            if (n2 < stringArray[i2].length()) {
                string2 = stringArray[i2].substring(n2 + 1);
            }
            if (string == null || string.equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: fieldName is null");
                }
                throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no fieldName"), "Exception occured trying to construct a descriptor");
            }
            this.setField(string, string2);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Exit");
        }
    }

    public Object getFieldValue(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("getField()", "Illegal arguments: null field name.");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname requested is null"), "Exception occured trying to get a field from a descriptor");
        }
        Object v2 = this.descriptor.get(string.toLowerCase());
        if (this.tracing()) {
            this.trace("getField(" + string + ")", "Returns '" + v2 + "'");
        }
        return v2;
    }

    public void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("setField(String,String)", "Illegal arguments: null or empty field name");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname to be set is null or empty"), "Exception occured trying to set a field from a descriptor");
        }
        String string2 = string.toLowerCase();
        if (this.tracing() && object != null) {
            this.trace("setField(fieldName, fieldValue)", "Entry: setting '" + string2 + "' to '" + object + "'.");
        }
        if (!this.validateField(string2, object)) {
            if (this.tracing()) {
                this.trace("setField(fieldName,FieldValue)", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Field value invalid: " + string2 + "=" + object), "Field " + string2 + "=" + object + " is invalid. Exception occured trying to set a field from a descriptor");
        }
        this.descriptor.put(string2, object);
        if (this.tracing()) {
            this.trace("setField(fieldName, fieldValue)", "Exit");
        }
    }

    public String[] getFields() {
        if (this.tracing()) {
            this.trace("getFields()", "Entry");
        }
        if (this.descriptor == null) {
            return new String[0];
        }
        int n2 = this.descriptor.size();
        if (n2 == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n2];
        Set set = this.descriptor.entrySet();
        if (set == null) {
            if (this.tracing()) {
                this.trace("getFields()", "No fields found in descriptor");
            }
            return new String[0];
        }
        int n3 = 0;
        Object object = null;
        Map.Entry entry = null;
        if (this.tracing()) {
            this.trace("getFields()", "Returning " + n2 + " fields");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry == null) {
                if (this.tracing()) {
                    this.trace("getFields()", "Element is null");
                }
            } else {
                object = entry.getValue();
                stringArray[n3] = object == null ? entry.getKey() + "=" : (object instanceof String ? entry.getKey() + "=" + object.toString() : entry.getKey() + "=(" + object.toString() + ")");
            }
            ++n3;
        }
        if (this.tracing()) {
            this.trace("getFields()", "Exit");
        }
        return stringArray;
    }

    public String[] getFieldNames() {
        if (this.tracing()) {
            this.trace("getFieldNames()", "Entry");
        }
        if (this.descriptor == null) {
            return new String[0];
        }
        int n2 = this.descriptor.size();
        String[] stringArray = new String[n2];
        Set set = this.descriptor.entrySet();
        if (set == null || n2 == 0) {
            if (this.tracing()) {
                this.trace("getFieldNames()", "no descriptor fields found");
            }
            return new String[0];
        }
        int n3 = 0;
        if (this.tracing()) {
            this.trace("getFieldNames()", "Returning " + n2 + " fields");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getKey() == null) {
                if (this.tracing()) {
                    this.trace("getFieldNames()", "Field is null");
                }
            } else {
                stringArray[n3] = entry.getKey().toString();
            }
            ++n3;
        }
        if (this.tracing()) {
            this.trace("getFieldNames()", "Exit");
        }
        return stringArray;
    }

    public Object[] getFieldValues(String[] stringArray) {
        if (this.tracing()) {
            this.trace("getFieldValues(fieldNames)", "Entry");
        }
        if (this.descriptor == null || stringArray != null && stringArray.length == 0) {
            return new Object[0];
        }
        int n2 = this.descriptor.size();
        Set set = this.descriptor.entrySet();
        if (set == null || n2 == 0) {
            if (this.tracing()) {
                this.trace("getFieldValues()", "no descriptor fields found");
            }
            return new Object[0];
        }
        Object[] objectArray = stringArray != null ? new Object[stringArray.length] : new Object[n2];
        int n3 = 0;
        if (this.tracing()) {
            this.trace("getFieldValues()", "Returning " + n2 + " fields");
        }
        if (stringArray == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry == null || entry.getKey() == null) {
                    if (this.tracing()) {
                        this.trace("getFieldValues()", "Field is null");
                    }
                    objectArray[n3] = null;
                } else {
                    objectArray[n3] = entry.getValue();
                }
                ++n3;
            }
        } else {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                objectArray[n3] = stringArray[n3] == null || stringArray[n3].equals("") ? null : this.getFieldValue(stringArray[n3]);
            }
        }
        if (this.tracing()) {
            this.trace("getFieldValues()", "Exit");
        }
        return objectArray;
    }

    public void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("setFields(fieldNames, ObjectValues)", "Entry");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor.setFields(String[],Object[])", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames and FieldValues are null or invalid"), "Exception occured trying to set object fields a descriptor");
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray[i2].equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor.setFields(String[],Object[])", "Null field name encountered at " + i2 + " element");
                }
                throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames is null or invalid"), "Exception occured trying to set object fields a descriptor");
            }
            this.setField(stringArray[i2], objectArray[i2]);
        }
        if (this.tracing()) {
            this.trace("Descriptor.setFields(fieldNames, fieldObjects)", "Exit");
        }
    }

    public Object clone() throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor.clone()", "Executed");
        }
        return new DescriptorSupport(this);
    }

    public void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        Set set = this.descriptor.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.descriptor.remove(string2);
            break;
        }
    }

    public boolean isValid() throws RuntimeOperationsException {
        Set set;
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "Executed");
        }
        if ((set = this.descriptor.entrySet()) == null) {
            if (this.tracing()) {
                this.trace("Descriptor.isValid()", "returns false (null set)");
            }
            return false;
        }
        String string = (String)this.getFieldValue("name");
        String string2 = (String)this.getFieldValue("descriptorType");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || this.validateField(entry.getKey().toString(), entry.getValue().toString())) continue;
            if (this.tracing()) {
                this.trace("isValid()", "Field " + entry.getKey().toString() + "=" + entry.getValue().toString() + " is not valid");
            }
            return false;
        }
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "returns true");
        }
        return true;
    }

    private boolean validateField(String string, Object object) {
        boolean bl;
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl2 = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl2 = true;
        }
        boolean bl3 = bl = string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType");
        if (bl || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            if (object == null || !bl2) {
                return false;
            }
            return !bl || !string2.equals("");
        }
        if (string.equalsIgnoreCase("visibility")) {
            long l2;
            if (object != null && bl2) {
                l2 = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                l2 = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l2 >= 1L && l2 <= 4L;
        }
        if (string.equalsIgnoreCase("severity")) {
            long l3;
            if (object != null && bl2) {
                l3 = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                l3 = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l3 >= 0L && l3 <= 6L;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl2 && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            long l4;
            if (object != null && bl2) {
                l4 = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                l4 = ((Integer)object).intValue();
            } else {
                return false;
            }
            return l4 >= -1L;
        }
        if (string.equalsIgnoreCase("log")) {
            return object instanceof Boolean || bl2 && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }

    public String toXMLString() {
        if (this.tracing()) {
            this.trace("Descriptor.toXMLString()", "Executed");
        }
        String string = "<Descriptor>";
        Set set = this.descriptor.entrySet();
        if (set == null) {
            if (this.tracing()) {
                this.trace("Descriptor.toXMLString()", "returnedSet is null");
            }
            string = string + "</Descriptor>";
            return string;
        }
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null) {
                if (this.tracing()) {
                    this.trace("Descriptor.toXMLString()", "Element is null");
                }
            } else {
                Object v2 = entry.getValue();
                string = v2 == null ? string + "<field name=\"" + entry.getKey().toString() + "\" value=\"null\"></field>" : (v2 instanceof String ? string + "<field name=\"" + entry.getKey().toString() + "\" value=\"" + v2 + "\"></field>" : string + "<field name=\"" + entry.getKey().toString() + "\" value=\"" + "(" + v2.toString() + ")" + "\"></field>");
            }
            ++n2;
        }
        string = string + "</Descriptor>";
        if (this.tracing()) {
            this.trace("Descriptor.toXMLString()", "Returns " + string);
        }
        return string;
    }

    public String toString() {
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Entry");
        }
        String string = "";
        String[] stringArray = this.getFields();
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Printing " + stringArray.length + " fields");
        }
        if (stringArray == null || stringArray.length == 0) {
            if (this.tracing()) {
                this.trace("Descriptor.toString()", "Empty Descriptor");
            }
            return string;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = i2 == stringArray.length - 1 ? string.concat(stringArray[i2]) : string.concat(stringArray[i2] + ", ");
        }
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Exit returning " + string);
        }
        return string;
    }

    private long toNumeric(String string) {
        long l2 = -2L;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            return -2L;
        }
        return l2;
    }

    private boolean tracing() {
        return Trace.isSelected(1, 128);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, Integer.toHexString(this.hashCode()) + " " + string3);
    }

    private void trace(String string, String string2) {
        this.trace(currClass, string, string2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("descriptor", this.descriptor);
            putField.put("currClass", currClass);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 8071560848919417985L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6292969195866300415L;
        }
        currClass = "DescriptorSupport";
    }
}

