/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number[] threshold = new Number[16];
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private boolean notify = false;
    private boolean differenceMode = false;
    private transient Number initThreshold = new Integer(0);
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanCounter = new Number[16];
    private transient boolean[] modulusExceeded = new boolean[16];
    private transient Number[] derivedGaugeExceeded = new Number[16];
    private transient boolean[] eventAlreadyNotified = new boolean[16];
    private transient int[] type = new int[16];
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "CounterMonitor";
    }

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.threshold[i2] = this.initThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.isActive()) {
                if (this.isTraceOn()) {
                    this.trace("start", "the counter monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.threshold[i2] = this.initThreshold;
                this.modulusExceeded[i2] = false;
                this.eventAlreadyNotified[i2] = false;
                this.previousScanCounter[i2] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.isTraceOn()) {
                this.trace("stop", "the counter monitor is not started");
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long l2) throws IllegalArgumentException {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            super.setGranularityPeriod(l2);
            if (this.isActive()) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getDerivedGauge(ObjectName objectName) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int n2 = this.indexOf(objectName);
            if (n2 != -1) {
                return this.derivedGauge[n2];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int n2 = this.indexOf(objectName);
            if (n2 != -1) {
                return this.derivedGaugeTimestamp[n2];
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getThreshold(ObjectName objectName) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            int n2 = this.indexOf(objectName);
            if (n2 != -1) {
                return this.threshold[n2];
            }
            return null;
        }
    }

    public Number getInitThreshold() {
        return this.initThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The threshold cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.initThreshold = number;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.threshold[i2] = number;
                this.resetAlreadyNotified(i2, 16);
                this.modulusExceeded[i2] = false;
                this.eventAlreadyNotified[i2] = false;
            }
        }
    }

    public Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public Number getThreshold() {
        return this.threshold[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreshold(Number number) throws IllegalArgumentException {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.setInitThreshold(number);
        }
    }

    public Number getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The offset cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The offset must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.offset = number;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.resetAlreadyNotified(i2, 16);
            }
        }
    }

    public Number getModulus() {
        return this.modulus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The modulus cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The modulus must be greater than or equal to zero.");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.modulus = number;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.resetAlreadyNotified(i2, 16);
                this.modulusExceeded[i2] = false;
            }
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotify(boolean bl) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.notify = bl;
        }
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDifferenceMode(boolean bl) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.differenceMode = bl;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.threshold[i2] = this.initThreshold;
                this.modulusExceeded[i2] = false;
                this.eventAlreadyNotified[i2] = false;
                this.previousScanCounter[i2] = null;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDerivedGauge(Object object, int n2) {
        this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            boolean bl;
            if (this.differenceMode) {
                if (this.previousScanCounter[n2] != null) {
                    this.setDerivedGaugeWithDifference((Number)object, null, n2);
                    if (this.derivedGauge[n2].longValue() < 0L) {
                        if (this.modulus.longValue() > 0L) {
                            this.setDerivedGaugeWithDifference((Number)object, this.modulus, n2);
                        }
                        this.threshold[n2] = this.initThreshold;
                        this.eventAlreadyNotified[n2] = false;
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                this.previousScanCounter[n2] = (Number)object;
            } else {
                this.derivedGauge[n2] = (Number)object;
                bl = true;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n2) {
        boolean bl = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.eventAlreadyNotified[n2]) {
                if (this.derivedGauge[n2].longValue() >= this.threshold[n2].longValue()) {
                    if (this.notify) {
                        bl = true;
                        string = MonitorNotification.THRESHOLD_VALUE_EXCEEDED;
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        number = this.derivedGauge[n2];
                        number2 = this.threshold[n2];
                    }
                    this.eventAlreadyNotified[n2] = true;
                }
            } else if (this.isTraceOn()) {
                this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject(n2) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge[n2] + "has already been sent");
            }
        }
        if (bl) {
            this.sendNotification(string, l2, string2, number, number2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreshold(int n2) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (this.derivedGauge[n2].longValue() >= this.threshold[n2].longValue()) {
                if (this.offset.longValue() > 0L) {
                    long l2;
                    for (l2 = this.threshold[n2].longValue(); this.derivedGauge[n2].longValue() >= l2; l2 += this.offset.longValue()) {
                    }
                    switch (this.type[n2]) {
                        case 0: {
                            this.threshold[n2] = new Integer((int)l2);
                            break;
                        }
                        case 1: {
                            this.threshold[n2] = new Byte((byte)l2);
                            break;
                        }
                        case 2: {
                            this.threshold[n2] = new Short((short)l2);
                            break;
                        }
                        case 3: {
                            this.threshold[n2] = new Long(l2);
                            break;
                        }
                        default: {
                            if (!this.isDebugOn()) break;
                            this.debug("updateThreshold", "the threshold type is invalid");
                        }
                    }
                    if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[n2].longValue() > this.modulus.longValue()) {
                        this.modulusExceeded[n2] = true;
                        this.derivedGaugeExceeded[n2] = this.derivedGauge[n2];
                    }
                    this.eventAlreadyNotified[n2] = false;
                } else {
                    this.modulusExceeded[n2] = true;
                    this.derivedGaugeExceeded[n2] = this.derivedGauge[n2];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThresholdTypeValid(int n2) {
        boolean bl = false;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            switch (this.type[n2]) {
                case 0: {
                    if (!(this.threshold[n2] instanceof Integer) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Integer) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Integer)) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(this.threshold[n2] instanceof Byte) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Byte) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Byte)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!(this.threshold[n2] instanceof Short) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Short) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Short)) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (!(this.threshold[n2] instanceof Long) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Long) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Long)) break;
                    bl = true;
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("isThresholdTypeValid", "the threshold type is invalid");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDerivedGaugeWithDifference(Number number, Number number2, int n2) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            switch (this.type[n2]) {
                case 0: {
                    if (number2 == null) {
                        this.derivedGauge[n2] = new Integer((Integer)number - (Integer)this.previousScanCounter[n2]);
                        break;
                    }
                    this.derivedGauge[n2] = new Integer((Integer)number - (Integer)this.previousScanCounter[n2] + (Integer)this.modulus);
                    break;
                }
                case 1: {
                    if (number2 == null) {
                        this.derivedGauge[n2] = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter[n2]));
                        break;
                    }
                    this.derivedGauge[n2] = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter[n2] + (Byte)this.modulus));
                    break;
                }
                case 2: {
                    if (number2 == null) {
                        this.derivedGauge[n2] = new Short((short)((Short)number - (Short)this.previousScanCounter[n2]));
                        break;
                    }
                    this.derivedGauge[n2] = new Short((short)((Short)number - (Short)this.previousScanCounter[n2] + (Short)this.modulus));
                    break;
                }
                case 3: {
                    if (number2 == null) {
                        this.derivedGauge[n2] = new Long((Long)number - (Long)this.previousScanCounter[n2]);
                        break;
                    }
                    this.derivedGauge[n2] = new Long((Long)number - (Long)this.previousScanCounter[n2] + (Long)this.modulus);
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n2) {
        boolean bl = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        Number number = null;
        Object var8_7 = null;
        Object object = null;
        String string3 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            block32: {
                try {
                    boolean bl2;
                    if (!this.isActive()) break block32;
                    if (this.getObservedObject(n2) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        object = this.server.getAttribute(this.getObservedObject(n2), this.getObservedAttribute());
                        if (object == null) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if ((this.alreadyNotifieds[n2] & 8) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(n2, 8);
                        throw new MonitorSettingException("The counter monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if ((this.alreadyNotifieds[n2] & 1) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_OBJECT_ERROR;
                        this.setAlreadyNotified(n2, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if ((this.alreadyNotifieds[n2] & 2) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(n2, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mBeanException) {
                        if ((this.alreadyNotifieds[n2] & 8) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(n2, 8);
                        throw new MonitorSettingException(mBeanException.getMessage());
                    }
                    catch (ReflectionException reflectionException) {
                        if ((this.alreadyNotifieds[n2] & 2) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(n2, 2);
                        throw new MonitorSettingException(reflectionException.getMessage());
                    }
                    if (object instanceof Integer) {
                        this.type[n2] = 0;
                    } else if (object instanceof Byte) {
                        this.type[n2] = 1;
                    } else if (object instanceof Short) {
                        this.type[n2] = 2;
                    } else if (object instanceof Long) {
                        this.type[n2] = 3;
                    } else {
                        if ((this.alreadyNotifieds[n2] & 4) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                        this.setAlreadyNotified(n2, 4);
                        throw new MonitorSettingException("The observed attribute type must be an integer type.");
                    }
                    if (!this.isThresholdTypeValid(n2)) {
                        if ((this.alreadyNotifieds[n2] & 0x10) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.THRESHOLD_ERROR;
                        this.setAlreadyNotified(n2, 16);
                        throw new MonitorSettingException("The threshold, offset and modulus must be of the same type as the counter.");
                    }
                    this.resetAllAlreadyNotified(n2);
                    if (this.modulusExceeded[n2] && this.derivedGauge[n2].longValue() < this.derivedGaugeExceeded[n2].longValue()) {
                        this.threshold[n2] = this.initThreshold;
                        this.modulusExceeded[n2] = false;
                        this.eventAlreadyNotified[n2] = false;
                    }
                    if (bl2 = this.updateDerivedGauge(object, n2)) {
                        this.updateNotifications(n2);
                        this.updateThreshold(n2);
                    }
                }
                catch (MonitorSettingException monitorSettingException) {
                    bl = true;
                    string = string3;
                    l2 = this.derivedGaugeTimestamp[n2];
                    string2 = monitorSettingException.getMessage();
                    number = this.derivedGauge[n2];
                    var8_7 = null;
                    this.modulusExceeded[n2] = false;
                    this.eventAlreadyNotified[n2] = false;
                    this.previousScanCounter[n2] = null;
                }
            }
        }
        if (bl) {
            this.sendNotification(string, l2, string2, number, var8_7, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int n2) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            Integer n3 = new Integer(0);
            this.insertNumberElementAt(this.threshold, n3, n2);
            this.insertNumberElementAt(this.derivedGauge, n3, n2);
            this.insertNumberElementAt(this.previousScanCounter, null, n2);
            this.insertNumberElementAt(this.derivedGaugeExceeded, null, n2);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n2);
            this.insertbooleanElementAt(this.modulusExceeded, false, n2);
            this.insertbooleanElementAt(this.eventAlreadyNotified, false, n2);
            this.insertintElementAt(this.type, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int n2) {
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            this.removeNumberElementAt(this.threshold, n2);
            this.removeNumberElementAt(this.derivedGauge, n2);
            this.removeNumberElementAt(this.previousScanCounter, n2);
            this.removeNumberElementAt(this.derivedGaugeExceeded, n2);
            this.removelongElementAt(this.derivedGaugeTimestamp, n2);
            this.removebooleanElementAt(this.modulusExceeded, n2);
            this.removebooleanElementAt(this.eventAlreadyNotified, n2);
            this.removeintElementAt(this.type, n2);
        }
    }

    private static class CounterAlarmClock
    extends TimerTask {
        CounterMonitor listener = null;

        public CounterAlarmClock(CounterMonitor counterMonitor) {
            this.listener = counterMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i2 = 0; i2 < this.listener.elementCount; ++i2) {
                    this.listener.notifyAlarmClock(i2);
                }
            }
        }
    }
}

