/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseClientDetails
implements ClientDetails {
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> scope = Collections.emptySet();
    @JsonProperty(value="resource_ids")
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> resourceIds = Collections.emptySet();
    @JsonProperty(value="authorized_grant_types")
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> authorizedGrantTypes = Collections.emptySet();
    @JsonProperty(value="redirect_uri")
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> registeredRedirectUris;
    @JsonProperty(value="autoapprove")
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> autoApproveScopes;
    private List<GrantedAuthority> authorities = Collections.emptyList();
    @JsonProperty(value="access_token_validity")
    private Integer accessTokenValiditySeconds;
    @JsonProperty(value="refresh_token_validity")
    private Integer refreshTokenValiditySeconds;
    @JsonIgnore
    private Map<String, Object> additionalInformation = new LinkedHashMap<String, Object>();

    public BaseClientDetails() {
    }

    public BaseClientDetails(ClientDetails prototype) {
        this();
        this.setAccessTokenValiditySeconds(prototype.getAccessTokenValiditySeconds());
        this.setRefreshTokenValiditySeconds(prototype.getRefreshTokenValiditySeconds());
        this.setAuthorities(prototype.getAuthorities());
        this.setAuthorizedGrantTypes(prototype.getAuthorizedGrantTypes());
        this.setClientId(prototype.getClientId());
        this.setClientSecret(prototype.getClientSecret());
        this.setRegisteredRedirectUri(prototype.getRegisteredRedirectUri());
        this.setScope(prototype.getScope());
        this.setResourceIds(prototype.getResourceIds());
    }

    public BaseClientDetails(String clientId, String resourceIds, String scopes, String grantTypes, String authorities) {
        this(clientId, resourceIds, scopes, grantTypes, authorities, null);
    }

    public BaseClientDetails(String clientId, String resourceIds, String scopes, String grantTypes, String authorities, String redirectUris) {
        Set scopeList;
        Set resources;
        this.clientId = clientId;
        if (StringUtils.hasText((String)resourceIds) && !(resources = StringUtils.commaDelimitedListToSet((String)resourceIds)).isEmpty()) {
            this.resourceIds = resources;
        }
        if (StringUtils.hasText((String)scopes) && !(scopeList = StringUtils.commaDelimitedListToSet((String)scopes)).isEmpty()) {
            this.scope = scopeList;
        }
        this.authorizedGrantTypes = StringUtils.hasText((String)grantTypes) ? StringUtils.commaDelimitedListToSet((String)grantTypes) : new HashSet<String>(Arrays.asList("authorization_code", "refresh_token"));
        if (StringUtils.hasText((String)authorities)) {
            this.authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
        }
        if (StringUtils.hasText((String)redirectUris)) {
            this.registeredRedirectUris = StringUtils.commaDelimitedListToSet((String)redirectUris);
        }
    }

    @Override
    @JsonIgnore
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoApproveScopes(Set<String> autoApproveScopes) {
        this.autoApproveScopes = autoApproveScopes;
    }

    @Override
    public boolean isAutoApprove(String scope) {
        if (this.autoApproveScopes == null) {
            return false;
        }
        for (String auto : this.autoApproveScopes) {
            if (!auto.equals("true") && !scope.matches(auto)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    @Override
    @JsonIgnore
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    @JsonIgnore
    public boolean isScoped() {
        return this.scope != null && !this.scope.isEmpty();
    }

    @Override
    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Collection<String> scope) {
        this.scope = scope == null ? Collections.emptySet() : new LinkedHashSet<String>(scope);
    }

    @Override
    @JsonIgnore
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        this.resourceIds = resourceIds == null ? Collections.emptySet() : new LinkedHashSet<String>(resourceIds);
    }

    @Override
    @JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(Collection<String> authorizedGrantTypes) {
        this.authorizedGrantTypes = new LinkedHashSet<String>(authorizedGrantTypes);
    }

    @Override
    @JsonIgnore
    public Set<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUris;
    }

    public void setRegisteredRedirectUri(Set<String> registeredRedirectUris) {
        this.registeredRedirectUris = registeredRedirectUris == null ? null : new LinkedHashSet<String>(registeredRedirectUris);
    }

    @JsonProperty(value="authorities")
    private List<String> getAuthoritiesAsStrings() {
        return new ArrayList<String>(AuthorityUtils.authorityListToSet(this.authorities));
    }

    @JsonProperty(value="authorities")
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private void setAuthoritiesAsStrings(Set<String> values) {
        this.setAuthorities(AuthorityUtils.createAuthorityList((String[])values.toArray(new String[values.size()])));
    }

    @Override
    @JsonIgnore
    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @JsonIgnore
    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = new ArrayList<GrantedAuthority>(authorities);
    }

    @Override
    @JsonIgnore
    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @Override
    @JsonIgnore
    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setAdditionalInformation(Map<String, ?> additionalInformation) {
        this.additionalInformation = new LinkedHashMap(additionalInformation);
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalInformation() {
        return Collections.unmodifiableMap(this.additionalInformation);
    }

    @JsonAnySetter
    public void addAdditionalInformation(String key, Object value) {
        this.additionalInformation.put(key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenValiditySeconds == null ? 0 : this.accessTokenValiditySeconds);
        result = 31 * result + (this.refreshTokenValiditySeconds == null ? 0 : this.refreshTokenValiditySeconds);
        result = 31 * result + (this.authorities == null ? 0 : this.authorities.hashCode());
        result = 31 * result + (this.authorizedGrantTypes == null ? 0 : this.authorizedGrantTypes.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.registeredRedirectUris == null ? 0 : this.registeredRedirectUris.hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : this.resourceIds.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + this.additionalInformation.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseClientDetails other = (BaseClientDetails)obj;
        if (this.accessTokenValiditySeconds != other.accessTokenValiditySeconds) {
            return false;
        }
        if (this.refreshTokenValiditySeconds != other.refreshTokenValiditySeconds) {
            return false;
        }
        if (this.authorities == null ? other.authorities != null : !this.authorities.equals(other.authorities)) {
            return false;
        }
        if (this.authorizedGrantTypes == null ? other.authorizedGrantTypes != null : !this.authorizedGrantTypes.equals(other.authorizedGrantTypes)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.registeredRedirectUris == null ? other.registeredRedirectUris != null : !this.registeredRedirectUris.equals(other.registeredRedirectUris)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !this.resourceIds.equals(other.resourceIds)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.additionalInformation == null ? other.additionalInformation != null : !this.additionalInformation.equals(other.additionalInformation));
    }

    public String toString() {
        return "BaseClientDetails [clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", resourceIds=" + this.resourceIds + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", registeredRedirectUris=" + this.registeredRedirectUris + ", authorities=" + this.authorities + ", accessTokenValiditySeconds=" + this.accessTokenValiditySeconds + ", refreshTokenValiditySeconds=" + this.refreshTokenValiditySeconds + ", additionalInformation=" + this.additionalInformation + "]";
    }

    public static class ArrayOrStringDeserializer
    extends StdDeserializer<Set<String>> {
        public ArrayOrStringDeserializer() {
            super(Set.class);
        }

        public JavaType getValueType() {
            return SimpleType.construct(String.class);
        }

        public Set<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken token = jp.getCurrentToken();
            if (token.isScalarValue()) {
                String list = jp.getText();
                list = list.replaceAll("\\s+", ",");
                return new LinkedHashSet<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)list)));
            }
            return (Set)jp.readValueAs((TypeReference)new TypeReference<Set<String>>(){});
        }
    }
}

