/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;

public class DefaultAccessTokenConverter
implements AccessTokenConverter {
    private static final String AUD = "aud";
    private static final String CLIENT_ID = "client_id";
    private static final String EXP = "exp";
    private static final String JTI = "jti";
    private static final String SCOPE = "scope";
    private UserAuthenticationConverter userTokenConverter = new DefaultUserAuthenticationConverter();

    @Override
    public Map<String, ?> convertAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        OAuth2Request clientToken = authentication.getOAuth2Request();
        if (!authentication.isClientOnly()) {
            response.putAll(this.userTokenConverter.convertUserAuthentication(authentication.getUserAuthentication()));
        }
        response.put(SCOPE, token.getScope());
        if (token.getAdditionalInformation().containsKey(JTI)) {
            response.put(JTI, token.getAdditionalInformation().get(JTI));
        }
        if (token.getExpiration() != null) {
            response.put(EXP, token.getExpiration().getTime() / 1000L);
        }
        response.putAll(token.getAdditionalInformation());
        response.put(CLIENT_ID, clientToken.getClientId());
        if (clientToken.getResourceIds() != null && !clientToken.getResourceIds().isEmpty()) {
            response.put(AUD, clientToken.getResourceIds());
        }
        return response;
    }

    @Override
    public OAuth2AccessToken extractAccessToken(String value, Map<String, ?> map) {
        Collection scope;
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken(value);
        HashMap<String, Object> info = new HashMap<String, Object>(map);
        info.remove(EXP);
        info.remove(AUD);
        info.remove(CLIENT_ID);
        info.remove(SCOPE);
        if (map.containsKey(EXP)) {
            token.setExpiration(new Date((long)((Integer)map.get(EXP)).intValue() * 1000L));
        }
        if (map.containsKey(JTI)) {
            info.put(JTI, map.get(JTI));
        }
        if ((scope = (Collection)map.get(SCOPE)) != null) {
            token.setScope(new HashSet<String>(scope));
        }
        token.setAdditionalInformation(info);
        return token;
    }

    @Override
    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        LinkedHashSet<String> scope = new LinkedHashSet<String>(map.containsKey(SCOPE) ? (Collection)map.get(SCOPE) : Collections.emptySet());
        Authentication user = this.userTokenConverter.extractAuthentication(map);
        String clientId = (String)map.get(CLIENT_ID);
        parameters.put(CLIENT_ID, clientId);
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>(map.containsKey(AUD) ? (Collection)map.get(AUD) : Collections.emptySet());
        OAuth2Request request = new OAuth2Request(parameters, clientId, null, true, scope, resourceIds, null, null, null);
        return new OAuth2Authentication(request, user);
    }
}

