/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.exceptions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

public class OAuth2ExceptionJackson2Serializer
extends StdSerializer<OAuth2Exception> {
    public OAuth2ExceptionJackson2Serializer() {
        super(OAuth2Exception.class);
    }

    public void serialize(OAuth2Exception value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("error", value.getOAuth2ErrorCode());
        jgen.writeStringField("error_description", value.getMessage());
        if (value.getAdditionalInformation() != null) {
            for (Map.Entry<String, String> entry : value.getAdditionalInformation().entrySet()) {
                String key = entry.getKey();
                String add = entry.getValue();
                jgen.writeStringField(key, add);
            }
        }
        jgen.writeEndObject();
    }
}

