/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.client;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;

public class InMemoryClientDetailsService
implements ClientDetailsService {
    private Map<String, ClientDetails> clientDetailsStore = new HashMap<String, ClientDetails>();

    @Override
    public ClientDetails loadClientByClientId(String clientId) throws OAuth2Exception {
        ClientDetails details = this.clientDetailsStore.get(clientId);
        if (details == null) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        return details;
    }

    public void setClientDetailsStore(Map<String, ? extends ClientDetails> clientDetailsStore) {
        this.clientDetailsStore = new HashMap<String, ClientDetails>(clientDetailsStore);
    }
}

