/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.navigator.menu.Component;
import net.sf.navigator.menu.MenuBase;
import org.apache.commons.lang.StringUtils;

public class MenuComponent
extends MenuBase
implements Serializable,
Component {
    protected static MenuComponent[] _menuComponent = new MenuComponent[0];
    protected List menuComponents = Collections.synchronizedList(new ArrayList());
    protected MenuComponent parentMenu;
    private boolean last;
    private String breadCrumb;

    public void addMenuComponent(MenuComponent menuComponent) {
        if (menuComponent.getName() == null || menuComponent.getName().equals("")) {
            menuComponent.setName(this.name + this.menuComponents.size());
        }
        if (!this.menuComponents.contains(menuComponent)) {
            this.menuComponents.add(menuComponent);
            menuComponent.setParent(this);
        }
    }

    public MenuComponent[] getMenuComponents() {
        return this.menuComponents.toArray(_menuComponent);
    }

    public void setMenuComponents(MenuComponent[] menuComponents) {
        for (int i = 0; i < menuComponents.length; ++i) {
            MenuComponent component = menuComponents[i];
            this.menuComponents.add(component);
        }
    }

    public void setParent(MenuComponent parentMenu) {
        if (parentMenu != null && !parentMenu.getComponents().contains(this)) {
            parentMenu.addMenuComponent(this);
        }
        this.parentMenu = parentMenu;
    }

    public MenuComponent getParent() {
        return this.parentMenu;
    }

    public List getComponents() {
        return this.menuComponents;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MenuComponent)) {
            return false;
        }
        MenuComponent m = (MenuComponent)o;
        return StringUtils.equals((String)m.getAction(), (String)this.action) && StringUtils.equals((String)m.getAlign(), (String)this.align) && StringUtils.equals((String)m.getAltImage(), (String)this.altImage) && StringUtils.equals((String)m.getDescription(), (String)this.description) && StringUtils.equals((String)m.getForward(), (String)this.forward) && StringUtils.equals((String)m.getHeight(), (String)this.height) && StringUtils.equals((String)m.getImage(), (String)this.image) && StringUtils.equals((String)m.getLocation(), (String)this.location) && StringUtils.equals((String)m.getName(), (String)this.name) && StringUtils.equals((String)m.getOnclick(), (String)this.onclick) && StringUtils.equals((String)m.getOndblclick(), (String)this.ondblclick) && StringUtils.equals((String)m.getOnmouseout(), (String)this.onmouseout) && StringUtils.equals((String)m.getOnmouseover(), (String)this.onmouseover) && StringUtils.equals((String)m.getOnContextMenu(), (String)this.onContextMenu) && StringUtils.equals((String)m.getPage(), (String)this.page) && StringUtils.equals((String)m.getRoles(), (String)this.roles) && StringUtils.equals((String)m.getTarget(), (String)this.target) && StringUtils.equals((String)m.getTitle(), (String)this.title) && StringUtils.equals((String)m.getToolTip(), (String)this.toolTip) && StringUtils.equals((String)m.getWidth(), (String)this.width) && StringUtils.equals((String)m.getModule(), (String)this.module);
    }

    public int getMenuDepth() {
        return this.getMenuDepth(this, 0);
    }

    private int getMenuDepth(MenuComponent menu, int currentDepth) {
        int depth = currentDepth + 1;
        MenuComponent[] subMenus = menu.getMenuComponents();
        if (subMenus != null) {
            for (int a = 0; a < subMenus.length; ++a) {
                int depthx = this.getMenuDepth(subMenus[a], currentDepth + 1);
                if (depth >= depthx) continue;
                depth = depthx;
            }
        }
        return depth;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void removeChildren() {
        Iterator iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            MenuComponent child = (MenuComponent)iterator.next();
            child.setParent(null);
            iterator.remove();
        }
    }

    public String getBreadCrumb() {
        return this.breadCrumb;
    }

    protected void setBreadCrumb(String delimiter) {
        if (this.getParent() == null) {
            this.breadCrumb = this.name;
            this.setChildBreadCrumb(delimiter);
        } else {
            MenuComponent parent = this.getParent();
            this.breadCrumb = parent.getBreadCrumb() + delimiter + this.name;
            this.setChildBreadCrumb(delimiter);
        }
    }

    private void setChildBreadCrumb(String delimiter) {
        List children = this.getComponents();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            MenuComponent child = (MenuComponent)iterator.next();
            child.setBreadCrumb(delimiter);
        }
    }

    public String toString() {
        return "name: " + this.name;
    }
}

