/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.AvailableConnections;
import oracle.ucp.common.ConnectionHarvestingComparator;
import oracle.ucp.common.ConnectionsContainer;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalConnectionPoolStatisticsImpl;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversalConnectionPoolImpl
extends UniversalConnectionPoolBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolImpl.class.getCanonicalName());
    public final UniversalConnectionPoolInternal m_ucpInternal = new UniversalConnectionPoolInternal(this);

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    @Override
    protected UniversalPooledConnection[] getInUseConnectionsArray() {
        return this.m_ucpInternal.getInUseConnectionsArrayInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        this.m_pendingRequestsCount.incrementAndGet();
        try {
            UniversalPooledConnection universalPooledConnection = this.borrowConnectionWithoutCountingRequests(connectionRetrievalInfo);
            return universalPooledConnection;
        }
        finally {
            this.m_pendingRequestsCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UniversalPooledConnection borrowConnectionWithoutCountingRequests(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        Object object;
        assert (cri != null);
        if (cri.getLabels() != null && this.getConnectionLabelingCallback() == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(92);
        }
        long timeToWait = this.getConnectionWaitTimeout() * 1000;
        boolean allBorrowed = false;
        UniversalPooledConnection pooledConnection = null;
        boolean isAbleToCreateConnection = false;
        long startWait = System.currentTimeMillis();
        this.m_skipPoolGrowing.set(false);
        while (this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
            long begTime = System.currentTimeMillis();
            this.validatePoolSizes();
            boolean toWait = false;
            object = this;
            synchronized (object) {
                pooledConnection = this.getValidAvailableConnection(cri);
                if (pooledConnection != null) {
                    break;
                }
                allBorrowed = ((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections - this.m_ucpInternal.m_availableConnections.getNumAvailableConnections() >= this.getMaxPoolSize();
                boolean bl = toWait = allBorrowed && timeToWait > 0L;
                if (!toWait) {
                    if (this.m_ucpInternal.m_connectionsContainer.isThereRoomToGrowPool()) {
                        isAbleToCreateConnection = true;
                    } else if (this.m_ucpInternal.m_availableConnections.getNumAvailableConnections() - this.m_ucpInternal.m_availableConnections.getNumAvailableLabeledConnections() > 0) {
                        this.makeRoomInThePool();
                        isAbleToCreateConnection = true;
                    }
                    if (isAbleToCreateConnection) {
                        this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
                        break;
                    }
                }
            }
            if (toWait) {
                try {
                    this.m_borrowRequestQueue.waitAvailable(cri, timeToWait);
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINEST, "calling wait", e);
                }
            }
            if (timeToWait <= 0L) break;
            timeToWait -= System.currentTimeMillis() - begTime;
        }
        if (this.m_lifeCycleState.get() != UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
            if (isAbleToCreateConnection) {
                UniversalConnectionPoolImpl begTime = this;
                synchronized (begTime) {
                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                }
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        if (allBorrowed && pooledConnection == null) {
            if (isAbleToCreateConnection) {
                UniversalConnectionPoolImpl begTime = this;
                synchronized (begTime) {
                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                }
            }
            this.updateConnectionWaitCounters(startWait);
            UCPErrorHandler.throwUniversalConnectionPoolException(64);
        }
        this.m_cumulativeSuccessfulConnectionWaitCount.incrementAndGet();
        long successWaitTime = System.currentTimeMillis() - startWait;
        this.m_cumulativeSuccessfulConnectionWaitTime.addAndGet(successWaitTime);
        Object toWait = this.m_peakConnectionWaitTime;
        synchronized (toWait) {
            if (this.m_peakConnectionWaitTime.get() < successWaitTime) {
                this.m_peakConnectionWaitTime.set(successWaitTime);
            }
        }
        if (isAbleToCreateConnection) {
            try {
                pooledConnection = this.createOnePooledConnection(cri);
                if (this.getValidateConnectionOnBorrow() && !pooledConnection.isValid()) {
                    this.closeAsynchronously(pooledConnection);
                    pooledConnection = null;
                }
            }
            finally {
                if (null != pooledConnection) {
                    toWait = this;
                    synchronized (toWait) {
                        this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(pooledConnection);
                    }
                }
                toWait = this;
                synchronized (toWait) {
                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                }
            }
        }
        if (null == pooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(65);
        }
        if (pooledConnection.isConnectionHarvestable()) {
            toWait = this;
            synchronized (toWait) {
                this.m_ucpInternal.m_connectionsHarvestable.put(pooledConnection.getPhysicalConnection(), pooledConnection);
            }
        }
        toWait = this;
        synchronized (toWait) {
            this.m_ucpInternal.m_connectionsNonHarvestable.put(pooledConnection.getPhysicalConnection(), pooledConnection);
        }
        pooledConnection.setBorrowedStartTime();
        pooledConnection.heartbeat();
        int numInUseConnections = this.getBorrowedConnectionsCount();
        object = this.m_peakConnectionsCount;
        synchronized (object) {
            if (this.m_peakConnectionsCount.get() < numInUseConnections) {
                this.m_peakConnectionsCount.set(numInUseConnections);
            }
        }
        this.m_cumulativeConnectionBorrowedCount.incrementAndGet();
        assert (pooledConnection instanceof UniversalPooledConnectionImpl);
        ((UniversalPooledConnectionImpl)pooledConnection).incrementConnectionReuseCounter();
        return pooledConnection;
    }

    private void closeAsynchronously(final UniversalPooledConnection upc) {
        UniversalConnectionPoolImpl.submitWTPTask(new UCPTaskBase(){

            public void run() {
                UniversalConnectionPoolImpl.this.closePhysicalConnection(upc.getPhysicalConnection());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniversalPooledConnection createOnePooledConnection() {
        UniversalPooledConnection upc = null;
        this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
        try {
            upc = this.createOnePooledConnection(this.getConnectionRetrievalInfo());
        }
        catch (UniversalConnectionPoolException exc) {
            logger.log(Level.FINEST, "createOnePooledConnection() throws exception: {0}", exc);
            upc = null;
        }
        finally {
            if (upc != null) {
                this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(upc);
            } else {
                this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
            }
        }
        return upc;
    }

    protected int roomToGrow() {
        return this.getMaxPoolSize() - this.m_ucpInternal.m_connectionsContainer.getAllConnections() - this.m_ucpInternal.m_connectionsContainer.getNumConnectionCreateRequests();
    }

    private void makeRoomInThePool() {
        UniversalPooledConnection upc = this.m_ucpInternal.m_availableConnections.removeAvailableConnection();
        if (upc != null) {
            --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
            this.closePhysicalConnection(upc.getPhysicalConnection());
            logger.finest("closed available connection" + upc.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectionWaitCounters(long begTime) {
        this.m_cumulativeFailedConnectionWaitCount.incrementAndGet();
        long failWaitTime = System.currentTimeMillis() - begTime;
        this.m_cumulativeFailedConnectionWaitTime.addAndGet(failWaitTime);
        AtomicLong atomicLong = this.m_peakConnectionWaitTime;
        synchronized (atomicLong) {
            if (this.m_peakConnectionWaitTime.get() < failWaitTime) {
                this.m_peakConnectionWaitTime.set(failWaitTime);
            }
        }
    }

    private UniversalConnectionPoolException newConnectionWaitFailedException(int errorNumber) {
        return UCPErrorHandler.newUniversalConnectionPoolException(errorNumber);
    }

    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.createOnePooledConnectionInternal(connectionRetrievalInfo);
    }

    @Override
    public void removeAndCloseOneAvailableConnection(UniversalPooledConnection upc) throws UniversalConnectionPoolException {
        this.m_ucpInternal.removeAndCloseOneAvailableConnectionInternal(upc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        if (null == pooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (this.m_lifeCycleState.get() != UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        Object physicalConnectionToClose = null;
        boolean addNewConnection = false;
        boolean needToAbort = false;
        ConnectionRetrievalInfo cri = pooledConnection.getConnectionRetrievalInfo();
        this.validatePoolSizes();
        UniversalConnectionPoolImpl universalConnectionPoolImpl = this;
        synchronized (universalConnectionPoolImpl) {
            UniversalPooledConnection universalPooledConnection = pooledConnection;
            synchronized (universalPooledConnection) {
                boolean removedInUse;
                pooledConnection.removeConnectionHarvestingCallback();
                UniversalPooledConnectionStatus status = pooledConnection.getStatus();
                physicalConnectionToClose = pooledConnection.getPhysicalConnection();
                UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)pooledConnection;
                if (status.equals(UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                    return;
                }
                if (!upci.isReusable(this.getMaxConnectionReuseTime(), this.getMaxConnectionReuseCount())) {
                    status = UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN;
                }
                this.m_cumulativeConnectionUseTime.getAndAdd(System.currentTimeMillis() - pooledConnection.getBorrowedStartTime());
                boolean bl = removedInUse = null != (pooledConnection.isConnectionHarvestable() ? (UniversalPooledConnection)this.m_ucpInternal.m_connectionsHarvestable.remove(physicalConnectionToClose) : (UniversalPooledConnection)this.m_ucpInternal.m_connectionsNonHarvestable.remove(physicalConnectionToClose));
                if (status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
                    int max;
                    int nconns = ((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections + this.m_ucpInternal.m_connectionsContainer.getNumConnectionCreateRequests();
                    if (nconns <= (max = this.getMaxPoolSize())) {
                        if (removedInUse) {
                            this.m_ucpInternal.m_availableConnections.addAvailableConnection(pooledConnection);
                            pooledConnection.setAvailableStartTime();
                        }
                        physicalConnectionToClose = null;
                    } else if (removedInUse) {
                        --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                        pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                    } else {
                        physicalConnectionToClose = null;
                    }
                } else if (status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN)) {
                    if (removedInUse) {
                        --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                        pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                        int nconns = ((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections + this.m_ucpInternal.m_connectionsContainer.getNumConnectionCreateRequests();
                        int min = this.getMinPoolSize();
                        addNewConnection = nconns < min;
                    } else {
                        physicalConnectionToClose = null;
                    }
                } else if (status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN)) {
                    if (removedInUse) {
                        --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                        pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                        addNewConnection = true;
                    } else {
                        physicalConnectionToClose = null;
                    }
                } else if (status.equals(UniversalPooledConnectionStatus.STATUS_BAD)) {
                    if (removedInUse) {
                        --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                        pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                        needToAbort = true;
                    } else {
                        physicalConnectionToClose = null;
                    }
                }
            }
            if (addNewConnection) {
                this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
            }
        }
        if (physicalConnectionToClose != null) {
            if (needToAbort) {
                this.abortConnection(pooledConnection);
            }
            this.closePhysicalConnection(physicalConnectionToClose);
        }
        if (addNewConnection) {
            UniversalPooledConnection upcToCreate = null;
            try {
                upcToCreate = this.createOnePooledConnection(cri);
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "createOnePooledConnection loop in returnConnection", e);
            }
            finally {
                if (null != upcToCreate) {
                    UniversalConnectionPoolImpl universalConnectionPoolImpl2 = this;
                    synchronized (universalConnectionPoolImpl2) {
                        this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(upcToCreate);
                        this.m_ucpInternal.m_availableConnections.addAvailableConnection(upcToCreate);
                        upcToCreate.setAvailableStartTime();
                    }
                }
                UniversalConnectionPoolImpl universalConnectionPoolImpl3 = this;
                synchronized (universalConnectionPoolImpl3) {
                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                }
            }
        }
        this.m_cumulativeReturnedConnectionCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void replaceNonReusableConnections() {
        logger.finest("about to replace non-reusable connections");
        ArrayList<UniversalPooledConnection> connsToClose = new ArrayList<UniversalPooledConnection>();
        UniversalConnectionPoolImpl universalConnectionPoolImpl = this;
        synchronized (universalConnectionPoolImpl) {
            for (UniversalPooledConnection upc : this.getAvailableConnections()) {
                UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)upc;
                if (upci.isReusable(this.getMaxConnectionReuseTime(), this.getMaxConnectionReuseCount())) continue;
                this.m_ucpInternal.m_availableConnections.removeAvailableConnection(upc);
                --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
                connsToClose.add(upc);
            }
            long cutoffTime = System.currentTimeMillis() - (long)(this.getAbandonedConnectionTimeout() * 1000);
            for (UniversalPooledConnection upc : this.getAllBorrowedConnections()) {
                UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)upc;
                if (upci.isReusable(this.getMaxConnectionReuseTime(), this.getMaxConnectionReuseCount()) || upc.getLastAccessedTime() > cutoffTime) continue;
                Object physConn = upc.getPhysicalConnection();
                if (upc.isConnectionHarvestable()) {
                    this.m_ucpInternal.m_connectionsHarvestable.remove(physConn);
                } else {
                    this.m_ucpInternal.m_connectionsNonHarvestable.remove(physConn);
                }
                --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
                connsToClose.add(upc);
            }
        }
        for (UniversalPooledConnection upc : connsToClose) {
            UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)upc;
            upci.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED, "connection closed");
            this.closePhysicalConnection(upc.getPhysicalConnection());
        }
        for (UniversalPooledConnection upc : connsToClose) {
            UniversalPooledConnection upcToCreate = null;
            ConnectionRetrievalInfo cri = upc.getConnectionRetrievalInfo();
            try {
                upcToCreate = this.createOnePooledConnection(cri);
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "createOnePooledConnection loop in returnConnection", e);
                break;
            }
            finally {
                if (null != upcToCreate) {
                    UniversalConnectionPoolImpl universalConnectionPoolImpl2 = this;
                    synchronized (universalConnectionPoolImpl2) {
                        this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(upcToCreate);
                        this.m_ucpInternal.m_availableConnections.addAvailableConnection(upcToCreate);
                        upcToCreate.setAvailableStartTime();
                        continue;
                    }
                }
                UniversalConnectionPoolImpl universalConnectionPoolImpl3 = this;
                synchronized (universalConnectionPoolImpl3) {
                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                }
            }
        }
        logger.finest("non-reusable connections successfully replaced");
    }

    @Override
    public void growPool(int nConns) {
        this.growPool(nConns, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void growPool(int nConns, List<ConnectionRetrievalInfo> listCri) {
        if (this.m_skipPoolGrowing.get()) {
            logger.log(Level.FINEST, "skip pool growing");
            return;
        }
        logger.log(Level.FINEST, "about to grow pool to {0} connections", nConns);
        ConnectionRetrievalInfo defaultCri = this.getConnectionRetrievalInfo();
        int nConnsCreated = 0;
        int iCri = 0;
        while (true) {
            ConnectionRetrievalInfo cri;
            if (null != listCri && iCri < listCri.size()) {
                cri = listCri.get(iCri++);
            } else if (null != defaultCri) {
                cri = defaultCri;
            } else {
                logger.log(Level.FINEST, "no default CRI");
                return;
            }
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this;
            synchronized (universalConnectionPoolImpl) {
                int nCurConns = this.m_ucpInternal.m_connectionsContainer.getAllConnections() + this.m_ucpInternal.m_connectionsContainer.getNumConnectionCreateRequests();
                if (nCurConns >= nConns) {
                    break;
                }
                this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
            }
            UniversalPooledConnection cpc = null;
            try {
                cpc = this.createOnePooledConnection(cri);
                continue;
            }
            catch (Exception e) {
                this.m_skipPoolGrowing.set(true);
                logger.log(Level.FINEST, "createOnePooledConnection loop in growPool", e);
            }
            finally {
                if (null != cpc) {
                    ++nConnsCreated;
                    UniversalConnectionPoolImpl universalConnectionPoolImpl2 = this;
                    synchronized (universalConnectionPoolImpl2) {
                        this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(cpc);
                        this.m_ucpInternal.m_availableConnections.addAvailableConnection(cpc);
                        cpc.setAvailableStartTime();
                    }
                } else {
                    UniversalConnectionPoolImpl universalConnectionPoolImpl3 = this;
                    synchronized (universalConnectionPoolImpl3) {
                        this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                    }
                }
                continue;
            }
            break;
        }
        logger.log(Level.FINEST, "{0} new connection(s) created", nConnsCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reducePool(int nConns) {
        int nConnsClosed = 0;
        while (true) {
            Object physicalConnectionToClose = null;
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this;
            synchronized (universalConnectionPoolImpl) {
                int nCurrConns = this.m_ucpInternal.m_connectionsContainer.getAllConnections() + this.m_ucpInternal.m_connectionsContainer.getNumConnectionCreateRequests();
                if (nCurrConns <= nConns) {
                    break;
                }
                if (this.getAvailableConnectionsCount() <= 0) {
                    break;
                }
                UniversalPooledConnection pooledConnection = this.m_ucpInternal.m_availableConnections.removeAvailableConnection();
                if (null != pooledConnection) {
                    --((UniversalConnectionPoolInternal)this.m_ucpInternal).m_connectionsContainer.m_allConnections;
                    physicalConnectionToClose = pooledConnection.getPhysicalConnection();
                    ++nConnsClosed;
                }
            }
            if (null == physicalConnectionToClose) continue;
            this.closePhysicalConnection(physicalConnectionToClose);
        }
        logger.log(Level.FINEST, "{0} connection(s) closed", nConnsClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addNewConnections(ConnectionRetrievalInfo cri, int num) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "about to add {0} new connections", num);
        boolean succ = true;
        int i = 0;
        while (true) {
            block20: {
                block22: {
                    UniversalConnectionPoolImpl universalConnectionPoolImpl;
                    block21: {
                        Object var8_7;
                        if (i >= num) {
                            return succ;
                        }
                        UniversalConnectionPoolImpl universalConnectionPoolImpl2 = this;
                        synchronized (universalConnectionPoolImpl2) {
                            this.m_ucpInternal.m_connectionsContainer.addNewConnectionCreateRequest();
                        }
                        UniversalPooledConnection cpc = null;
                        try {
                            try {
                                cpc = this.createOnePooledConnection(cri);
                            }
                            catch (NoAvailableConnectionsException e) {
                                logger.log(Level.FINEST, "createOnePooledConnection loop in addNewConnections", e);
                                var8_7 = null;
                                if (null != cpc) {
                                    universalConnectionPoolImpl = this;
                                    synchronized (universalConnectionPoolImpl) {
                                        this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(cpc);
                                        this.m_ucpInternal.m_availableConnections.addAvailableConnection(cpc);
                                        cpc.setAvailableStartTime();
                                    }
                                } else {
                                    universalConnectionPoolImpl = this;
                                    synchronized (universalConnectionPoolImpl) {
                                        this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                                        succ = false;
                                    }
                                }
                                logger.log(Level.FINEST, "{0} new connection(s) added", num);
                                break block20;
                            }
                            var8_7 = null;
                            if (null == cpc) break block21;
                            universalConnectionPoolImpl = this;
                        }
                        catch (Throwable throwable) {
                            var8_7 = null;
                            if (null != cpc) {
                                universalConnectionPoolImpl = this;
                                synchronized (universalConnectionPoolImpl) {
                                    this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(cpc);
                                    this.m_ucpInternal.m_availableConnections.addAvailableConnection(cpc);
                                    cpc.setAvailableStartTime();
                                }
                            } else {
                                universalConnectionPoolImpl = this;
                                synchronized (universalConnectionPoolImpl) {
                                    this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                                    succ = false;
                                }
                            }
                            logger.log(Level.FINEST, "{0} new connection(s) added", num);
                            throw throwable;
                        }
                        synchronized (universalConnectionPoolImpl) {
                            this.m_ucpInternal.m_connectionsContainer.updateConnectionCreatedInfo(cpc);
                            this.m_ucpInternal.m_availableConnections.addAvailableConnection(cpc);
                            cpc.setAvailableStartTime();
                            break block22;
                        }
                    }
                    universalConnectionPoolImpl = this;
                    synchronized (universalConnectionPoolImpl) {
                        this.m_ucpInternal.m_connectionsContainer.cancelConnectionCreateRequest();
                        succ = false;
                    }
                }
                logger.log(Level.FINEST, "{0} new connection(s) added", num);
            }
            ++i;
        }
    }

    @Override
    public void closeConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        this.m_ucpInternal.closeConnectionInternal(pooledConnection);
    }

    public synchronized void closeAvailableConnectionsAsynchronously(List<UniversalPooledConnection> connsToClose) {
        for (final UniversalPooledConnection conn : connsToClose) {
            this.m_ucpInternal.m_availableConnections.removeAvailableConnection(conn);
            UniversalConnectionPoolImpl.submitWTPTask(new UCPTaskBase(){

                public void run() {
                    try {
                        UniversalConnectionPoolImpl.this.removeAndCloseOneAvailableConnection(conn);
                    }
                    catch (UniversalConnectionPoolException e) {
                        logger.log(Level.FINEST, "remove and close available connections " + conn, e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void purge() throws UniversalConnectionPoolException {
        this.m_ucpInternal.purgeInternal();
    }

    @Override
    public synchronized void refresh() throws UniversalConnectionPoolException {
        this.m_ucpInternal.refreshInternal();
    }

    @Override
    public synchronized void recycle() throws UniversalConnectionPoolException {
        this.m_ucpInternal.recycleInternal();
    }

    @Override
    synchronized void processConnectionHarvesting() {
        this.m_ucpInternal.processConnectionHarvestingInternal();
    }

    @Override
    protected void setConnectionHarvestable(UniversalPooledConnection pooledConnection, boolean isConnectionHarvestable) {
        this.m_ucpInternal.setConnectionHarvestableInternal(pooledConnection, isConnectionHarvestable);
    }

    protected void abortConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
    }

    @Override
    protected void closePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    protected void addOneAvailableConnection(UniversalPooledConnection upc) {
        this.m_ucpInternal.addOneAvailableConnectionInternal(upc);
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.m_ucpInternal.getAvailableConnectionsCountInternal();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.m_ucpInternal.getBorrowedConnectionsCountInternal();
    }

    @Override
    public int getTotalConnectionsCount() {
        return this.m_ucpInternal.m_connectionsContainer.getAllConnections();
    }

    @Override
    public UniversalConnectionPoolStatistics getStatistics() {
        return new UniversalConnectionPoolStatisticsImpl(this);
    }

    @Override
    protected UniversalPooledConnection[] getAvailableConnections() {
        return this.m_ucpInternal.getAvailableConnectionsInternal();
    }

    @Override
    protected UniversalPooledConnection[] getAllBorrowedConnections() {
        return this.m_ucpInternal.getAllBorrowedConnectionsInternal();
    }

    @Override
    protected synchronized void discardUsedConnection(Object physicalConnection) {
        this.m_ucpInternal.discardUsedConnectionInternal(physicalConnection);
    }

    @Override
    protected UniversalPooledConnection getUsedConnection(Object physicalConnection) {
        return this.m_ucpInternal.getUsedConnectionInternal(physicalConnection);
    }

    @Override
    protected synchronized boolean returnUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.returnUsedPhysicalConnectionInternal(physicalConnection);
    }

    @Override
    protected synchronized boolean closeUsedPhysicalConnection(Object physicalConnection) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.closeUsedPhysicalConnectionInternal(physicalConnection);
    }

    protected AvailableConnections getCollectionAvailableConnections() {
        return this.m_ucpInternal.getCollectionAvailableConnectionsInternal();
    }

    protected void setCollectionAvailableConnections(AvailableConnections availableConnections) throws UniversalConnectionPoolException {
        this.m_ucpInternal.setCollectionAvailableConnectionsInternal(availableConnections);
    }

    protected synchronized UniversalPooledConnection getValidAvailableConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.getValidAvailableConnectionInternal(cri);
    }

    protected synchronized UniversalPooledConnection removeOneAvailableConnection(ConnectionRetrievalInfo cri) {
        return this.m_ucpInternal.removeOneAvailableConnectionInternal(cri);
    }

    protected Collection getAvailablePhysicalConnections(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.m_ucpInternal.getAvailablePhysicalConnectionsInternal(connectionRetrievalInfo);
    }

    protected Collection createCollection() {
        return this.m_ucpInternal.createCollectionInternal();
    }

    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancing(ConnectionRetrievalInfo cri) {
        return null;
    }

    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancingAndAffinity(ConnectionRetrievalInfo cri) {
        return null;
    }

    @Override
    public int getLabeledConnectionsCount() {
        return this.m_ucpInternal.getLabeledConnectionsCountInternal();
    }

    private static final class UniversalConnectionPoolInternal {
        private final UniversalConnectionPoolImpl m_cp;
        private final ConnectionsContainer m_connectionsContainer;
        private final Map<Object, UniversalPooledConnection> m_connectionsHarvestable;
        private final Map<Object, UniversalPooledConnection> m_connectionsNonHarvestable;
        private AvailableConnections m_availableConnections;
        private static final int REPLACE_CONNECTION_NOW = 2;
        private static final int REPLACE_INVALID_CONNECTION = 3;

        private UniversalConnectionPoolInternal(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
            assert (null != cp);
            this.m_cp = cp;
            this.m_connectionsContainer = new ConnectionsContainer(cp){

                int getMaxPoolSize() {
                    return UniversalConnectionPoolInternal.this.m_cp.getMaxPoolSize();
                }
            };
            this.m_connectionsHarvestable = this.m_connectionsContainer.getHarvestableConnections();
            this.m_connectionsNonHarvestable = this.m_connectionsContainer.getNonHarvestableConnections();
            this.m_availableConnections = this.m_connectionsContainer.getAvailableConnections();
        }

        private AvailableConnections getCollectionAvailableConnectionsInternal() {
            return this.m_availableConnections;
        }

        private void setCollectionAvailableConnectionsInternal(AvailableConnections availableConnections) throws UniversalConnectionPoolException {
            if (null == availableConnections) {
                UCPErrorHandler.throwUniversalConnectionPoolException(57);
            }
            if (!this.m_cp.isLifecycleStopped()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(62);
            }
            this.m_connectionsContainer.setAvailableConnections(availableConnections);
            this.m_availableConnections = availableConnections;
        }

        private Collection createCollectionInternal() {
            return new HashSet();
        }

        private Collection getAvailablePhysicalConnectionsInternal(ConnectionRetrievalInfo connectionRetrievalInfo) {
            return this.m_availableConnections.getAvailableConnections(connectionRetrievalInfo);
        }

        private UniversalPooledConnection[] getInUseConnectionsArrayInternal() {
            UniversalPooledConnection[] conns = this.m_connectionsHarvestable.values().toArray(new UniversalPooledConnection[0]);
            logger.log(Level.FINEST, "in use connections: {0}", conns.length);
            return conns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UniversalPooledConnection createOnePooledConnectionInternal(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
            assert (cri != null);
            this.checkLifecycle();
            Object connection = null;
            UniversalPooledConnection pooledConnection = null;
            try {
                ConnectionFactoryAdapter cfa = this.m_cp.getConnectionFactoryAdapter();
                connection = cfa.createConnection(cri);
                if (null == connection) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(100);
                }
                ConnectionRetrievalInfo storedCri = cri.getLabels() == null ? cri : cri.getCopyWithNoLabels();
                UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
                synchronized (universalConnectionPoolImpl) {
                    pooledConnection = cfa.createPooledConnection(connection, storedCri);
                    this.m_cp.incrementConnectionsCreatedCount();
                    this.m_cp.m_cumulativeConnectionsCreated.incrementAndGet();
                }
            }
            finally {
                if (null != connection && null == pooledConnection) {
                    this.m_cp.closePhysicalConnection(connection);
                }
            }
            return pooledConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAndCloseOneAvailableConnectionInternal(UniversalPooledConnection cpc) throws UniversalConnectionPoolException {
            if (null == cpc) {
                UCPErrorHandler.throwUniversalConnectionPoolException(150);
            }
            Object physicalConnection = cpc.getPhysicalConnection();
            boolean wasInitiallyClosed = UniversalPooledConnectionStatus.STATUS_CLOSED.equals(cpc.getStatus());
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                this.m_availableConnections.removeAvailableConnection(cpc);
                this.m_cp.m_borrowRequestQueue.notifyAvailable(cpc.getConnectionRetrievalInfo());
                --this.m_connectionsContainer.m_allConnections;
                cpc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
            }
            if (!wasInitiallyClosed) {
                this.m_cp.closePhysicalConnection(physicalConnection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UniversalPooledConnection removeOneAvailableConnectionInternal(ConnectionRetrievalInfo cri) {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                assert (cri != null);
                return this.m_availableConnections.removeAvailableConnection(cri);
            }
        }

        private UniversalPooledConnection getValidAvailableConnectionHelper(ConnectionRetrievalInfo cri, boolean isRetryForLabeledRequest) throws UniversalConnectionPoolException {
            assert (cri != null);
            Properties requestedLabels = cri.getLabels();
            boolean isLabeledRequest = requestedLabels != null;
            int lowestLabelingCost = Integer.MAX_VALUE;
            UniversalPooledConnection pc = null;
            if (this.m_cp.isRuntimeLoadBalancingEnabled()) {
                pc = this.m_cp.getConnectionAffinityCallback() != null ? this.m_cp.selectConnectionPerRuntimeLoadBalancingAndAffinity(cri) : this.m_cp.selectConnectionPerRuntimeLoadBalancing(cri);
            } else {
                Collection availableConnections = this.m_cp.getAvailablePhysicalConnections(cri);
                if (null == availableConnections) {
                    return null;
                }
                int num = availableConnections.size();
                if (0 == num) {
                    return null;
                }
                ArrayList<UniversalPooledConnection> connsToClose = new ArrayList<UniversalPooledConnection>();
                for (UniversalPooledConnection conn : availableConnections) {
                    UniversalPooledConnectionStatus status = conn.getStatus();
                    if (!status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
                    boolean needValidateOnBorrow = this.m_cp.getValidateConnectionOnBorrow();
                    boolean validateResult = true;
                    if (needValidateOnBorrow) {
                        validateResult = conn.isValid();
                    }
                    if (!needValidateOnBorrow || validateResult) {
                        if (!isLabeledRequest) {
                            pc = conn;
                            break;
                        }
                        Properties currentLabels = conn.getConnectionLabels();
                        int currentLabelingCost = this.m_cp.getConnectionLabelingCallback().cost(requestedLabels, currentLabels);
                        if (currentLabelingCost == Integer.MAX_VALUE || currentLabelingCost >= lowestLabelingCost) continue;
                        lowestLabelingCost = currentLabelingCost;
                        pc = conn;
                        if (lowestLabelingCost != 0) continue;
                        break;
                    }
                    connsToClose.add(conn);
                }
                this.m_cp.closeAvailableConnectionsAsynchronously(connsToClose);
            }
            if (pc != null && (isLabeledRequest && lowestLabelingCost > 0 || isRetryForLabeledRequest)) {
                this.m_cp.getConnectionLabelingCallback().configure(requestedLabels, pc.getPhysicalConnection());
            }
            return pc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UniversalPooledConnection getValidAvailableConnectionInternal(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
            assert (cri != null);
            Properties requestedLabels = cri.getLabels();
            boolean isLabeledRequest = requestedLabels != null;
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                UniversalPooledConnection pc;
                if (!(isLabeledRequest || this.m_cp.isRuntimeLoadBalancingEnabled() || this.m_cp.getValidateConnectionOnBorrow())) {
                    pc = this.m_availableConnections.removeAvailableConnection(cri);
                    if (null == pc || UniversalPooledConnectionStatus.STATUS_NORMAL.equals(pc.getStatus())) {
                        return pc;
                    }
                    this.m_availableConnections.addAvailableConnection(pc);
                }
                pc = this.getValidAvailableConnectionHelper(cri, false);
                if (isLabeledRequest && pc == null) {
                    ConnectionRetrievalInfo criNoLabels = cri.getCopyWithNoLabels();
                    pc = this.getValidAvailableConnectionHelper(criNoLabels, true);
                }
                if (pc != null) {
                    this.m_availableConnections.removeAvailableConnection(pc);
                }
                return pc;
            }
        }

        private void checkLifecycle() throws UniversalConnectionPoolException {
            if (this.m_cp.isLifecycleFailed() || this.m_cp.isLifecycleStopped()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConnectionInternal(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
            this.checkLifecycle();
            if (null == pooledConnection) {
                UCPErrorHandler.throwUniversalConnectionPoolException(150);
            }
            boolean closePhysically = true;
            Object physicalConnection = pooledConnection.getPhysicalConnection();
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                UniversalPooledConnection removedConnection;
                this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(System.currentTimeMillis() - pooledConnection.getBorrowedStartTime());
                UniversalPooledConnection universalPooledConnection = removedConnection = pooledConnection.isConnectionHarvestable() ? this.m_connectionsHarvestable.remove(physicalConnection) : this.m_connectionsNonHarvestable.remove(physicalConnection);
                if (null != removedConnection) {
                    --this.m_connectionsContainer.m_allConnections;
                    pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                } else {
                    closePhysically = false;
                }
            }
            if (closePhysically) {
                this.m_cp.closePhysicalConnection(physicalConnection);
            }
            logger.finest("connection closed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void purgeInternal() throws UniversalConnectionPoolException {
            UniversalPooledConnection[] borrowedConnsToClose;
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                this.checkLifecycle();
                this.m_availableConnections.closeAllConnections();
                for (UniversalPooledConnection conn : borrowedConnsToClose = this.m_cp.getAllBorrowedConnections()) {
                    this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(System.currentTimeMillis() - conn.getBorrowedStartTime());
                    if (conn.isConnectionHarvestable()) {
                        this.m_connectionsHarvestable.remove(conn.getPhysicalConnection());
                    } else {
                        this.m_connectionsNonHarvestable.remove(conn.getPhysicalConnection());
                    }
                    conn.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                }
                this.m_connectionsContainer.m_allConnections = 0;
            }
            for (UniversalPooledConnection conn : borrowedConnsToClose) {
                this.m_cp.closePhysicalConnection(conn.getPhysicalConnection());
            }
            logger.fine("purged");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshInternal() throws UniversalConnectionPoolException {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                this.checkLifecycle();
                this.doForEveryAvailableConnection(2);
                UniversalPooledConnection[] borrowedConnsToClose = this.m_cp.getAllBorrowedConnections();
                for (int i = 0; i < borrowedConnsToClose.length; ++i) {
                    borrowedConnsToClose[i].setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
                }
            }
            logger.fine("refreshed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recycleInternal() throws UniversalConnectionPoolException {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                this.checkLifecycle();
                this.doForEveryAvailableConnection(3);
            }
            logger.fine("recycled");
        }

        private void doForEveryAvailableConnection(int task) throws UniversalConnectionPoolException {
            int num = this.m_cp.getAvailableConnectionsCount();
            UniversalPooledConnection[] availableConnections = this.m_cp.getAvailableConnections();
            block4: for (int i = 0; i < num; ++i) {
                switch (task) {
                    case 2: {
                        ConnectionRetrievalInfo cri = availableConnections[i].getConnectionRetrievalInfo();
                        this.m_cp.removeAndCloseOneAvailableConnection(availableConnections[i]);
                        this.m_cp.addNewConnections(cri, 1);
                        continue block4;
                    }
                    case 3: {
                        ConnectionRetrievalInfo cri = availableConnections[i].getConnectionRetrievalInfo();
                        if (availableConnections[i].isValid()) continue block4;
                        this.m_cp.removeAndCloseOneAvailableConnection(availableConnections[i]);
                        this.m_cp.addNewConnections(cri, 1);
                        continue block4;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processConnectionHarvestingInternal() {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                int connectionHarvestTriggerCount = this.m_cp.getConnectionHarvestTriggerCount();
                if (connectionHarvestTriggerCount >= 0 && connectionHarvestTriggerCount < Integer.MAX_VALUE && this.m_cp.getAvailableConnectionsCount() <= connectionHarvestTriggerCount) {
                    final UniversalConnectionPoolImpl thisLocker = this.m_cp;
                    final int harvestNumRequested = this.m_cp.getConnectionHarvestMaxCount();
                    UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = thisLocker;
                            synchronized (object) {
                                UniversalPooledConnection[] pooledConnections = UniversalConnectionPoolInternal.this.m_cp.getInUseConnectionsArray();
                                Arrays.sort(pooledConnections, new ConnectionHarvestingComparator());
                                int harvestableConnectionsNum = pooledConnections.length;
                                int harvestNum = harvestNumRequested < harvestableConnectionsNum ? harvestNumRequested : harvestableConnectionsNum;
                                for (int i = 0; i < harvestNum; ++i) {
                                    try {
                                        ConnectionHarvestingCallback harvestingCallback = pooledConnections[i].getConnectionHarvestingCallback();
                                        if (harvestingCallback != null) {
                                            harvestingCallback.cleanup();
                                        }
                                        UniversalConnectionPoolInternal.this.m_cp.returnConnection(pooledConnections[i]);
                                        continue;
                                    }
                                    catch (UniversalConnectionPoolException ucpe) {
                                        logger.log(Level.FINEST, "loop returnConnection() " + pooledConnections[i], ucpe);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }

        private void setConnectionHarvestableInternal(UniversalPooledConnection pooledConnection, boolean isConnectionHarvestable) {
            boolean wasHarvestable = pooledConnection.isConnectionHarvestable();
            if (wasHarvestable == isConnectionHarvestable) {
                return;
            }
            (wasHarvestable ? this.m_connectionsHarvestable : this.m_connectionsNonHarvestable).remove(pooledConnection.getPhysicalConnection());
            (isConnectionHarvestable ? this.m_connectionsHarvestable : this.m_connectionsNonHarvestable).put(pooledConnection.getPhysicalConnection(), pooledConnection);
            logger.finest("connection is now " + (isConnectionHarvestable ? "harvestable" : "non-harvestable"));
        }

        private void addOneAvailableConnectionInternal(UniversalPooledConnection cpc) {
            this.m_availableConnections.addAvailableConnection(cpc);
            cpc.setAvailableStartTime();
        }

        private int getAvailableConnectionsCountInternal() {
            return this.m_availableConnections.getNumAvailableConnections();
        }

        private int getBorrowedConnectionsCountInternal() {
            return this.m_connectionsContainer.getBorrowedConnectionsCount();
        }

        private UniversalPooledConnection[] getAvailableConnectionsInternal() {
            return this.m_availableConnections.getAllAvailableConnections();
        }

        private UniversalPooledConnection[] getAllBorrowedConnectionsInternal() {
            return this.m_connectionsContainer.getAllBorrowedConnections();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardUsedConnectionInternal(Object physicalConnection) {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
                if (null != pooledConnection) {
                    this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(System.currentTimeMillis() - this.m_cp.getUsedConnection(physicalConnection).getBorrowedStartTime());
                    if (pooledConnection.isConnectionHarvestable()) {
                        this.m_connectionsHarvestable.remove(physicalConnection);
                    } else {
                        this.m_connectionsNonHarvestable.remove(physicalConnection);
                    }
                    --this.m_connectionsContainer.m_allConnections;
                }
            }
        }

        private UniversalPooledConnection getUsedConnectionInternal(Object physicalConnection) {
            UniversalPooledConnection pooledConnection = this.m_connectionsHarvestable.get(physicalConnection);
            if (pooledConnection == null) {
                pooledConnection = this.m_connectionsNonHarvestable.get(physicalConnection);
            }
            return pooledConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean returnUsedPhysicalConnectionInternal(Object physicalConnection) throws UniversalConnectionPoolException {
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
                if (pooledConnection == null) {
                    return false;
                }
                this.m_cp.returnConnection(pooledConnection);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean closeUsedPhysicalConnectionInternal(Object physicalConnection) throws UniversalConnectionPoolException {
            boolean closePhysically = true;
            UniversalConnectionPoolImpl universalConnectionPoolImpl = this.m_cp;
            synchronized (universalConnectionPoolImpl) {
                UniversalPooledConnection removedConnection;
                UniversalPooledConnection pooledConnection = this.m_cp.getUsedConnection(physicalConnection);
                if (pooledConnection == null) {
                    return false;
                }
                this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(System.currentTimeMillis() - pooledConnection.getBorrowedStartTime());
                UniversalPooledConnection universalPooledConnection = removedConnection = pooledConnection.isConnectionHarvestable() ? this.m_connectionsHarvestable.remove(physicalConnection) : this.m_connectionsNonHarvestable.remove(physicalConnection);
                if (null != removedConnection) {
                    --this.m_connectionsContainer.m_allConnections;
                    pooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSED);
                    this.m_cp.m_borrowRequestQueue.notifyAvailable(pooledConnection.getConnectionRetrievalInfo());
                } else {
                    closePhysically = false;
                }
            }
            if (closePhysically) {
                this.m_cp.closePhysicalConnection(physicalConnection);
            }
            return true;
        }

        public int getLabeledConnectionsCountInternal() {
            return this.m_availableConnections.getNumAvailableLabeledConnections();
        }
    }
}

