/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.logging.UCPLoggerFactory;

class UniversalPooledConnectionImpl
implements UniversalPooledConnection {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalPooledConnectionImpl.class.getCanonicalName());
    private final UniversalConnectionPoolBase m_connectionPool;
    private final Object m_connection;
    private final ConnectionRetrievalInfo m_connectionRetrievalInfo;
    private UniversalPooledConnectionStatus m_status = UniversalPooledConnectionStatus.STATUS_NORMAL;
    private long m_lastAccessedTime = System.currentTimeMillis();
    private final AtomicLong m_availableStartTime = new AtomicLong();
    private final AtomicLong m_borrowedStartTime = new AtomicLong();
    private final AtomicLong m_connectionReuseTimestamp = new AtomicLong(System.currentTimeMillis());
    private final AtomicInteger m_connectionReuseCounter = new AtomicInteger(0);
    private final AtomicBoolean m_isHarvestable = new AtomicBoolean(true);
    private ConnectionHarvestingCallback m_harvestingCallback = null;
    private AbandonedConnectionTimeoutCallback m_abandonedConnCallback = null;
    private TimeToLiveConnectionTimeoutCallback m_ttlConnCallback = null;
    public static final long CONNECTION_VALIDATION_TIMEOUT = 15L;

    UniversalPooledConnectionImpl(UniversalConnectionPoolBase connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        if (null == connection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(264);
        }
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(4);
        }
        this.m_connectionPool = connectionPool;
        this.m_connection = connection;
        this.m_connectionRetrievalInfo = connectionRetrievalInfo;
        this.m_isHarvestable.set(true);
    }

    public Object getPhysicalConnection() {
        return this.m_connection;
    }

    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_connectionRetrievalInfo;
    }

    public void heartbeat() {
        this.m_lastAccessedTime = System.currentTimeMillis();
    }

    public boolean isValid() {
        return this.isValid(15L);
    }

    public boolean isValid(long timeout) {
        UniversalPooledConnectionStatus _status;
        TaskHandle submittedTask = null;
        if (this.m_connectionPool != null && this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            try {
                submittedTask = UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                    public void run() {
                        UniversalPooledConnectionImpl.this.validate();
                    }
                });
                if (submittedTask != null) {
                    submittedTask.get(timeout * 1000L);
                } else {
                    logger.log(Level.FINEST, "Connection validation task submission failed");
                }
            }
            catch (Exception vexc) {
                logger.log(Level.FINEST, "Connection validation timed out or hit an error: {0}", vexc);
                this.markBadAndCancel(submittedTask);
            }
        }
        return !(_status = this.getStatus()).equals(UniversalPooledConnectionStatus.STATUS_CLOSED) && !_status.equals(UniversalPooledConnectionStatus.STATUS_BAD);
    }

    void markBadAndCancel(TaskHandle submittedTask) {
        this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "The connection is deemed invalid");
        if (submittedTask != null) {
            submittedTask.getTask().release();
        }
    }

    public void validate() {
    }

    public long getLastAccessedTime() {
        return this.m_lastAccessedTime;
    }

    public synchronized UniversalPooledConnectionStatus getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(UniversalPooledConnectionStatus status) throws UniversalConnectionPoolException {
        if (null == status) {
            UCPErrorHandler.throwUniversalConnectionPoolException(152);
        }
        UniversalPooledConnectionImpl universalPooledConnectionImpl = this;
        synchronized (universalPooledConnectionImpl) {
            this.m_status = status;
        }
    }

    public void setStatus(UniversalPooledConnectionStatus status, String msg) {
        logger.finest(msg);
        try {
            this.setStatus(status);
            logger.finest("connection status was set");
        }
        catch (UniversalConnectionPoolException e) {
            logger.finest("setting connection status failed");
        }
    }

    public long getAvailableStartTime() {
        return this.m_availableStartTime.get();
    }

    public void setAvailableStartTime() {
        long availStartTime = System.currentTimeMillis();
        this.m_availableStartTime.set(availStartTime);
        logger.log(Level.FINEST, "availableStartTime: {0}", availStartTime);
    }

    public long getBorrowedStartTime() {
        return this.m_borrowedStartTime.get();
    }

    public void setBorrowedStartTime() {
        long borrowedStartTime = System.currentTimeMillis();
        this.m_borrowedStartTime.set(borrowedStartTime);
        logger.log(Level.FINEST, "borrowedStartTime: {0}", borrowedStartTime);
    }

    public void applyConnectionLabel(String key, String value) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (key == null || key.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        this.m_connectionRetrievalInfo.addLabel(key, value);
        logger.finest("connection label (key:" + key + ", value:" + value + ") applied");
    }

    public void removeConnectionLabel(String key) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (null == key || key.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        this.m_connectionRetrievalInfo.removeLabel(key);
        logger.finest("connection label (key:" + key + ") removed");
    }

    public Properties getConnectionLabels() throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_connectionRetrievalInfo.getLabels();
    }

    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        Properties storedLabels = this.m_connectionRetrievalInfo.getLabels();
        if (requestedLabels == null || requestedLabels.isEmpty()) {
            if (storedLabels != null && !storedLabels.isEmpty()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(93);
            } else {
                return null;
            }
        }
        Properties unmatchedLabels = new Properties();
        if (storedLabels == null || storedLabels.isEmpty()) {
            unmatchedLabels.putAll((Map<?, ?>)requestedLabels);
            return unmatchedLabels;
        }
        Iterator<Map.Entry<Object, Object>> itr = requestedLabels.entrySet().iterator();
        Set<Map.Entry<Object, Object>> storedLabelSet = storedLabels.entrySet();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> label = itr.next();
            String key = (String)label.getKey();
            String value = (String)label.getValue();
            if (storedLabelSet.contains(label)) continue;
            unmatchedLabels.setProperty(key, value);
        }
        return unmatchedLabels.isEmpty() ? null : unmatchedLabels;
    }

    public synchronized void setConnectionHarvestable(boolean isConnectionHarvestable) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionHarvestable: {0}", isConnectionHarvestable);
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        this.m_connectionPool.setConnectionHarvestable(this, isConnectionHarvestable);
        this.m_isHarvestable.set(isConnectionHarvestable);
    }

    public boolean isConnectionHarvestable() {
        return this.m_isHarvestable.get();
    }

    public synchronized void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (null != this.m_harvestingCallback) {
            UCPErrorHandler.throwUniversalConnectionPoolException(155);
        }
        logger.log(Level.FINEST, "connection harvesting callback {0} registered", cbk);
        this.m_harvestingCallback = cbk;
    }

    public synchronized void removeConnectionHarvestingCallback() throws UniversalConnectionPoolException {
        logger.finest("connection harvesting callback removed");
        this.m_harvestingCallback = null;
    }

    public synchronized ConnectionHarvestingCallback getConnectionHarvestingCallback() throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_harvestingCallback;
    }

    public synchronized void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (null != this.m_abandonedConnCallback) {
            UCPErrorHandler.throwUniversalConnectionPoolException(156);
        }
        logger.log(Level.FINEST, "abandoned connection timeout callback {0} registered", cbk);
        this.m_abandonedConnCallback = cbk;
    }

    public synchronized void removeAbandonedConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        logger.finest("abandoned connection timeout callback removed");
        this.m_abandonedConnCallback = null;
    }

    public synchronized AbandonedConnectionTimeoutCallback getAbandonedConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_abandonedConnCallback;
    }

    public synchronized void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (this.m_ttlConnCallback != null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(157);
        }
        logger.log(Level.FINEST, "TTL connection timeout callback {0} registered", cbk);
        this.m_ttlConnCallback = cbk;
    }

    public synchronized void removeTimeToLiveConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        logger.finest("TTL connection timeout callback removed");
        this.m_ttlConnCallback = null;
    }

    public synchronized TimeToLiveConnectionTimeoutCallback getTimeToLiveConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        if (!this.getStatus().equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_ttlConnCallback;
    }

    public int getConnectionReuseCounter() {
        return this.m_connectionReuseCounter.get();
    }

    public void incrementConnectionReuseCounter() {
        this.m_connectionReuseCounter.incrementAndGet();
    }

    public long getConnectionReuseTimestamp() {
        return this.m_connectionReuseTimestamp.get();
    }

    public boolean isReusable(long reuseTime, int reuseCount) {
        int countToClose;
        if (reuseTime > 0L) {
            long tsNow = System.currentTimeMillis();
            long tsToClose = this.getConnectionReuseTimestamp() + reuseTime * 1000L;
            if (tsToClose <= tsNow) {
                return false;
            }
        }
        return reuseCount <= 0 || (countToClose = this.getConnectionReuseCounter()) < reuseCount;
    }
}

