/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.ONSOracleRuntimeLBEventSubscriber;
import oracle.ucp.jdbc.oracle.ONSRuntimeLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ONSRuntimeLBEventHandlerTask
extends ProlongedTask<Object> {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSRuntimeLBEventHandlerTask.class.getCanonicalName());
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private boolean m_terminate = false;
    private final RACManagerImpl m_racMngr;
    private final String m_serviceName;
    private final boolean m_subscriberFailed;

    protected ONSRuntimeLBEventHandlerTask(String service, RACManagerImpl racMngr) throws UniversalConnectionPoolException {
        this(service, racMngr, null);
    }

    protected ONSRuntimeLBEventHandlerTask(String service, RACManagerImpl racMngr, OracleFailoverEventSubscriber subscriber) throws UniversalConnectionPoolException {
        this.m_racMngr = racMngr;
        if (subscriber == null) {
            ONSOracleRuntimeLBEventSubscriber s = new ONSOracleRuntimeLBEventSubscriber(service);
            this.m_subscriberFailed = s.isFailed();
            this.m_onsSubscriber = s;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = subscriber;
        }
        this.m_serviceName = service;
    }

    @Override
    public void run() {
        Notification event = null;
        boolean retrySubscription = false;
        if (!this.m_subscriberFailed) {
            while (!this.isTerminate()) {
                try {
                    event = this.m_onsSubscriber.receive();
                    if (event != null) {
                        ONSRuntimeLoadBalancingEvent rlbEvent = new ONSRuntimeLoadBalancingEvent(this.m_serviceName, event.body());
                        this.m_racMngr.handleLoadBalancingEvent(rlbEvent);
                        logger.fine("Runtime Load Balancing event triggered");
                    } else {
                        this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                    }
                }
                catch (UniversalConnectionPoolException ucpEx) {
                    logger.log(Level.FINEST, "RLB event", ucpEx);
                    this.m_racMngr.setRCLBMetricsPolicyEnabled(false);
                    retrySubscription = true;
                }
                if (!retrySubscription) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    logger.finest("sleep interrupted");
                }
                retrySubscription = false;
            }
        } else {
            logger.finest("ONS subscriber failed");
        }
    }

    public boolean isTerminate() {
        return this.m_terminate;
    }

    public void setTerminate(boolean terminate) {
        logger.log(Level.FINEST, "setTerminate(): {0}", terminate);
        this.m_terminate = terminate;
        if (terminate) {
            this.m_onsSubscriber.close();
        }
    }
}

