/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.SnapshotHelper;
import com.ericsson.automation.vmware.TaskHelper;
import com.ericsson.automation.vmware.VMHelper;
import com.ericsson.automation.vmware.VimConnection;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import java.util.Map;

public class VMManager {
    private VimConnection connection;
    private TaskHelper taskHelper;
    private VMHelper vmHelper;
    private SnapshotHelper snapHelper;

    VMManager(VimConnection vimConnection) {
        this.connection = vimConnection;
        this.taskHelper = new TaskHelper(vimConnection);
        this.vmHelper = new VMHelper(vimConnection);
        this.snapHelper = new SnapshotHelper(vimConnection);
    }

    public ManagedObjectReference findVM(String string) throws Exception {
        ServiceContent serviceContent = this.connection.getServiceContent();
        ManagedObjectReference managedObjectReference = serviceContent.getRootFolder();
        Map<String, ManagedObjectReference> map = this.vmHelper.getRefsInContainerByType(managedObjectReference, "VirtualMachine");
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public boolean powerOnVM(ManagedObjectReference managedObjectReference) {
        System.out.println("Powering on virtual machine");
        try {
            ManagedObjectReference managedObjectReference2 = this.connection.getVimPort().powerOnVMTask(managedObjectReference, null);
            if (this.taskHelper.getTaskResultAfterDone(managedObjectReference2)) {
                System.out.println("Powered on successfully");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean powerOffVM(ManagedObjectReference managedObjectReference) {
        System.out.println("Powering off virtual machine");
        try {
            ManagedObjectReference managedObjectReference2 = this.connection.getVimPort().powerOffVMTask(managedObjectReference);
            if (this.taskHelper.getTaskResultAfterDone(managedObjectReference2)) {
                System.out.println("Powered off successfully");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean selectSnapshot(ManagedObjectReference managedObjectReference, String string) throws Exception {
        System.out.println("Reverting to snapshot " + string + "...");
        VimPortType vimPortType = this.connection.getVimPort();
        ManagedObjectReference managedObjectReference2 = this.snapHelper.getSnapshotReference(managedObjectReference, string);
        if (managedObjectReference2 != null) {
            ManagedObjectReference managedObjectReference3 = vimPortType.revertToSnapshotTask(managedObjectReference2, null, Boolean.valueOf(true));
            if (this.taskHelper.getTaskResultAfterDone(managedObjectReference3)) {
                System.out.println("Done");
                return true;
            }
            System.out.println("Error");
            return false;
        }
        System.out.println("Snapshot not found");
        return false;
    }
}

