/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.vmware;

import com.ericsson.automation.vmware.VMManager;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class VimConnection {
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private String url;
    private String userName;
    private String password;
    private boolean isConnected = false;
    private VMManager vmManager = new VMManager(this);

    public VimConnection(String string) throws Exception {
        System.out.println("Retrieving service content...");
        VimService vimService = new VimService();
        this.vimPort = vimService.getVimPort();
        this.url = "https://" + string + "/sdk/vimService";
        Map map = ((BindingProvider)this.vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", this.url);
        map.put("javax.xml.ws.session.maintain", true);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("ServiceInstance");
        managedObjectReference.setValue("ServiceInstance");
        this.serviceContent = this.vimPort.retrieveServiceContent(managedObjectReference);
        System.out.println("Done");
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public VMManager getVMManager() {
        return this.vmManager;
    }

    VimPortType getVimPort() {
        return this.vimPort;
    }

    ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    public void connect() throws Exception {
        System.out.println("Connecting...");
        this.vimPort.login(this.serviceContent.getSessionManager(), this.userName, this.password, null);
        this.isConnected = true;
        System.out.println("Done");
    }

    public void disconnect() throws Exception {
        System.out.println("Disconnecting...");
        if (this.isConnected) {
            this.vimPort.logout(this.serviceContent.getSessionManager());
        }
        this.isConnected = false;
        System.out.println("Done");
    }
}

