/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtil;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;
    private static final int CACHE_SIZE = 1024;
    private static final ConcurrentHashMap<Class, BeanProperties> properties = new ConcurrentHashMap(1024);

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        context.setPropertyResolved(true);
        return bp.getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Object value;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            value = method.invoke(base, new Object[0]);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
        return value;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "resolverNotwritable", new Object[]{base.getClass().getName()}));
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            method.invoke(base, val);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            String message = ELUtil.getExceptionMessageString(context, "setPropertyFailed", new Object[]{property.toString(), base.getClass().getName(), val});
            throw new ELException(message, ex);
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (base == null || method == null) {
            return null;
        }
        Method m = this.findMethod(base, method.toString(), paramTypes, params);
        Object ret = this.invokeMethod(m, base, params);
        context.setPropertyResolved(true);
        return ret;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        return bp.isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(base.getClass());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(info.getPropertyDescriptors().length);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list.iterator();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static Method getMethod(Class cl, Method method) {
        if (method == null) {
            return null;
        }
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, m);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<Object> c = cl.getSuperclass();
        if (c != null) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, m);
                if (m != null) {
                    return m;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanProperty getBeanProperty(ELContext context, Object base, Object prop) {
        BeanProperty bp;
        String property = prop.toString();
        Class<?> baseClass = base.getClass();
        BeanProperties bps = properties.get(baseClass);
        if (bps == null) {
            bps = new BeanProperties(baseClass);
            properties.putIfAbsent(baseClass, bps);
        }
        if ((bp = bps.getBeanProperty(property)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{baseClass.getName(), property}));
        }
        return bp;
    }

    private void removeFromMap(Map<Class, BeanProperties> map, ClassLoader classloader) {
        Iterator<Class> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Class mbeanClass = iter.next();
            if (!classloader.equals(mbeanClass.getClassLoader())) continue;
            iter.remove();
        }
    }

    private void purgeBeanClasses(ClassLoader classloader) {
        this.removeFromMap(properties, classloader);
    }

    private Method findMethod(Object base, String method, Class<?>[] paramTypes, Object[] params) {
        Class<?> beanClass = base.getClass();
        if (paramTypes != null) {
            try {
                return beanClass.getMethod(method, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new MethodNotFoundException(ex);
            }
        }
        for (Method m : base.getClass().getMethods()) {
            if (!m.getName().equals(method) || !m.isVarArgs() && m.getParameterTypes().length != params.length) continue;
            return m;
        }
        throw new MethodNotFoundException("Method " + method + " not found");
    }

    private Object invokeMethod(Method m, Object base, Object[] params) {
        Class<?>[] parameterTypes = m.getParameterTypes();
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            ExpressionFactory exprFactory = ExpressionFactory.newInstance();
            if (!m.isVarArgs()) {
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = exprFactory.coerceToType(params[i], parameterTypes[i]);
                }
            }
        }
        try {
            return m.invoke(base, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
    }

    protected static final class BeanProperties {
        private final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            try {
                BeanInfo info = Introspector.getBeanInfo(baseClass);
                descriptors = info.getPropertyDescriptors();
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
            for (PropertyDescriptor pd : descriptors) {
                this.propertyMap.put(pd.getName(), new BeanProperty(baseClass, pd));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.propertyMap.get(property);
        }
    }

    protected static final class BeanProperty {
        private Method readMethod;
        private Method writeMethod;
        private PropertyDescriptor descriptor;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.readMethod = BeanELResolver.getMethod(baseClass, descriptor.getReadMethod());
            this.writeMethod = BeanELResolver.getMethod(baseClass, descriptor.getWriteMethod());
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }
    }
}

