/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.InstanceManager;
import org.apache.catalina.Context;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.javaee.SimpleJavaEEModule;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.ExtendedInjectionContainer;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.Injector;
import org.jboss.injection.PersistenceContextHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebApplication;
import org.jboss.web.tomcat.service.injection.TomcatInjectionUtils;
import org.jboss.web.tomcat.service.injection.WebEJBHandler;
import org.jboss.web.tomcat.service.injection.WebResourceHandler;
import org.jboss.web.tomcat.service.injection.WebServiceRefInjectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatInjectionContainer
extends AbstractJavaEEComponent
implements ExtendedInjectionContainer,
InstanceManager {
    private static final Logger log;
    protected EncMap encInjectors = new EncMap();
    protected Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    protected DependencyPolicy dependencyPolicy = new JBoss5DependencyPolicy((JavaEEComponent)this);
    protected Collection<InjectionHandler<Environment>> handlers;
    protected DeploymentUnit unit;
    protected ClassLoader webLoader;
    protected WebApplication appInfo;
    protected JBossWebMetaData webDD;
    protected Context catalinaContext;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;
    private DeploymentEndpointResolver deploymentEndpointResolver;
    private Map<String, ContainerDependencyMetaData> endpointMap;
    private static final Set<String> dynamicClassLoaders;
    private static final Properties restrictedFilters;
    private static final Properties restrictedListeners;
    private static final Properties restrictedServlets;

    public TomcatInjectionContainer(WebApplication appInfo, DeploymentUnit unit, Context catalinaContext, PersistenceUnitDependencyResolver resolver) {
        super((JavaEEModule)new SimpleJavaEEModule(appInfo.getName()));
        this.unit = unit;
        this.appInfo = appInfo;
        this.catalinaContext = catalinaContext;
        this.persistenceUnitDependencyResolver = resolver;
        this.deploymentEndpointResolver = (DeploymentEndpointResolver)unit.getAttachment(DeploymentEndpointResolver.class);
        this.endpointMap = (Map)unit.getTopLevel().getAttachment("MappedReferenceMetaDataResolverDeployer.endpointMap", Map.class);
        this.webDD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        assert (this.webDD != null) : "webDD is null (no JBossWebMetaData attachment in VFSDeploymentUnit)";
    }

    private void checkAccess(Class<?> clazz) {
        if (this.catalinaContext.getPrivileged()) {
            return;
        }
        if (Filter.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, restrictedFilters);
        } else if (Servlet.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, restrictedServlets);
        } else {
            this.checkAccess(clazz, restrictedListeners);
        }
    }

    private void checkAccess(Class<?> clazz, Properties restricted) {
        while (clazz != null) {
            if ("restricted".equals(restricted.getProperty(clazz.getName()))) {
                throw new SecurityException("Restricted class: " + clazz.getName());
            }
            clazz = clazz.getSuperclass();
        }
    }

    public Environment getEnvironmentRefGroup() {
        return this.webDD.getJndiEnvironmentRefsGroup();
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ClassLoader loader = this.catalinaContext.getLoader().getClassLoader();
        Class<?> clazz = loader.loadClass(className);
        this.checkAccess(clazz);
        Object instance = clazz.newInstance();
        this.processInjectors(instance);
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processDynamicBeanAnnotations(instance);
            this.postConstruct(instance);
        }
        return instance;
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        this.checkAccess(clazz);
        Object instance = clazz.newInstance();
        this.processInjectors(instance);
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processDynamicBeanAnnotations(instance);
            this.postConstruct(instance);
        }
        return instance;
    }

    public void newInstance(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.processInjectors(instance);
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processDynamicBeanAnnotations(instance);
            this.postConstruct(instance);
        }
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.preDestroy(instance);
        }
    }

    public void postConstruct(Object object) throws IllegalAccessException, InvocationTargetException {
        if (this.webDD.getPostConstructs() == null) {
            return;
        }
        for (LifecycleCallbackMetaData metaData : this.webDD.getPostConstructs()) {
            try {
                Class<?> clazz = this.webLoader.loadClass(metaData.getClassName());
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                this.processesLifecycleCallbackMetaData(object, metaData);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error invoking postConstruct method: " + metaData.getMethodName(), e);
            }
        }
    }

    public void preDestroy(Object object) throws IllegalAccessException, InvocationTargetException {
        if (this.webDD.getPreDestroys() == null) {
            return;
        }
        for (LifecycleCallbackMetaData metaData : this.webDD.getPreDestroys()) {
            try {
                Class<?> clazz = this.webLoader.loadClass(metaData.getClassName());
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                this.processesLifecycleCallbackMetaData(object, metaData);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error invoking postConstruct method: " + metaData.getMethodName(), e);
            }
        }
    }

    public void processInjectors(Object object) {
        boolean trace = log.isTraceEnabled();
        Map<AccessibleObject, Injector> injectors = this.getEncInjectionsForObject(object);
        if (injectors == null || injectors.size() == 0) {
            if (trace) {
                log.trace((Object)("-- no injectors found for: " + object));
            }
            return;
        }
        if (trace) {
            log.trace((Object)("-- doing injections for: " + object));
        }
        for (Injector injector : injectors.values()) {
            injector.inject(object);
        }
    }

    protected void processDynamicBeanAnnotations(Object object) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.isDynamicBean(object)) {
            this.processAnnotations(object);
        }
    }

    public void processAnnotations(Object object) throws IllegalAccessException, InvocationTargetException, NamingException {
        boolean trace = log.isTraceEnabled();
        Map<AccessibleObject, Injector> injectors = this.getEncInjectionsForClass(object.getClass(), true);
        if (injectors == null) {
            if (trace) {
                log.trace((Object)("**************** Processing annotations for: " + object.getClass().getName()));
            }
            this.encInjectors.recordAdded();
            TomcatInjectionUtils.processDynamicBeanAnnotations((InjectionContainer)this, this.handlers, object.getClass());
            if (this.encInjectors.getAdded().size() > 0) {
                for (EncInjector encInjector : this.encInjectors.getAdded().values()) {
                    encInjector.inject((InjectionContainer)this);
                }
                this.encInjectors.clearAdded();
            }
            this.processInjectors(object);
        }
    }

    private Map<AccessibleObject, Injector> getEncInjectionsForObject(Object object) {
        if (object == null || object.getClass() == Object.class) {
            return null;
        }
        return this.getEncInjectionsForClass(object.getClass(), this.isDynamicBean(object));
    }

    private Map<AccessibleObject, Injector> getEncInjectionsForClass(Class<?> clazz, boolean isDynamic) {
        if (clazz == null || clazz == Object.class) {
            return null;
        }
        Map<AccessibleObject, Injector> injectors = this.encInjections.get(clazz.getName());
        Map<AccessibleObject, Injector> additionalInjectors = null;
        if (clazz.getSuperclass() != null && !isDynamic) {
            additionalInjectors = this.getEncInjectionsForClass(clazz.getSuperclass(), isDynamic);
        }
        if (injectors == null) {
            return additionalInjectors;
        }
        if (additionalInjectors != null) {
            injectors.putAll(additionalInjectors);
        }
        return injectors;
    }

    private boolean isDynamicBean(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null class");
        }
        ClassLoader loader = object.getClass().getClassLoader();
        if (loader == null) {
            return false;
        }
        String classLoaderName = loader.getClass().getName();
        return dynamicClassLoaders.contains(classLoaderName);
    }

    public void populateEnc(ClassLoader loader) {
        for (EncInjector injector : this.encInjectors.values()) {
            injector.inject((InjectionContainer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processesLifecycleCallbackMetaData(Object object, LifecycleCallbackMetaData lifeCycleMetaData) throws IllegalAccessException, InvocationTargetException {
        Object[] args = null;
        AccessibleObject method = null;
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(lifeCycleMetaData.getMethodName())) continue;
                method = m;
            }
            if (method != null) break;
        }
        if (method == null) {
            throw new IllegalStateException("Method: " + lifeCycleMetaData.getMethodName() + " not found.");
        }
        boolean accessible = method.isAccessible();
        try {
            ((Method)method).setAccessible(true);
            ((Method)method).invoke(object, args);
        }
        finally {
            ((Method)method).setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetadata() {
        WebEJBHandler webEjbHandler = new WebEJBHandler(this.webDD, this.deploymentEndpointResolver, this.endpointMap, this.unit.getRelativePath());
        this.handlers = new ArrayList<InjectionHandler<Environment>>();
        this.handlers.add((InjectionHandler<Environment>)webEjbHandler);
        this.handlers.add((InjectionHandler<Environment>)new DependsHandler());
        this.handlers.add((InjectionHandler<Environment>)new PersistenceContextHandler());
        this.handlers.add((InjectionHandler<Environment>)new PersistenceUnitHandler());
        this.handlers.add(new WebResourceHandler());
        this.handlers.add((InjectionHandler<Environment>)new WebServiceRefInjectionHandler());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader webLoader = this.getClassloader();
        Thread.currentThread().setContextClassLoader(webLoader);
        try {
            for (InjectionHandler<Environment> handler : this.handlers) {
                handler.loadXml((RemoteEnvironment)this.webDD.getJndiEnvironmentRefsGroup(), (InjectionContainer)this);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    public List<Injector> getInjectors() {
        return new ArrayList<Injector>();
    }

    public VirtualFile getRootFile() {
        if (this.unit instanceof VFSDeploymentUnit) {
            return ((VFSDeploymentUnit)this.unit).getRoot();
        }
        return null;
    }

    public String getIdentifier() {
        return this.unit.getSimpleName();
    }

    public String getDeploymentDescriptorType() {
        return "web.xml";
    }

    public ClassLoader getClassloader() {
        return this.webLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.webLoader = loader;
    }

    public javax.naming.Context getEnc() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassloader());
            try {
                javax.naming.Context context = (javax.naming.Context)new InitialContext().lookup("java:comp");
                return context;
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    public Container resolveEjbContainer(String link, Class<?> businessIntf) {
        return null;
    }

    public Container resolveEjbContainer(Class<?> businessIntf) throws NameNotFoundException {
        return null;
    }

    public String getEjbJndiName(Class<?> businessIntf) throws NameNotFoundException {
        throw new IllegalStateException("Resolution should not happen via injection container");
    }

    public String getEjbJndiName(String link, Class<?> businessIntf) {
        throw new IllegalStateException("Resolution should not happen via injection container");
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        return clazz.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        return method.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return field.getAnnotation(annotationType);
    }

    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    public String resolveMessageDestination(String link) {
        throw new IllegalStateException("Resolution should not happen via injection container");
    }

    public String resolvePersistenceUnitSupplier(String persistenceUnitName) {
        return this.persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(this.unit, persistenceUnitName);
    }

    static {
        InputStream is;
        log = Logger.getLogger(TomcatInjectionContainer.class);
        dynamicClassLoaders = new HashSet<String>();
        restrictedFilters = new Properties();
        restrictedListeners = new Properties();
        restrictedServlets = new Properties();
        try {
            is = TomcatInjectionContainer.class.getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedServlets.properties");
            if (is != null) {
                restrictedServlets.load(is);
            } else {
                log.error((Object)"Could not load org/apache/catalina/core/RestrictedServlets.properties");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading org/apache/catalina/core/RestrictedServlets.properties", (Throwable)e);
        }
        try {
            is = TomcatInjectionContainer.class.getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedListeners.properties");
            if (is != null) {
                restrictedListeners.load(is);
            } else {
                log.error((Object)"Could not load org/apache/catalina/core/RestrictedListeners.properties");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading org/apache/catalina/core/RestrictedListeners.properties", (Throwable)e);
        }
        try {
            is = TomcatInjectionContainer.class.getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedFilters.properties");
            if (is != null) {
                restrictedFilters.load(is);
            } else {
                log.error((Object)"Could not load org/apache/catalina/core/RestrictedFilters.properties");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error reading org/apache/catalina/core/RestrictedFilters.properties", (Throwable)e);
        }
        dynamicClassLoaders.add("org.apache.jasper.servlet.JasperLoader");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EncMap
    extends HashMap<String, EncInjector> {
        private HashMap<String, EncInjector> added;

        private EncMap() {
        }

        public void recordAdded() {
            this.added = new HashMap();
        }

        public void clearAdded() {
            this.added = null;
        }

        public Map<String, EncInjector> getAdded() {
            return this.added;
        }

        @Override
        public EncInjector put(String key, EncInjector value) {
            if (this.added != null) {
                this.added.put(key, value);
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends EncInjector> m) {
            if (this.added != null) {
                this.added.putAll(m);
            }
            super.putAll(m);
        }
    }
}

