/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.DelegatingObjectModelFactory;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.jboss.xb.binding.metadata.unmarshalling.BindingCursor;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;

public class ObjectModelBuilder
implements UnmarshallingContext,
JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger(ObjectModelBuilder.class);
    private static final Object IGNORED = new Object();
    private Object root;
    private Stack all = new StackImpl();
    private Stack accepted = new StackImpl();
    private GenericObjectModelFactory curFactory;
    private String curNameSwitchingFactory;
    private String curNsSwitchingFactory;
    private Stack nameSwitchingFactory;
    private Stack nsSwitchingFactory;
    private GenericObjectModelFactory defaultFactory;
    private Map factoriesToNs = Collections.EMPTY_MAP;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private XSTypeDefinition currentType;
    private BindingCursor metadataCursor;
    private boolean trace = log.isTraceEnabled();

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        if (this.factoriesToNs == Collections.EMPTY_MAP) {
            this.factoriesToNs = new HashMap();
        }
        this.factoriesToNs.put(namespaceUri, ObjectModelBuilder.getGenericObjectModelFactory(factory));
    }

    public void init(ObjectModelFactory defaultFactory, Object root, BindingCursor cursor) {
        this.defaultFactory = ObjectModelBuilder.getGenericObjectModelFactory(defaultFactory);
        this.metadataCursor = cursor;
        this.all.clear();
        this.accepted.clear();
        this.root = root;
    }

    public void pushFactory(String namespaceURI, String localName, GenericObjectModelFactory factory) {
        if (this.curNsSwitchingFactory != null) {
            if (this.nsSwitchingFactory == null) {
                this.nsSwitchingFactory = new StackImpl();
                this.nameSwitchingFactory = new StackImpl();
            }
            this.nsSwitchingFactory.push(this.curNsSwitchingFactory);
            this.nameSwitchingFactory.push(this.curNameSwitchingFactory);
        }
        this.curNsSwitchingFactory = namespaceURI;
        this.curNameSwitchingFactory = localName;
        this.curFactory = factory;
    }

    public void popFactory() {
        if (this.nsSwitchingFactory == null || this.nsSwitchingFactory.isEmpty()) {
            this.curNameSwitchingFactory = null;
            this.curNsSwitchingFactory = null;
        } else {
            this.curNameSwitchingFactory = (String)this.nameSwitchingFactory.pop();
            this.curNsSwitchingFactory = (String)this.nsSwitchingFactory.pop();
        }
        this.curFactory = this.getFactory(this.curNsSwitchingFactory);
    }

    public Iterator getNamespaceURIs() {
        return this.nsRegistry.getRegisteredURIs();
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsRegistry;
    }

    public Object getMetadata() {
        return this.metadataCursor.getElementBinding();
    }

    public Object getParentMetadata() {
        return this.metadataCursor.getParentElementBinding();
    }

    public QName resolveQName(String value) {
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() == 1) {
            return new QName(value);
        }
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Illegal QName: " + value);
        }
        String prefix = st.nextToken();
        String local = st.nextToken();
        String nsURI = this.nsRegistry.getNamespaceURI(prefix);
        if (nsURI == null) {
            throw new IllegalStateException("Cannot obtain namespace URI for prefix: " + prefix);
        }
        return new QName(nsURI, local, prefix);
    }

    public String getChildContent(String namespaceURI, String qName) {
        throw new UnsupportedOperationException();
    }

    public XSTypeDefinition getType() {
        return this.currentType;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
        ObjectModelFactory factory;
        int end;
        if (!"jbossxb".equals(target)) {
            return;
        }
        int i = data.indexOf("factory=\"");
        if (i != -1) {
            Class<?> factoryCls;
            end = data.indexOf(34, i + 9);
            if (end == -1) {
                throw new JBossXBRuntimeException("Property 'factory' is not terminated with '\"' in processing instruction: " + data);
            }
            String factoryProp = data.substring(i + 9, end);
            try {
                factoryCls = Thread.currentThread().getContextClassLoader().loadClass(factoryProp);
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load factory class : " + e.getMessage(), e);
            }
            try {
                factory = (ObjectModelFactory)factoryCls.newInstance();
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to instantiate factory " + factoryProp + ": " + e.getMessage(), e);
            }
            i = data.indexOf("ns=\"");
            if (i == -1) {
                throw new JBossXBRuntimeException("Property 'ns' not found in factory mapping processing instruction: " + data);
            }
            end = data.indexOf("\"", i + 4);
            if (end == -1) {
                throw new JBossXBRuntimeException("Property 'ns' is not terminated with '\"' in processing instruction: " + data);
            }
        } else {
            throw new JBossXBRuntimeException("Unexpected data in processing instruction: target=" + target + ", data=" + data);
        }
        String nsProp = data.substring(i + 4, end);
        this.mapFactoryToNamespace(factory, nsProp);
    }

    public Object getRoot() {
        if (!this.all.isEmpty()) {
            this.popAll();
            this.popAccepted();
        }
        return this.root;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition type) {
        Object element;
        Object parent = this.accepted.isEmpty() ? this.root : this.peekAccepted();
        this.metadataCursor.startElement(namespaceURI, localName);
        this.currentType = type;
        if (!namespaceURI.equals(this.curNsSwitchingFactory)) {
            GenericObjectModelFactory newFactory = this.getFactory(namespaceURI);
            element = newFactory != this.curFactory ? newFactory.newRoot(parent, this, namespaceURI, localName, atts) : newFactory.newChild(parent, this, namespaceURI, localName, atts);
            this.pushFactory(namespaceURI, localName, newFactory);
        } else {
            element = this.curFactory.newChild(parent, this, namespaceURI, localName, atts);
        }
        if (element == null) {
            this.pushAll(IGNORED);
            if (this.trace) {
                log.trace("ignored " + namespaceURI + ':' + qName);
            }
        } else {
            this.pushAll(element);
            this.pushAccepted(element);
            if (this.trace) {
                log.trace("accepted " + namespaceURI + ':' + qName);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        AllElement element = this.popAll();
        if (!this.accepted.isEmpty()) {
            Object acceptedElement = this.peekAccepted();
            String characters = element.characters;
            if (characters != null && (characters = characters.trim()).length() > 0) {
                this.curFactory.setValue(acceptedElement, this, namespaceURI, localName, characters);
            }
        }
        if (localName.equals(this.curNameSwitchingFactory) && namespaceURI.equals(this.curNsSwitchingFactory)) {
            this.popFactory();
        }
        if (element.element != IGNORED) {
            Object parent;
            this.popAccepted();
            Object object = parent = this.accepted.isEmpty() ? null : this.peekAccepted();
            if (parent != null) {
                this.curFactory.addChild(parent, element.element, this, namespaceURI, localName);
            } else {
                this.root = this.curFactory.completeRoot(element.element, this, namespaceURI, localName);
            }
        }
        this.metadataCursor.endElement(namespaceURI, localName);
    }

    public void characters(char[] ch, int start, int length) {
        if (!this.accepted.isEmpty()) {
            String str = String.valueOf(ch, start, length);
            AllElement allElement = this.peekAll();
            allElement.characters = allElement.characters == null ? str : allElement.characters + str;
        }
    }

    private GenericObjectModelFactory getFactory(String namespaceUri) {
        GenericObjectModelFactory factory = (GenericObjectModelFactory)this.factoriesToNs.get(namespaceUri);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return factory;
    }

    static Object invokeFactory(Object factory, Method method, Object[] args) {
        try {
            return method.invoke(factory, args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getCause();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            String msg = "Failed to invoke method " + method + ", factory=" + factory;
            log.error(msg, e.getTargetException());
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(te);
            throw ise;
        }
        catch (Exception e) {
            String msg = "Failed to invoke method " + method.getName() + ", factory=" + factory;
            log.error(msg, e);
            IllegalStateException ise = new IllegalStateException(msg);
            ise.initCause(e);
            throw ise;
        }
    }

    static Method getMethodForElement(Object factory, String name, Class[] params) {
        Method method = null;
        try {
            method = factory.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw e;
        }
        return method;
    }

    static final GenericObjectModelFactory getGenericObjectModelFactory(ObjectModelFactory factory) {
        if (!(factory instanceof GenericObjectModelFactory)) {
            factory = new DelegatingObjectModelFactory(factory);
        }
        return factory instanceof GenericObjectModelFactory ? (GenericObjectModelFactory)factory : new DelegatingObjectModelFactory(factory);
    }

    private void pushAccepted(Object o) {
        this.accepted.push(o);
    }

    private Object popAccepted() {
        return this.accepted.pop();
    }

    private Object peekAccepted() {
        return this.accepted.peek();
    }

    private void pushAll(Object o) {
        this.all.push(new AllElement(o));
    }

    private AllElement popAll() {
        return (AllElement)this.all.pop();
    }

    private AllElement peekAll() {
        return (AllElement)this.all.peek();
    }

    private static class StackImpl
    implements Stack {
        private LinkedList list = new LinkedList();

        private StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }

    private static final class AllElement {
        public final Object element;
        public String characters;

        public AllElement(Object element) {
            this.element = element;
        }
    }
}

