/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoader;

public class JDBCCacheLoaderConfig
extends AdjListJDBCCacheLoaderConfig {
    private static final long serialVersionUID = -8371846151643130271L;
    private String recursiveChildrenSql;
    private String nodeCountSql;
    private boolean batchEnabled = true;
    private long batchSize = 1000L;

    public JDBCCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        super(base);
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public JDBCCacheLoaderConfig() {
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.deleteNodeSql = this.constructDeleteNodeSql();
        this.recursiveChildrenSql = this.constructRecursiveChildrenSql();
        this.nodeCountSql = this.constructNodeCountSql();
        this.batchEnabled = Boolean.valueOf(props.getProperty("cache.jdbc.batch.enable"));
        if (props.containsKey("cache.jdbc.batch.size")) {
            this.batchSize = Long.parseLong(props.getProperty("cache.jdbc.batch.size"));
        }
    }

    public String getDeleteNodeSql() {
        if (this.deleteNodeSql == null) {
            this.deleteNodeSql = this.constructDeleteNodeSql();
        }
        return this.deleteNodeSql;
    }

    public String getRecursiveChildrenSql() {
        if (this.recursiveChildrenSql == null) {
            this.recursiveChildrenSql = this.constructRecursiveChildrenSql();
        }
        return this.recursiveChildrenSql;
    }

    public void setRecursiveChildrenSql(String recursiveChildrenSql) {
        this.recursiveChildrenSql = recursiveChildrenSql;
    }

    public String getNodeCountSql() {
        if (this.nodeCountSql == null) {
            this.nodeCountSql = this.constructNodeCountSql();
        }
        return this.nodeCountSql;
    }

    public void setNodeCountSql(String nodeCountSql) {
        this.nodeCountSql = nodeCountSql;
    }

    @Deprecated
    public String getSqlConcat() {
        return "";
    }

    @Deprecated
    public void setSqlConcat(String sqlConcat) {
    }

    public boolean isBatchEnabled() {
        return this.batchEnabled;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    private String constructNodeCountSql() {
        return "SELECT COUNT(*) FROM " + this.table;
    }

    private String constructRecursiveChildrenSql() {
        return "SELECT " + this.fqnColumn + "," + this.nodeColumn + " FROM " + this.table + " WHERE " + this.fqnColumn + " = ? OR " + this.fqnColumn + " LIKE ?";
    }

    private String constructDeleteNodeSql() {
        return "DELETE FROM " + this.table + " WHERE " + this.fqnColumn + " = ? OR " + this.fqnColumn + " LIKE ?";
    }
}

