/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSClientConfig;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger(ClientEndpointMetaData.class);
    private WSClientConfig clientConfig;

    public ClientEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
        this.setConfigName("Standard Client");
        this.setConfigFile("META-INF/standard-jbossws-client-config.xml");
    }

    public WSClientConfig getClientConfig() {
        if (this.clientConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configName = this.getConfigName();
            String configFile = this.getConfigFile();
            log.debug((Object)("getClientConfig: [name=" + configName + ",url=" + configFile + "]"));
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException("Cannot get resource: " + configFile);
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.clientConfig = wsConfig.getClientConfigByName(configName);
            if (this.clientConfig == null) {
                throw new WSException("Cannot obtain client config: " + configName);
            }
            if (!configName.equals(this.clientConfig.getConfigName())) {
                configName = this.clientConfig.getConfigName();
                log.debug((Object)("Using config name: " + configName));
                this.setConfigName(configName);
            }
        }
        return this.clientConfig;
    }

    @Override
    public List<HandlerMetaData> getHandlers() {
        ArrayList<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
        WSHandlerChainConfig preHandlerConfig = this.getClientConfig().getPreHandlerChain();
        if (preHandlerConfig != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        handlers.addAll(super.getHandlers());
        WSHandlerChainConfig postHandlerConfig = this.getClientConfig().getPostHandlerChain();
        if (postHandlerConfig != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nClientEndpointMetaData:");
        buffer.append("\n name=" + this.getName());
        buffer.append("\n address=" + this.getEndpointAddress());
        buffer.append("\n seiName=" + this.getServiceEndpointInterfaceName());
        buffer.append("\n configFile=" + this.getConfigFile());
        buffer.append("\n configName=" + this.getConfigName());
        buffer.append("\n authMethod=" + this.getAuthMethod());
        buffer.append("\n transportGuarantee=" + this.getTransportGuarantee());
        buffer.append("\n properties=" + this.getProperties());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append("\n" + opMetaData);
        }
        for (HandlerMetaData hdlMetaData : this.getHandlers()) {
            buffer.append("\n" + hdlMetaData);
        }
        return buffer.toString();
    }
}

