/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.metadata.wsdl.WSDL11Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Writer;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class WSDLDefinitionsFactory {
    private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private Map features = new HashMap();

    private WSDLDefinitionsFactory() {
    }

    public static WSDLDefinitionsFactory newInstance() {
        return new WSDLDefinitionsFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.features.put(name, new Boolean(value));
    }

    public WSDLDefinitions parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        log.debug((Object)("parse: " + wsdlLocation.toExternalForm()));
        WSDLDefinitions wsdlDefinitions = null;
        try {
            Document wsdlDoc = this.getDocument(wsdlLocation);
            String defaultNamespace = this.getDefaultNamespace(wsdlDoc);
            if ("http://www.w3.org/2003/11/wsdl".equals(defaultNamespace)) {
                WSDL20Reader wsdlReader = new WSDL20Reader();
                for (Map.Entry entry : this.features.entrySet()) {
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag);
                }
                wsdlDefinitions = wsdlReader.readWSDL(new WSDLLocatorImpl(wsdlLocation));
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespace)) {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                wsdlReader.setFeature(FEATURE_VERBOSE, false);
                for (Map.Entry entry : this.features.entrySet()) {
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag.booleanValue());
                }
                ((WSDLReaderImpl)wsdlReader).setEntityResolver((EntityResolver)new JBossEntityResolver());
                Definition definition = wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl(wsdlLocation));
                wsdlDefinitions = new WSDL11Reader().processDefinition(definition, wsdlLocation);
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else {
                throw new WSDLException("Invalid default namespace: " + defaultNamespace);
            }
            if (log.isTraceEnabled()) {
                StringWriter stwr = new StringWriter();
                WSDL20Writer wsdl20Writer = new WSDL20Writer(wsdlDefinitions);
                wsdl20Writer.write(stwr);
                log.trace((Object)("\n" + stwr.toString()));
            }
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
        return wsdlDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(URL wsdlLocation) throws WSDLException {
        Document document;
        InputStream wsdlInputStream = wsdlLocation.openStream();
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            document = builder.parse(wsdlInputStream);
        }
        catch (Throwable throwable) {
            try {
                wsdlInputStream.close();
                throw throwable;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSDLException(e);
            }
        }
        wsdlInputStream.close();
        return document;
    }

    private String getDefaultNamespace(Document wsdlDoc) throws WSDLException {
        Element root = wsdlDoc.getDocumentElement();
        String defaultNamespace = root.getNamespaceURI();
        return defaultNamespace;
    }

    public static class WSDLLocatorImpl
    implements WSDLLocator {
        private URL wsdlURL;
        private String latestImportURI;

        public WSDLLocatorImpl(URL wsdlFile) {
            if (wsdlFile == null) {
                throw new IllegalArgumentException("WSDL file argument cannot be null");
            }
            this.wsdlURL = wsdlFile;
        }

        public InputSource getBaseInputSource() {
            log.trace((Object)("getBaseInputSource [wsdlUrl=" + this.wsdlURL + "]"));
            try {
                InputStream is = this.wsdlURL.openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlURL + "]");
                }
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access wsdl from [" + this.wsdlURL + "], " + e.getMessage());
            }
        }

        public String getBaseURI() {
            return this.wsdlURL.toExternalForm();
        }

        public InputSource getImportInputSource(String parent, String resource) {
            log.trace((Object)("getImportInputSource [parent=" + parent + ",resource=" + resource + "]"));
            URL parentURL = null;
            try {
                parentURL = new URL(parent);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Not a valid URL: " + parent));
                return null;
            }
            String wsdlImport = null;
            String external = parentURL.toExternalForm();
            if (resource.startsWith("http://") || resource.startsWith("https://")) {
                wsdlImport = resource;
            } else if (resource.startsWith("/")) {
                String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
                wsdlImport = beforePath + resource;
            } else {
                String parentDir = external.substring(0, external.lastIndexOf("/"));
                while (resource.startsWith("./")) {
                    resource = resource.substring(2);
                }
                while (resource.startsWith("../")) {
                    parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                    resource = resource.substring(3);
                }
                wsdlImport = parentDir + "/" + resource;
            }
            try {
                log.trace((Object)("Resolved to: " + wsdlImport));
                InputStream is = new URL(wsdlImport).openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot import wsdl from [" + wsdlImport + "]");
                }
                this.latestImportURI = wsdlImport;
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
            }
        }

        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }
}

