/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSEntityResolver;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSStringList;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.helpers.JavaToXSDHelper;
import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToXSD
implements JavaToXSDIntf {
    private static final Logger log = Logger.getLogger(JavaToXSD.class);
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected String jaxrpcAssert = "JAXRPC2.0 Assertion:";
    protected JavaToXSDHelper helper = new JavaToXSDHelper();

    public JavaToXSD() {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        JBossXSModel xsmodel = creator.getXSModel();
        if (xsmodel == null) {
            creator.setXSModel(new JBossXSModel());
        }
    }

    @Override
    public JBossXSModel generateForSingleType(QName xmlType, Class javaType) throws IOException {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        creator.generateType(xmlType, javaType);
        return creator.getXSModel();
    }

    @Override
    public JBossXSModel generateForSingleType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        creator.generateType(xmlType, javaType, elementNames);
        return creator.getXSModel();
    }

    @Override
    public SchemaCreatorIntf getSchemaCreator() {
        return this.helper.getSchemaCreator();
    }

    public JBossXSModel parseSchema(URL xsdURL) {
        JBossXSErrorHandler xserr = new JBossXSErrorHandler();
        XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, null);
        XSModel xsmodel = loader.loadURI(xsdURL.toExternalForm());
        String typeNamespace = SchemaUtils.getTargetNamespace(xsmodel);
        if (xsmodel == null) {
            throw new WSException("Parsed XSModel is null");
        }
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
        JBossXSModel jbxs = new JBossXSModel();
        sutils.copyXSModel(xsmodel, jbxs);
        return jbxs;
    }

    public JBossXSModel parseSchema(List<String> locations) {
        XSModel xsmodel = this.schemautils.parseSchema(locations);
        String typeNamespace = SchemaUtils.getTargetNamespace(xsmodel);
        if (xsmodel == null) {
            throw new WSException("Parsed XSModel is null");
        }
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
        JBossXSModel jbxs = new JBossXSModel();
        sutils.copyXSModel(xsmodel, jbxs);
        return jbxs;
    }

    public JBossXSModel parseSchema(Map<String, URL> locs) {
        if (locs == null) {
            throw new IllegalArgumentException("Illegal Null Argument:locs");
        }
        if (locs.size() == 0) {
            throw new IllegalArgumentException("Illegal size Argument:locs is zero");
        }
        Collection<URL> col = locs.values();
        ArrayList<String> strlist = new ArrayList<String>();
        for (URL uri : col) {
            strlist.add(uri.toExternalForm());
        }
        JBossXSErrorHandler xserr = new JBossXSErrorHandler();
        JBossXSEntityResolver xsresolve = new JBossXSEntityResolver(locs);
        XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, xsresolve);
        ArrayList<String> locations = new ArrayList<String>();
        Collection<URL> urls = locs.values();
        for (URL url : urls) {
            locations.add(url.toExternalForm());
        }
        JBossXSStringList slist = new JBossXSStringList((List<String>)locations);
        XSModel xsmodel = loader.loadURIList((StringList)slist);
        if (xsmodel == null) {
            throw new WSException("Cannot load schema: " + slist);
        }
        String typeNamespace = SchemaUtils.getTargetNamespace(xsmodel);
        if (xsmodel == null) {
            throw new WSException("Parsed XSModel is null");
        }
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
        JBossXSModel jbxs = new JBossXSModel();
        sutils.copyXSModel(xsmodel, jbxs);
        return jbxs;
    }

    @Override
    public void setPackageNamespaceMap(Map<String, String> map) {
        this.helper.setPackageNamespaceMap(map);
    }

    @Override
    public void setWSDLStyle(String style) {
        this.helper.setWsdlStyle(style);
    }

    private Class loadClass(String classname) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(classname);
    }

    private SchemaBindingResolver getSchemaBindingResolver(final Map<String, URL> map) {
        return new SchemaBindingResolver(){

            public String getBaseURI() {
                throw new UnsupportedOperationException("getBaseURI is not implemented.");
            }

            public void setBaseURI(String baseURI) {
                throw new UnsupportedOperationException("setBaseURI is not implemented.");
            }

            public SchemaBinding resolve(String nsUri, String baseURI, String schemaLocation) {
                throw new UnsupportedOperationException("resolve is not implemented.");
            }

            public LSInput resolveAsLSInput(String nsUri, String baseUri, String schemaLocation) {
                URL url = (URL)map.get(nsUri);
                if (url != null) {
                    try {
                        return new LSInputAdaptor(url.openStream(), null);
                    }
                    catch (IOException e) {
                        log.error((Object)"URL is bad for schema parsing");
                    }
                }
                return null;
            }
        };
    }
}

