/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.transport.jms;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NotImplementedException;
import org.jboss.webservice.transport.jms.MessageDispatcher;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.server.ServiceEndpoint;
import org.jboss.ws.server.ServiceEndpointInvoker;
import org.jboss.ws.server.ServiceEndpointInvokerMDB;
import org.jboss.ws.server.ServiceEndpointManagerMBean;

public class JMSMessageDispatcher
implements MessageDispatcher {
    protected Logger log = Logger.getLogger(JMSMessageDispatcher.class);

    public SOAPMessage dipatchMessage(String fromName, Object targetBean, InputStream reqMessage) throws RemoteException {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ServiceEndpointManagerMBean sepManager = (ServiceEndpointManagerMBean)MBeanProxy.get(ServiceEndpointManagerMBean.class, (ObjectName)ServiceEndpointManagerMBean.OBJECT_NAME, (MBeanServer)server);
            ObjectName serviceID = this.getServiceEndpointForDestination(sepManager, fromName);
            if (serviceID == null) {
                throw new WSException("Cannot find serviceID for: " + fromName);
            }
            this.log.debug((Object)("dipatchMessage: " + serviceID));
            ServiceEndpoint sep = sepManager.getServiceEndpointByID(serviceID);
            ServiceEndpointInvoker invoker = sep.getServiceEndpointInfo().getInvoker();
            if (invoker instanceof ServiceEndpointInvokerMDB) {
                ServiceEndpointInvokerMDB mdbInvoker = (ServiceEndpointInvokerMDB)invoker;
                mdbInvoker.setTargetBeanObject(targetBean);
            }
            return sep.handleRequest(null, null, reqMessage);
        }
        catch (MBeanProxyCreationException ex) {
            throw new WSException("Cannot create proxy to service endpoint manager", ex);
        }
        catch (BindingException ex) {
            throw new WSException("Cannot bind incomming soap message", ex);
        }
    }

    public SOAPMessage delegateMessage(String serviceID, InputStream soapMessage) throws RemoteException {
        throw new NotImplementedException();
    }

    private ObjectName getServiceEndpointForDestination(ServiceEndpointManagerMBean sepManager, String fromName) {
        ObjectName serviceID = null;
        Iterator it = sepManager.getServiceEndpointNames();
        while (it.hasNext()) {
            ObjectName aux = (ObjectName)it.next();
            String jmsProp = aux.getKeyProperty("jms");
            if (jmsProp == null || !jmsProp.equals(fromName)) continue;
            serviceID = aux;
            break;
        }
        return serviceID;
    }
}

