/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web;

import com.jinfonet.web.UserInfo;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import jet.cs.util.APIUtil;

public final class UserInfoImpl
implements UserInfo {
    private static final long serialVersionUID = -304054604458823585L;
    private String FALSE;
    private String SEDU;
    private String booleanValue;
    private Locale equals = null;
    private String equalsIgnoreCase;
    private TimeZone get = null;
    private String getClass;
    private boolean getCountry;
    private boolean getDefault;
    private int getDisplayName;
    private JSONObject getEncoding;
    private boolean getID;
    private String getLanguage;
    private String getName;
    private int getProperty;

    public UserInfoImpl(String string) {
        this.FALSE = string;
        if (string != null) {
            this.getID = APIUtil.isBelongToOrganization(string);
            if (this.getID) {
                String[] stringArray = APIUtil.parsePrincipalDisplayName(string);
                this.getLanguage = stringArray[0];
                this.getName = stringArray[1];
            }
        }
        this.equals = Locale.getDefault();
        this.SEDU = this.equals.getCountry();
        this.booleanValue = this.equals.getLanguage();
        this.getClass = "UTF-8";
        this.get = TimeZone.getDefault();
        this.equalsIgnoreCase = this.get.getID();
        this.getEncoding = new JSONObject();
    }

    @Override
    public String getUserID() {
        return this.FALSE;
    }

    public void setUserID(String string) {
        this.FALSE = string;
    }

    @Override
    public String getCountry() {
        return this.SEDU;
    }

    @Override
    public String getLanguage() {
        return this.booleanValue;
    }

    @Override
    public Locale getLocale() {
        return this.equals == null ? Locale.getDefault() : this.equals;
    }

    public void setLocale(String string, String string2) {
        if (!this.booleanValue.equalsIgnoreCase(string) || !this.SEDU.equalsIgnoreCase(string2)) {
            this.equals = string2 == null ? new Locale(string) : new Locale(string, string2);
        }
        this.booleanValue = this.equals.getLanguage();
        this.SEDU = this.equals.getCountry();
    }

    @Override
    public String getEncoding() {
        return this.getClass;
    }

    public void setEncoding(String string) {
        this.getClass = string;
    }

    @Override
    public String getTimeZoneID() {
        return this.equalsIgnoreCase;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.get == null ? TimeZone.getDefault() : this.get;
    }

    public void setTimeZone(String string) {
        if (!this.equalsIgnoreCase.equals(string)) {
            this.equalsIgnoreCase = string;
            this.get = TimeZone.getTimeZone(string);
        }
    }

    @Override
    public int getLoginSite() {
        return this.getProperty;
    }

    @Override
    public void setLoginSite(int n) {
        this.getProperty = n;
    }

    @Override
    public Object getProperty(String string, Object ... objectArray) {
        Object object = this.getEncoding.get((Object)string);
        if (object == null && objectArray.length > 0) {
            object = objectArray[0];
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.getEncoding.put(string, object);
    }

    @Override
    public Map getProperties() {
        return this.getEncoding;
    }

    public String getObjectClass() {
        return this.getClass().getName();
    }

    public String toString() {
        try {
            return this.toJSONObject().toString();
        }
        catch (JSONException jSONException) {
            return super.toString();
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("user", (Object)(this.FALSE != null ? this.FALSE : ""));
        jSONObject.put("country", (Object)this.getCountry());
        jSONObject.put("lang", (Object)this.getLanguage());
        jSONObject.put("timezone", (Object)this.getTimeZoneID());
        jSONObject.put("encoding", (Object)this.getEncoding());
        jSONObject.put("isOrg", (Object)this.getID);
        if (this.getID) {
            jSONObject.put("orgName", (Object)this.getLanguage);
            jSONObject.put("userName", (Object)this.getName);
        }
        if (this.getEncoding != null) {
            jSONObject.put("prefer", (Object)this.getEncoding);
        }
        Locale locale = this.getRptLocale();
        jSONObject.put("dispLocale", (Object)locale.getDisplayName(locale));
        return jSONObject;
    }

    public static UserInfoImpl parse(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        return UserInfoImpl.parse(jSONObject);
    }

    public static UserInfoImpl parse(JSONObject jSONObject) throws JSONException {
        String string = jSONObject.optString("user", null);
        UserInfoImpl userInfoImpl = new UserInfoImpl(string);
        String string2 = jSONObject.optString("encoding", "UTF-8");
        userInfoImpl.setEncoding(string2);
        String string3 = jSONObject.optString("lang", "en");
        String string4 = jSONObject.optString("country", "US");
        userInfoImpl.setLocale(string3, string4);
        String string5 = jSONObject.optString("timezone", "GMT");
        userInfoImpl.setTimeZone(string5);
        JSONObject jSONObject2 = jSONObject.optJSONObject("prefer");
        if (jSONObject2 != null) {
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string6 = (String)iterator.next();
                userInfoImpl.setProperty(string6, jSONObject2.opt(string6));
            }
        }
        return userInfoImpl;
    }

    @Override
    public boolean hasPublishPrivilege() {
        Boolean bl = (Boolean)this.getProperty("publish", Boolean.FALSE);
        return bl;
    }

    @Override
    public boolean isAdmin() {
        Boolean bl = (Boolean)this.getProperty("isAdmin", Boolean.FALSE);
        return bl;
    }

    @Override
    public String getRptCountry() {
        return (String)this.getProperty("rpt_country", this.SEDU);
    }

    @Override
    public String getRptLanguage() {
        return (String)this.getProperty("rpt_lang", this.booleanValue);
    }

    @Override
    public Locale getRptLocale() {
        String string = (String)this.getProperty("rpt_lang", this.booleanValue);
        if (string == null) {
            return this.equals;
        }
        String string2 = (String)this.getProperty("rpt_country", new Object[0]);
        return string2 == null ? new Locale(string) : new Locale(string, string2);
    }

    @Override
    public String getRptEncoding() {
        return (String)this.getProperty("rpt_encoding", this.getClass);
    }

    @Override
    public TimeZone getRptTimeZone() {
        Object object = this.getProperty("rpt_timezone", this.getTimeZone());
        if (object instanceof TimeZone) {
            return (TimeZone)object;
        }
        if (object instanceof String) {
            return TimeZone.getTimeZone((String)object);
        }
        return null;
    }

    @Override
    public boolean isOrg() {
        return this.getID;
    }

    @Override
    public String getOrgName() {
        return this.getLanguage;
    }

    @Override
    public String getUserName() {
        return this.getName;
    }

    @Override
    public void setOrgName(String string) {
        this.getLanguage = string;
    }

    @Override
    public void setUserName(String string) {
        this.getName = string;
    }
}

