/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web;

import com.jinfonet.web.NLSProvider;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.util.Locale;
import jet.JRException;

public final class WRException
extends RuntimeException {
    private int ENGLISH;
    private String[] SEDU;
    private static final long serialVersionUID = 2546699030164028572L;

    public WRException(int n, String ... stringArray) {
        this(n, (Throwable)null, stringArray);
    }

    public WRException(int n, Throwable throwable, String ... stringArray) {
        super(stringArray != null && stringArray.length > 0 ? stringArray[0] : null, throwable);
        this.ENGLISH(n);
        this.SEDU = stringArray;
    }

    public int getErrorCode() {
        return this.ENGLISH;
    }

    public int getRawErrorCode() {
        return this.ENGLISH & 0xFFFFFF;
    }

    private void ENGLISH(int n) {
        if ((n & Integer.MIN_VALUE) != 0) {
            this.ENGLISH = n;
            return;
        }
        StackTraceElement stackTraceElement = this.getStackTrace()[0];
        String string = stackTraceElement.getClassName();
        this.ENGLISH = string.indexOf("service") != -1 ? Integer.MIN_VALUE | n : (string.indexOf("client") != -1 ? 0xC0000000 | n : 0xA0000000 | n);
    }

    public String[] getErrorParams() {
        return this.SEDU;
    }

    public static String intToErrString(int n) {
        String string = StringUtil.intToHexString((int)n);
        String string2 = "000" + Integer.toString(n & 0xFFFF);
        string2 = string2.substring(string2.length() - 4);
        return string.substring(0, 4).toUpperCase(Locale.ENGLISH) + string2;
    }

    public static int strToErrInt(String string) {
        int n = Integer.parseInt(string.substring(0, 4), 16);
        int n2 = Integer.parseInt(string.substring(4));
        return (n <<= 16) | n2;
    }

    public String getMessage(NLSProvider nLSProvider) {
        String string = null;
        Throwable throwable = this.getCause();
        if (throwable == null) {
            if (this.SEDU != null && this.SEDU.length > 0) {
                string = this.SEDU[0];
            }
            return string;
        }
        if ((throwable = this.SEDU(throwable)).getClass().getName().startsWith("java.")) {
            StackTraceElement stackTraceElement = throwable.getStackTrace()[0];
            StringBuilder stringBuilder = new StringBuilder(throwable.getClass().getSimpleName());
            string = throwable.getMessage();
            if (string != null && !string.trim().isEmpty()) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            stringBuilder.append(" at ");
            stringBuilder.append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber());
            string = stringBuilder.toString();
        } else if (throwable instanceof JRException) {
            JRException jRException = (JRException)throwable;
            Locale locale = nLSProvider.getLocale();
            string = jRException.getLocaleMessage(locale);
        } else {
            string = throwable.getMessage();
        }
        return string;
    }

    public JSONObject toJSONObject(JSONObject jSONObject, NLSProvider nLSProvider) throws JSONException {
        jSONObject = jSONObject == null ? new JSONObject() : jSONObject;
        int n = this.getErrorCode();
        jSONObject.put("err", (Object)WRException.intToErrString(n));
        String string = this.getNLSMessage(nLSProvider, n, this.getErrorParams());
        if (string == null || string.trim().isEmpty()) {
            string = this.getMessage(nLSProvider);
            String string2 = string = string == null ? super.getMessage() : string;
        }
        if (string != null) {
            jSONObject.put("msg", (Object)string);
        }
        return jSONObject;
    }

    private Throwable SEDU(Throwable throwable) {
        Throwable throwable2 = throwable;
        for (Throwable throwable3 = throwable.getCause(); throwable3 != null; throwable3 = throwable3.getCause()) {
            throwable2 = throwable3;
            if (!(throwable2 instanceof JRException) || throwable3 instanceof JRException) continue;
            break;
        }
        return throwable2;
    }

    public String getNLSMessage(NLSProvider nLSProvider, int n, String[] stringArray) {
        String string = "MSG_" + WRException.intToErrString(n);
        String string2 = nLSProvider != null ? nLSProvider.getNLSValue(string, stringArray) : string;
        return string2 == null || string2.startsWith("??") ? null : string2;
    }
}

