/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.beans;

import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.io.Serializable;

public final class FontDef
implements JSONObject.JSONObjectable,
Serializable {
    public static final transient int BOLD = 1;
    public static final transient int ITALIC = 2;
    private String fontName = "Default";
    private int fontStyle = 0;
    private int fontSize = 12;
    private int fontColor = -16777216;
    private int strikeout = -1;
    private int underline = -1;
    public static final transient int EMBOSSED = 1;
    public static final transient int ENGRAVED = 2;
    public static final transient int OUTLINED = 3;
    public static final transient int SHADOWED = 4;
    public static final transient int OUTLINED_SHADOWED = 5;
    private int effects = -1;
    private int rotation = -1;
    private int shearing = -1;
    private static final long serialVersionUID = -3395971354824037315L;

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
    }

    public boolean isFontBold() {
        return (this.fontStyle & 1) != 0;
    }

    public void setFontBold(boolean bl) {
        this.fontStyle = bl ? (this.fontStyle |= 1) : (this.fontStyle &= 0xFFFFFFFE);
    }

    public boolean isFontItalic() {
        return (this.fontStyle & 2) != 0;
    }

    public void setFontItalic(boolean bl) {
        this.fontStyle = bl ? (this.fontStyle |= 2) : (this.fontStyle &= 0xFFFFFFFD);
    }

    public int getFontStrikeOut() {
        return this.strikeout;
    }

    public boolean isFontStrikeOut() {
        return this.strikeout > 0;
    }

    public void setFontStrikeOut(boolean bl) {
        this.strikeout = bl ? 1 : 0;
    }

    public void setFontStrikeOut(int n) {
        this.strikeout = n;
    }

    public int getFontUnderLine() {
        return this.underline;
    }

    public boolean isFontUnderLine() {
        return this.underline > 0;
    }

    public void setFontUnderLine(boolean bl) {
        this.underline = bl ? 4 : 0;
    }

    public void setFontUnderLine(int n) {
        this.underline = n;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int n) {
        this.fontColor = n;
    }

    public int getFontRotation() {
        return this.rotation;
    }

    public void setFontRotation(int n) {
        this.rotation = n;
    }

    public int getFontShearing() {
        return this.shearing;
    }

    public void setFontShearing(int n) {
        this.shearing = n;
    }

    public int getFontEffects() {
        return this.effects;
    }

    public void setFontEffectes(int n) {
        this.effects = n;
    }

    public boolean isFontEmbossed() {
        return this.effects == 1;
    }

    public void setFontEmbossed(boolean bl) {
        this.effects = bl ? 1 : 0;
    }

    public boolean isFontEngraved() {
        return this.effects == 2;
    }

    public void setFontEngraved(boolean bl) {
        this.effects = bl ? 2 : 0;
    }

    public boolean isFontOutlined() {
        return this.effects == 3 || this.effects == 5;
    }

    public boolean isFontShadowed() {
        return this.effects == 4 || this.effects == 5;
    }

    public void setFontOutlined(boolean bl) {
        this.effects = bl ? (this.isFontShadowed() ? 5 : 3) : (this.effects == 5 ? 4 : 0);
    }

    public void setFontShadowed(boolean bl) {
        this.effects = bl ? (this.isFontOutlined() ? 5 : 4) : (this.effects == 5 ? 3 : 0);
    }

    public String toString() {
        try {
            return this.toJSONObject().toString();
        }
        catch (Exception exception) {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.fontName);
        jSONObject.put("style", (Object)this.fontStyle);
        jSONObject.put("size", (Object)this.fontSize);
        jSONObject.put("color", (Object)StringUtil.formatColor((int)this.fontColor));
        if (this.strikeout != -1) {
            jSONObject.put("strikeout", (Object)this.strikeout);
        }
        if (this.underline != -1) {
            jSONObject.put("underline", (Object)this.underline);
        }
        if (this.effects != -1) {
            jSONObject.put("effects", (Object)this.effects);
        }
        if (this.rotation != -1) {
            jSONObject.put("rotation", (Object)this.rotation);
        }
        if (this.shearing != -1) {
            jSONObject.put("shearing", (Object)this.shearing);
        }
        return jSONObject;
    }

    public static FontDef parse(JSONObject jSONObject) {
        FontDef fontDef = null;
        if (jSONObject != null) {
            fontDef = new FontDef();
            fontDef.setFontName(jSONObject.optString("name", null));
            fontDef.setFontStyle(jSONObject.optInt("style"));
            fontDef.setFontSize(jSONObject.optInt("size"));
            fontDef.setFontColor(StringUtil.parseColor((String)jSONObject.optString("color")));
            fontDef.setFontStrikeOut(jSONObject.optInt("strikeout", -1));
            fontDef.setFontUnderLine(jSONObject.optInt("underline", -1));
            fontDef.setFontEffectes(jSONObject.optInt("effects", -1));
            fontDef.setFontRotation(jSONObject.optInt("rotation", -1));
            fontDef.setFontShearing(jSONObject.optInt("shearing", -1));
        }
        return fontDef;
    }
}

