/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.client;

import com.jinfonet.web.ActionResult;
import com.jinfonet.web.NLSProvider;
import com.jinfonet.web.Result;
import com.jinfonet.web.ResultImpl;
import com.jinfonet.web.ResultObject;
import com.jinfonet.web.WRException;
import com.jinfonet.web.client.ClientContext;
import com.jinfonet.web.client.Logger;
import com.jinfonet.web.util.CharArray;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import server.servlet.http.HttpResponse;

public final class Message
implements Serializable,
JSONObject.JSONObjectable {
    private Locale locale;
    private Result result;
    private static final long serialVersionUID = 864120631035918444L;

    public Message(Result result, Locale locale) {
        if (result == null) {
            throw new IllegalArgumentException("The result can not be null.");
        }
        this.locale = locale;
        this.result = result;
    }

    public Message(ActionResult actionResult, Locale locale) {
        this((Result)actionResult, locale);
    }

    public Message(WRException wRException, Locale locale) {
        this(new ResultImpl(wRException), locale);
    }

    public Message(ResultObject resultObject, Locale locale) {
        this(new ResultImpl(), locale);
        if (resultObject != null) {
            ((ResultImpl)this.result).setResultObject(resultObject);
        }
    }

    public Result getResult() {
        return this.result;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString();
        }
        catch (JSONException jSONException) {
            return "{\"err\":\"C0030001\", \"msg\":\"Message format exception.\"}";
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        Object object;
        JSONObject jSONObject = new JSONObject();
        int n = this.result.getErrorCode();
        jSONObject.put("err", (Object)WRException.intToErrString(n));
        WRException wRException = this.result.getException();
        if (wRException != null) {
            wRException.toJSONObject(jSONObject, ClientContext.getInstance().getNLSProvider(this.locale));
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        ResultObject resultObject = this.result.getResultObject();
        if (this.result instanceof ActionResult) {
            object = (ActionResult)this.result;
            string = object.getPID();
            string2 = object.getAppID();
            string3 = object.getProductID();
            string4 = object.getRptsetID();
            string5 = object.getReportID();
            string6 = object.getModule();
            string7 = object.getModule();
            string8 = object.getTicket();
        }
        if (wRException != null) {
            object = new StringWriter();
            jSONObject.put("cause", (Object)((StringWriter)object).toString());
        }
        if (string != null) {
            jSONObject.put("j$vm_pid", (Object)string);
            jSONObject.put("pid", (Object)string);
        }
        if (string2 != null) {
            jSONObject.put("j$vm_app", (Object)string2);
        }
        if (string3 != null) {
            jSONObject.put("jrd_product", string3);
        }
        if (string4 != null) {
            jSONObject.put("jrd_rptsetid", string4);
        }
        if (string5 != null) {
            jSONObject.put("jrd_reportid", string5);
        }
        if (string6 != null) {
            jSONObject.put("module", string6);
        }
        if (string7 != null) {
            jSONObject.put("action", string7);
        }
        if (string8 != null) {
            jSONObject.put("ticket", string8);
        }
        if (resultObject != null) {
            jSONObject.put("obj", resultObject.toJSONObject());
        }
        return jSONObject;
    }

    public static String getNLSMessage(int n, String[] stringArray, Locale locale) {
        NLSProvider nLSProvider = ClientContext.getInstance().getNLSProvider(locale);
        String string = "MSG_" + WRException.intToErrString(n);
        String string2 = nLSProvider != null ? nLSProvider.getNLSValue(string, stringArray) : string;
        return string2 == null || string2.startsWith("??") ? null : string2;
    }

    public static int writeErrorMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WRException wRException, Locale locale) {
        return Message.writeMessage(httpServletRequest, httpServletResponse, new Message(wRException, locale));
    }

    public static int writeResultMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Result result, Locale locale) {
        return Message.writeMessage(httpServletRequest, httpServletResponse, new Message(result, locale));
    }

    public static int writeResultMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionResult actionResult, Locale locale) {
        return Message.writeMessage(httpServletRequest, httpServletResponse, new Message(actionResult, locale));
    }

    public static int writeMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Message message) {
        return Message.writeMessage(httpServletRequest, httpServletResponse, message.toJSONObject().toCharArray(), message.getResult().getContentType());
    }

    public static int writeMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String ... stringArray) {
        return Message.writeMessage(httpServletRequest, httpServletResponse, new CharArray(string), stringArray);
    }

    public static int writeMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CharArray charArray, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            httpServletResponse.setContentType(stringArray[0]);
        } else {
            httpServletResponse.setContentType("text/html; charset=utf-8");
        }
        return Message.writeResponse(httpServletRequest, httpServletResponse, charArray);
    }

    public static int writeResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        return Message.writeResponse(httpServletRequest, httpServletResponse, new CharArray(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CharArray charArray) {
        int n = 0;
        int n2 = 0;
        httpServletResponse.setHeader("Access-Control-Allow-Headers", "*");
        httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
        String string = httpServletRequest.getHeader("Accept-Encoding");
        String string2 = httpServletRequest.getHeader("disableGzip");
        boolean bl = string != null && string.indexOf("gzip") != -1;
        bl &= string2 == null || string2.equalsIgnoreCase("false");
        Object object = null;
        try {
            if (bl) {
                httpServletResponse.setHeader("Content-Encoding", "gzip");
                object = new GZIPOutputStream((OutputStream)httpServletResponse.getOutputStream());
            } else {
                object = httpServletResponse.getOutputStream();
            }
            int n3 = charArray.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = charArray.get();
                if (n4 <= 127) {
                    ((OutputStream)object).write(n4);
                    ++n2;
                    continue;
                }
                if (n4 <= 2047) {
                    ((OutputStream)object).write(n4 >> 6 & 0x1F | 0xC0);
                    ((OutputStream)object).write(n4 & 0x3F | 0x80);
                    n2 += 2;
                    continue;
                }
                ((OutputStream)object).write(n4 >> 12 | 0xE0);
                ((OutputStream)object).write(n4 >> 6 & 0x3F | 0x80);
                ((OutputStream)object).write(n4 & 0x3F | 0x80);
                n2 += 3;
            }
            if (object instanceof GZIPOutputStream) {
                ((GZIPOutputStream)object).finish();
                Logger.logT("GZIPOutputStream write bytes: " + n2);
            }
        }
        catch (Exception exception) {
            n = exception instanceof SocketException || exception.getCause() instanceof SocketException ? 131073 : 0xFF0001;
            Logger.logE(new WRException(n, (Throwable)exception, new String[0]));
        }
        finally {
            try {
                ((OutputStream)object).close();
            }
            catch (Exception exception) {}
            return n2;
        }
    }

    public static void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (httpServletResponse instanceof HttpResponse) {
            try {
                httpServletResponse.sendRedirect(string);
            }
            catch (IOException iOException) {
                Logger.logE(new WRException(131073, (Throwable)iOException, new String[0]));
            }
        } else {
            httpServletResponse.addHeader("Location", string);
            httpServletResponse.setStatus(302);
        }
    }
}

