/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.BidiHashMap;
import com.jinfonet.web.modules.pagereport.service.exporter.Component;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.util.css.CssParser;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import jet.datastream.DSTemplatible;
import jet.report.JRObjectTemplate;
import jet.report.JetRptObject;

public class ExporterExt {
    private RuntimeInfo SEDU;

    public ExporterExt(RuntimeInfo runtimeInfo) {
        this.SEDU = runtimeInfo;
        this.SEDU.put("ext$", this);
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.SEDU;
    }

    public byte[] export() throws WRException {
        Component component;
        RenderBuffer renderBuffer = new RenderBuffer();
        if (this.SEDU.getDSPage() != null && (component = ExportHelper.createComponent(this.SEDU.getDSPage(), this.SEDU)) != null) {
            component.render(renderBuffer);
        }
        try {
            return renderBuffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WRException(2, (Throwable)unsupportedEncodingException, new String[0]);
        }
    }

    public void generateCSS(RenderBuffer renderBuffer) throws WRException {
        Object object;
        Map map = ((BidiHashMap)this.SEDU.get("tmpMap")).getKOMap();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = map.keySet().iterator();
        try {
            block5: while (iterator.hasNext()) {
                DSTemplatible dSTemplatible = null;
                object = (String)iterator.next();
                JetRptObject jetRptObject = (JetRptObject)map.get(object);
                if (jetRptObject instanceof DSTemplatible) {
                    dSTemplatible = (DSTemplatible)jetRptObject;
                } else if (jetRptObject instanceof JRObjectTemplate) {
                    dSTemplatible = (JRObjectTemplate)jetRptObject;
                }
                if (dSTemplatible == null) continue;
                int n = dSTemplatible.getObjectType();
                switch (n) {
                    case 42: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 16385: {
                        continue block5;
                    }
                }
                stringBuilder.append(ExportHelper.getClazz((String)object, dSTemplatible, this.SEDU));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuilder.append(".pageStyle{display:block;}");
        object = new CssParser(stringBuilder);
        ((CssParser)object).parse();
        renderBuffer.append(((CssParser)object).toCSSString());
    }

    public void destroy() {
        this.SEDU.destroy();
    }
}

