/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.report.table.JetRptNewTable;

public final class CellWrapper {
    DSTableRow row = null;
    DSTableCell cell = null;
    int rowSpan;
    int colSpan;
    int rowRange;
    int colRange;
    boolean rInvisible;
    boolean cInvisible;
    boolean bLftInvisible;
    boolean bRhtInvisible;

    public CellWrapper(DSTableCell dSTableCell) {
        this.row = (DSTableRow)dSTableCell.getParent();
        this.cell = dSTableCell;
        this.rowSpan = dSTableCell.getRowSpan();
        this.colSpan = dSTableCell.getColSpan();
        this.rowRange = dSTableCell.getGridY() + this.rowSpan;
        this.colRange = dSTableCell.getGridX() + this.colSpan;
        this.rInvisible = this.row.getTemplate().getInvisible((JRObjectResult)this.row);
        DSTableObject dSTableObject = (DSTableObject)this.row.getParent();
        this.cInvisible = ((JetRptNewTable)dSTableObject.getTemplate()).getTableColumn(dSTableCell.getGridX()).getInvisible().booleanValue();
    }

    public int getGridX() {
        return this.cell.getGridX();
    }

    public int getGridY() {
        return this.cell.getGridY();
    }

    public boolean hasContent() {
        return this.cell.getChildren().size() > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.cell.getGridY()).append("-").append(this.cell.getGridX());
        stringBuilder.append(",");
        stringBuilder.append(this.rowSpan).append("-").append(this.colSpan);
        stringBuilder.append(",");
        stringBuilder.append(this.rInvisible ? 1 : 0).append("-").append(this.cInvisible ? 1 : 0);
        stringBuilder.append(",");
        stringBuilder.append(this.cell.getWidth() + "-" + this.cell.getHeight());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

