/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.modules.pagereport.service.exporter.components.ComponentBase;
import com.jinfonet.web.modules.pagereport.service.exporter.components.VOTable;
import guitools.PainterConstants;
import java.awt.Color;
import java.awt.Rectangle;
import jet.datastream.DSContainer;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;

public class Container
extends ComponentBase {
    public Container(JRObjectResult jRObjectResult, RuntimeInfo runtimeInfo) {
        super(jRObjectResult, runtimeInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
        super.beforeRender();
        try {
            DSContainer dSContainer = (DSContainer)this.dsObj;
            int n = dSContainer.getObjectType();
            switch (n) {
                case 16385: {
                    new VOTable((JRObjectResult)this.dsObj, this.ctx).render(renderBuffer);
                    return;
                }
                default: {
                    renderBuffer.append(this.DEFAULT_SHADOW_WIDTH((JRVisiableResult)dSContainer));
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new WRException(589825, (Throwable)exception, this.getClass().getSimpleName() + "@" + ((JRObjectResult)this.dsObj).getTemplate().getInstName());
        }
        finally {
            super.afterRender();
        }
    }

    private String DEFAULT_SHADOW_WIDTH(JRVisiableResult jRVisiableResult) throws Exception {
        Color color = jRVisiableResult.getTemplate().getBackground((JRObjectResult)jRVisiableResult);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (color != null) {
            int n = this.unit2pixel(ExportHelper.getX(jRVisiableResult, this.ctx));
            int n2 = this.unit2pixel(ExportHelper.getY(jRVisiableResult, this.ctx));
            int n3 = jRVisiableResult.getWidth();
            int n4 = jRVisiableResult.getHeight();
            if (jRVisiableResult.getTemplate().getShadow((JRObjectResult)jRVisiableResult)) {
                n3 -= PainterConstants.DEFAULT_SHADOW_WIDTH;
                n4 -= PainterConstants.DEFAULT_SHADOW_WIDTH;
            }
            n3 = this.unit2pixel(jRVisiableResult.getWidth());
            n4 = this.unit2pixel(jRVisiableResult.getHeight());
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            stringBuffer.append(new VOTable((JRObjectResult)this.dsObj, this.ctx).drawRectangle(rectangle, null, color));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getObjcType() {
        return null;
    }
}

