/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.modules.pagereport.service.exporter.components.CellWrapper;
import com.jinfonet.web.modules.pagereport.service.exporter.components.ComponentBase;
import com.jinfonet.web.modules.pagereport.service.exporter.components.Matrix;
import com.jinfonet.web.modules.pagereport.service.exporter.components.Table;
import java.util.List;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.report.JRObjectTemplate;
import jet.util.Propertiable;

public class HorizontalTable
extends ComponentBase {
    public HorizontalTable(JRObjectResult jRObjectResult, RuntimeInfo runtimeInfo) {
        super(jRObjectResult, runtimeInfo);
    }

    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
        super.beforeRender();
        try {
            String string;
            DSTableObject dSTableObject = (DSTableObject)this.dsObj;
            DSTemplatible dSTemplatible = dSTableObject.getTemplate();
            this.ctx.put("isHorizontal", true);
            int n = this.geom.getX();
            int n2 = this.geom.getY();
            int n3 = this.geom.getW();
            int n4 = this.geom.getH();
            RenderBuffer renderBuffer2 = new RenderBuffer(1024);
            renderBuffer2.append(ExportHelper.getStyle((JRObjectResult)dSTableObject, this.ctx));
            renderBuffer2.appendC("z-index", this.getZIndex());
            renderBuffer2.appendC("overflow", "visible");
            renderBuffer2.appendR(n, n2, n3, n4, new String[0]);
            renderBuffer.append("<div").appendE("inst_name", super.getCompName());
            renderBuffer.appendE("componentType", super.getCompType());
            renderBuffer.appendE("dsid", super.getDSID());
            renderBuffer.appendE("class", super.getCssName());
            renderBuffer.appendE("objtype", this.getObjcType());
            renderBuffer.appendE("style", renderBuffer2.toString());
            if (this.ctx.isAdHoc() && !this.ctx.isRsd()) {
                renderBuffer.appendE("RSZ", "TRUE").appendE("RSZX", "TRUE").appendE("RSZY", "TRUE").appendE("RSZB", "TRUE");
                renderBuffer.appendE("level", "jro_componentDiv");
                if (((JRObjectTemplate)dSTemplatible).position.intValue() == 2) {
                    renderBuffer.appendE("CANMOVE", "TRUE");
                }
                string = this.ctx.buildConvertInfo((JRObjectResult)dSTableObject, dSTemplatible.getInstName());
                renderBuffer.append(string);
                renderBuffer.appendE("isHorizontal", dSTableObject.isHorizontal());
            }
            string = "";
            Propertiable propertiable = dSTableObject.getPropertyByName("StyleFile");
            string = propertiable != null ? (String)propertiable.getObject() : ((propertiable = dSTableObject.getPropertyByName("StyleName")) == null ? "" : (String)propertiable.getObject());
            renderBuffer.appendE("styleName", ExportHelper.deleteStyleBracket(string));
            renderBuffer.append(">");
            int n5 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-top-width").getObject()).intValue());
            int n6 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-left-width").getObject()).intValue());
            int n7 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-bottom-width").getObject()).intValue());
            int n8 = this.unit2pixel(((Number)dSTableObject.getPropertyByName("border-right-width").getObject()).intValue());
            Matrix matrix = Table.createCellsMatrix(dSTableObject);
            Table.mergeCellsMatrix(matrix);
            matrix.rotate();
            int n9 = matrix.m;
            if (n9 > 0) {
                renderBuffer.append("<table");
                renderBuffer.appendE("cellpadding", 0).appendE("cellspacing", 0);
                renderBuffer.append("style=\"").appendR(0, 0, n3 - n6 - n8, n4 - n5 - n7, new String[0]).append("\">");
                for (int i = 0; i < n9; ++i) {
                    List list = matrix.getRowElements(i);
                    renderBuffer.append("<tr>");
                    int n10 = renderBuffer.length();
                    int n11 = list.size();
                    for (int j = 0; j < n11; ++j) {
                        CellWrapper cellWrapper = (CellWrapper)list.get(j);
                        if (cellWrapper == null) continue;
                        DSTableCell dSTableCell = cellWrapper.cell;
                        this.ctx.put("rowSpan", cellWrapper.colSpan);
                        this.ctx.put("colSpan", cellWrapper.rowSpan);
                        ExportHelper.createComponent(dSTableCell, this.ctx).render(renderBuffer);
                    }
                    if (renderBuffer.length() > n10) {
                        renderBuffer.append("</tr>");
                        continue;
                    }
                    renderBuffer.delete(renderBuffer.length() - 4, renderBuffer.length());
                }
                renderBuffer.append("</table>");
            }
            renderBuffer.append("</div>");
        }
        catch (Exception exception) {
            throw new WRException(589825, (Throwable)exception, this.getClass().getSimpleName() + "@" + ((JRObjectResult)this.dsObj).getTemplate().getInstName());
        }
        finally {
            super.afterRender();
        }
    }

    @Override
    public String getObjcType() {
        return "tableobject";
    }
}

