/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.pagereport.service.exporter.components;

import com.jinfonet.web.WRException;
import com.jinfonet.web.modules.pagereport.service.exporter.ExportHelper;
import com.jinfonet.web.modules.pagereport.service.exporter.RenderBuffer;
import com.jinfonet.web.modules.pagereport.service.exporter.RuntimeInfo;
import com.jinfonet.web.modules.pagereport.service.exporter.components.ComponentBase;
import jet.datastream.DSField;
import jet.datastream.JRObjectResult;
import jet.datastream.render.RenderTextArea;
import jet.report.JRObjectTemplate;
import jet.report.mode.JetRptMode;
import jet.report.mode.common.RptRenderer;

public class TextArea
extends ComponentBase {
    public TextArea(JRObjectResult jRObjectResult, RuntimeInfo runtimeInfo) {
        super(jRObjectResult, runtimeInfo);
    }

    @Override
    public void render(RenderBuffer renderBuffer) throws WRException {
        super.beforeRender();
        try {
            this.initialize(ExportHelper.getTemplatePath(TextArea.class.getName()));
            DSField dSField = (DSField)this.dsObj;
            String string = dSField.getTemplate().getInstName();
            String string2 = (String)dSField.getPropertyByName("Name").getObject();
            RenderTextArea renderTextArea = (RenderTextArea)dSField.getRender();
            int[] nArray = this.ctx.getBorderWidthArray();
            int n = this.unit2pixel(renderTextArea.getX()) - nArray[1];
            int n2 = this.unit2pixel(renderTextArea.getY()) - nArray[0];
            int n3 = this.unit2pixel(renderTextArea.getWidth()) + nArray[1] + nArray[3];
            int n4 = this.unit2pixel(renderTextArea.getHeight()) + nArray[0] + nArray[2];
            int n5 = ((Number)dSField.getPropertyByName("NumberLines").getObject()).intValue();
            int n6 = ((Number)dSField.getPropertyByName("CharactorWidth").getObject()).intValue();
            boolean bl = (Boolean)dSField.getPropertyByName("Disabled").getObject();
            String string3 = (String)dSField.getPropertyByName("rTitle").getObject();
            boolean bl2 = (Boolean)dSField.getPropertyByName("ReadOnly").getObject();
            String string4 = ExportHelper.getStyle((JRObjectResult)dSField, this.ctx);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl3 = this.ctx.buildRenderHeaderTag(stringBuffer, dSField);
            this.setProperty("head", stringBuffer.toString());
            this.setProperty("isPointer", bl3 ? " cursor:pointer;" : "");
            this.setProperty("rect", ExportHelper.wrapRectangle(n, n2, n3, n4));
            this.setProperty("id", string);
            this.setProperty("name", string2 == null ? "" : string2);
            this.setProperty("class", this.ctx.getCssName((JRObjectResult)dSField));
            this.setProperty("isFieldPointer", bl3 ? " cursor:pointer;" : "");
            this.setProperty("style", string4);
            this.setProperty("fieldRect", ExportHelper.wrapRectangle(0, 0, n3, n4));
            this.setProperty("rows", String.valueOf(n5));
            this.setProperty("cols", String.valueOf(n6));
            if (!string3.equals("")) {
                this.setProperty("title", string3);
            } else {
                this.setProperty("title", "");
            }
            if (bl2) {
                this.setProperty("isReadonly", " readonly=\"true\" ");
            } else {
                this.setProperty("isReadonly", "");
            }
            if (bl) {
                this.setProperty("isDisable", "disabled");
            } else {
                this.setProperty("isDisable", "");
            }
            JetRptMode jetRptMode = null;
            if (!this.ctx.isRsd()) {
                jetRptMode = ((JRObjectTemplate)dSField.getTemplate()).getJetRptMode();
            }
            if (jetRptMode != null) {
                RptRenderer rptRenderer = jetRptMode.getCurrentRender();
                String[][] stringArray = this.ctx.buildActionList(rptRenderer, this.ctx.getDSId((JRObjectResult)dSField));
                String string5 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string5 = string5 + ExportHelper.wrapKeyValuePair(stringArray[i][0], stringArray[i][1], "=");
                }
                this.setProperty("actions", string5);
            } else {
                this.viewLogic.getViewLogic("actions").setVisible(false);
            }
            this.setProperty("content", ExportHelper.getRealText(dSField));
            if (bl3) {
                this.setProperty("tail", "</a>");
            } else {
                this.setProperty("tail", "</div>");
            }
            renderBuffer.append(this.toHTMLString());
        }
        catch (Exception exception) {
            throw new WRException(589825, (Throwable)exception, this.getClass().getSimpleName() + "@" + ((JRObjectResult)this.dsObj).getTemplate().getInstName());
        }
        finally {
            super.afterRender();
        }
    }

    @Override
    public String getObjcType() {
        return null;
    }
}

