/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.resource.service.util;

import com.jinfonet.web.UserInfo;
import com.jinfonet.web.WRException;
import com.jinfonet.web.beans.Atom;
import com.jinfonet.web.beans.Expression;
import com.jinfonet.web.beans.FilterControlDef;
import com.jinfonet.web.beans.KVMapDef;
import com.jinfonet.web.beans.LCDef;
import com.jinfonet.web.beans.ResourceDef;
import com.jinfonet.web.beans.SaveAsDef;
import com.jinfonet.web.beans.create.FieldDef;
import com.jinfonet.web.modules.component.service.util.ExpressionKit;
import com.jinfonet.web.modules.component.service.util.ExpressionService;
import com.jinfonet.web.modules.component.service.util.TemplateKit;
import com.jinfonet.web.modules.dashboard.Dashboard;
import com.jinfonet.web.modules.dashboard.Gadget;
import com.jinfonet.web.modules.dashboard.service.util.DashboardPreserver;
import com.jinfonet.web.modules.resource.service.util.CatalogKeyImpl;
import com.jinfonet.web.modules.resource.service.util.ResourceKit;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import com.jinfonet.web.vfs.MemvDir;
import com.jinfonet.web.vfs.VFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.jetc.ReadFailureException;
import jet.lc.LCObject;
import jet.reportset.DataSet;
import jet.reportset.JetRptReportSet;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.jrs.ExResourceManager;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.businesslogic.impl.UpgradedUnifiedBusinessView;
import jet.upgrade.JUpgradeException;
import jet.upgrade.UpgradeBV;
import jet.upgrade.UpgradeExpression;

public class DashboardUpgrade {
    public static final int DASH_VERSION_ESCALADE = 65793;
    public static final int DASH_VERSION_CURRENT = 65793;

    public static Dashboard upgrade(Dashboard dashboard, String string, UserInfo userInfo, int n, boolean bl) {
        int n2 = dashboard.getSerial();
        if (n2 < 65793) {
            MemvDir memvDir = new MemvDir(null, "/catalog/");
            DashboardUpgrade.upgradeEscalade(dashboard, userInfo, memvDir);
            dashboard.setSerial(n);
            if (bl) {
                ResourceDef resourceDef = dashboard.getResourceDef();
                if (resourceDef.isRealPath()) {
                    new DashboardPreserver().saveTo(dashboard, resourceDef.getFullPath());
                } else {
                    String string2 = FileUtil.getFilePath((String)resourceDef.getPath());
                    String string3 = FileUtil.getFileName((String)resourceDef.getPath());
                    SaveAsDef saveAsDef = new SaveAsDef();
                    saveAsDef.setName(string3);
                    saveAsDef.setWriteOver(true);
                    saveAsDef.setTargetFolder(string2);
                    ResourceDef resourceDef2 = ResourceKit.createResourceDef(userInfo, string2, new ExResourceManager[0]);
                    JSONObject jSONObject = new JSONObject();
                    saveAsDef.setAttachedObject(jSONObject);
                    jSONObject.put("tagRes", (Object)resourceDef2);
                    jSONObject.put("dsbId", (Object)string);
                    ResourceKit.saveAs(saveAsDef, userInfo, dashboard);
                }
            }
        }
        return dashboard;
    }

    public static Dashboard upgradeEscalade(Dashboard dashboard, UserInfo userInfo, VFile vFile) {
        long l = System.currentTimeMillis();
        List list = dashboard.getAllGadgets();
        HashMap<String, JetRptReportSet> hashMap = new HashMap<String, JetRptReportSet>();
        HashMap hashMap2 = new HashMap();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        try {
            ArrayList<Gadget> arrayList = new ArrayList<Gadget>();
            for (Gadget gadget : list) {
                LCDef lCDef = gadget.getLCDef();
                if (gadget.isResGadget()) {
                    WRException wRException;
                    KVMapDef kVMapDef = gadget.getActionState();
                    ResourceDef resourceDef = gadget.getLCRes();
                    if (resourceDef.isEmbeddedResource()) {
                        resourceDef = ResourceKit.convertDC2LC(userInfo, resourceDef);
                    }
                    try {
                        resourceDef = ResourceKit.updateResourceDef(userInfo, resourceDef, null);
                    }
                    catch (RptServerException rptServerException) {
                        wRException = new WRException(262164, (Throwable)((Object)rptServerException), new String[0]);
                        Logger.logW(wRException);
                        throw wRException;
                    }
                    ResourceDef resourceDef2 = DashboardUpgrade.SEDU(userInfo, resourceDef);
                    wRException = DashboardUpgrade.add(userInfo, resourceDef2, vFile, hashMap2);
                    JetRptReportSet jetRptReportSet = DashboardUpgrade.append(resourceDef, (JetUUniverse)wRException, userInfo);
                    String string = gadget.getId();
                    hashMap.put(string, jetRptReportSet);
                    hashMap3.put(string, resourceDef2.getPath());
                    DashboardUpgrade.currentTimeMillis(kVMapDef, (JetUUniverse)wRException, jetRptReportSet, userInfo);
                    continue;
                }
                if (!gadget.isDefGadget() || !(lCDef instanceof FilterControlDef)) continue;
                arrayList.add(gadget);
            }
            for (Gadget gadget : arrayList) {
                DashboardUpgrade.createResourceDef(gadget, hashMap2);
            }
        }
        catch (WRException wRException) {
            throw wRException;
        }
        catch (Throwable throwable) {
            throw new WRException(0xFF0001, throwable, new String[0]);
        }
        long l2 = System.currentTimeMillis() - l;
        Logger.logT("upgradeEscalade cost " + l2);
        return dashboard;
    }

    private static ResourceDef SEDU(UserInfo userInfo, ResourceDef resourceDef) {
        ResourceDef resourceDef2;
        try {
            resourceDef2 = ResourceKit.getCatResourceOfReport(userInfo, resourceDef, new ExResourceManager[0]);
        }
        catch (RptServerException rptServerException) {
            WRException wRException = null;
            wRException = rptServerException.getCause() instanceof NoPrivilegeException ? new WRException(262150, (Throwable)((Object)rptServerException), new String[0]) : new WRException(262164, (Throwable)((Object)rptServerException), new String[0]);
            Logger.logW(wRException);
            throw wRException;
        }
        catch (NoPrivilegeException noPrivilegeException) {
            WRException wRException = new WRException(262150, (Throwable)((Object)noPrivilegeException), new String[0]);
            Logger.logW(wRException);
            throw wRException;
        }
        catch (UnknownResource unknownResource) {
            WRException wRException = new WRException(262151, (Throwable)((Object)unknownResource), new String[0]);
            Logger.logW(wRException);
            throw wRException;
        }
        return resourceDef2;
    }

    private static JetUUniverse add(UserInfo userInfo, ResourceDef resourceDef, VFile vFile, Map map) {
        CatalogKeyImpl catalogKeyImpl = new CatalogKeyImpl(resourceDef);
        String string = resourceDef.getRealPath();
        String string2 = resourceDef.getPath();
        JetUUniverse jetUUniverse = (JetUUniverse)map.get(string2);
        if (jetUUniverse != null) {
            return jetUUniverse;
        }
        jetUUniverse = ResourceKit.getCatalog(vFile, catalogKeyImpl, string, userInfo.getUserID());
        map.put(string2, jetUUniverse);
        return jetUUniverse;
    }

    private static JetRptReportSet append(ResourceDef resourceDef, JetUUniverse jetUUniverse, UserInfo userInfo) {
        LCObject lCObject = null;
        String string = resourceDef.getRealPath();
        try {
            lCObject = ResourceKit.loadLCObject(string, jetUUniverse, userInfo.getUserID());
        }
        catch (ReadFailureException readFailureException) {
            WRException wRException = new WRException(327693, (Throwable)readFailureException, new String[0]);
            Logger.logW(wRException);
            throw wRException;
        }
        catch (JUpgradeException jUpgradeException) {
            WRException wRException = new WRException(327693, (Throwable)jUpgradeException, new String[0]);
            Logger.logW(wRException);
            throw wRException;
        }
        JetRptReportSet jetRptReportSet = TemplateKit.convertLCToRptSet(lCObject, userInfo.getUserID());
        return jetRptReportSet;
    }

    private static Expression convertDC2LC(Expression expression, JetUUniverse jetUUniverse, QueryInfo queryInfo, UserInfo userInfo) {
        Expression expression2 = null;
        String string = queryInfo.getDatasourceName();
        String string2 = queryInfo.getBLName();
        IExpression iExpression = ExpressionService.transExpression(expression);
        UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(string, string2);
        if (unifiedBusinessView instanceof UpgradedUnifiedBusinessView) {
            String string3 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessName.get();
            String string4 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldQueryName.get();
            int n = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessType.intValue();
            HashMap hashMap = new HashMap();
            try {
                UpgradeExpression.replaceQN2QDN((JetUUniverse)jetUUniverse, (String)string, (String)string4, (int)3, (String)string3, (IExpression)iExpression, hashMap);
                HashMap<String, UserInfo> hashMap2 = new HashMap<String, UserInfo>();
                hashMap2.put("USER", userInfo);
                hashMap2.put("CAT", (UserInfo)jetUUniverse);
                hashMap2.put("BV", (UserInfo)unifiedBusinessView);
                hashMap2.put("DB", (UserInfo)jetUUniverse.getDatabase(string));
                expression2 = ExpressionKit.transIExpression(iExpression, hashMap2);
            }
            catch (ConditionException conditionException) {
                Logger.logE(new WRException(655362, (Throwable)conditionException, new String[0]));
            }
            catch (DSException dSException) {
                Logger.logE(new WRException(458753, (Throwable)dSException, new String[0]));
            }
        }
        return expression2;
    }

    private static Expression convertLCToRptSet(Expression expression, JetUUniverse jetUUniverse, QueryInfo queryInfo, UserInfo userInfo) {
        Expression expression2 = null;
        if (expression.getExpressions().size() > 0) {
            expression = (Expression)expression.getExpressions().get(0);
            Atom atom = ((Expression)expression.getExpressions().get(0)).getAtom();
            String string = atom.getInstName();
            String string2 = queryInfo.getDatasourceName();
            String string3 = queryInfo.getBLName();
            String string4 = DashboardUpgrade.get(jetUUniverse, string2, string3, string);
            atom.setInstName(string4);
        }
        return expression2;
    }

    private static boolean createResourceDef(Gadget gadget, Map map) {
        long l = System.currentTimeMillis();
        FilterControlDef filterControlDef = (FilterControlDef)gadget.getLCDef();
        List list = filterControlDef.getFieldList();
        for (FieldDef fieldDef : list) {
            String string = fieldDef.getAttributes().getProperty("catName");
            JetUUniverse jetUUniverse = (JetUUniverse)map.get(string);
            Atom atom = fieldDef.getField();
            String string2 = atom.getInstName();
            String string3 = atom.getDataSourceName();
            String string4 = atom.getQueryName();
            String string5 = atom.getBusinessName();
            UnifiedBusinessView unifiedBusinessView = UpgradeBV.getNewBVObject((JetUUniverse)jetUUniverse, (String)string3, (String)string4, (int)3, (String)string5);
            String string6 = unifiedBusinessView.getQualifyDisplayName();
            String string7 = DashboardUpgrade.getActionState(jetUUniverse, unifiedBusinessView, string3, string6, string2);
            atom.setQueryName("");
            atom.setBusinessName(string6);
            atom.setInstName(string7);
        }
        long l2 = System.currentTimeMillis() - l;
        Logger.logT("upgradeFilterControlDef cost " + l2);
        return true;
    }

    private static void currentTimeMillis(KVMapDef kVMapDef, JetUUniverse jetUUniverse, JetRptReportSet jetRptReportSet, UserInfo userInfo) {
        for (String string : kVMapDef.keySet()) {
            int n = string.lastIndexOf(95);
            String string2 = string.substring(n + 1);
            int n2 = -1;
            if (string2.equalsIgnoreCase("FilterAction")) {
                n2 = 1;
            } else {
                if (!string2.equalsIgnoreCase("SortAction")) continue;
                n2 = 2;
            }
            Object object = kVMapDef.get((Object)string);
            KVMapDef kVMapDef2 = null;
            if (object instanceof JSONObject) {
                kVMapDef2 = KVMapDef.parse((JSONObject)((JSONObject)object));
            } else if (object instanceof KVMapDef) {
                kVMapDef2 = (KVMapDef)object;
            } else if (object instanceof String) {
                try {
                    kVMapDef2 = KVMapDef.parse((String)((String)object));
                }
                catch (JSONException jSONException) {
                    throw new WRException(196610, (Throwable)jSONException, new String[0]);
                }
            } else {
                throw new RuntimeException("Unknown parameter object type " + object.getClass().getName());
            }
            String string3 = (String)kVMapDef2.get((Object)"jrd_comp");
            Object object2 = kVMapDef2.get((Object)"jrd_exp");
            if (object2 == null) continue;
            Expression expression = null;
            try {
                expression = Expression.parse((Object)object2);
            }
            catch (JSONException jSONException) {
                throw new WRException(196610, (Throwable)jSONException, new String[0]);
            }
            QueryInfo queryInfo = DashboardUpgrade.equalsIgnoreCase(string3, jetRptReportSet);
            if (n2 == 1) {
                expression = DashboardUpgrade.convertDC2LC(expression, jetUUniverse, queryInfo, userInfo);
            } else if (n2 == 2) {
                expression = DashboardUpgrade.convertLCToRptSet(expression, jetUUniverse, queryInfo, userInfo);
            }
            kVMapDef2.put((Object)"jrd_exp", expression.toJSONObject());
            kVMapDef.put((Object)string, (Object)kVMapDef2.toJSONObject());
        }
    }

    private static QueryInfo equalsIgnoreCase(String string, JetRptReportSet jetRptReportSet) {
        IDataContainer iDataContainer = (IDataContainer)jetRptReportSet.nameToObject(string);
        DataSet dataSet = iDataContainer.getBindedDataSet();
        QueryInfo queryInfo = dataSet.getQueryInfo();
        return queryInfo;
    }

    private static String get(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(string, string2);
        if (unifiedBusinessView instanceof UpgradedUnifiedBusinessView) {
            String string4 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessName.get();
            String string5 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldQueryName.get();
            int n = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessType.intValue();
            String string6 = UpgradeBV.getUbvNodeByQualifyName((JetUUniverse)jetUUniverse, (String)string, (String)string5, (int)n, (String)string4, (String)string3).getQualifyDisplayName();
            return string6;
        }
        return null;
    }

    private static String getActionState(JetUUniverse jetUUniverse, UnifiedBusinessView unifiedBusinessView, String string, String string2, String string3) {
        if (unifiedBusinessView instanceof UpgradedUnifiedBusinessView) {
            String string4 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessName.get();
            String string5 = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldQueryName.get();
            int n = ((UpgradedUnifiedBusinessView)unifiedBusinessView).oldBusinessType.intValue();
            String string6 = UpgradeBV.getUbvNodeByQualifyName((JetUUniverse)jetUUniverse, (String)string, (String)string5, (int)n, (String)string4, (String)string3).getQualifyDisplayName();
            return string6;
        }
        return null;
    }
}

