/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.modules.webreport.service.util;

import com.jinfonet.api.objectmanager.Loader;
import com.jinfonet.web.beans.DoctagDef;
import com.jinfonet.web.beans.KVMapDef;
import com.jinfonet.web.beans.ResourceTypes;
import com.jinfonet.web.beans.create.LabelDef;
import com.jinfonet.web.modules.component.service.util.TemplateKit;
import com.jinfonet.web.modules.resource.service.util.DocumentTag;
import com.jinfonet.web.modules.resource.service.util.ResourceKit;
import com.jinfonet.web.modules.webreport.service.util.EngineInfo2ComponentDef;
import com.jinfonet.web.service.Logger;
import com.jinfonet.web.util.ID;
import com.jinfonet.web.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jet.JException;
import jet.controls.JetObject;
import jet.report.JRObjectTemplate;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPageFooterPanel;
import jet.report.JetRptPageHeaderPanel;
import jet.report.JetRptPagePanel;
import jet.report.JetRptPageStart;
import jet.report.JetRptPicture;
import jet.report.JetRptReportBody;
import jet.report.JetRptTextField;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.util.IntVector;

public class DocumentTagLoader
implements Loader {
    @Override
    public Object load(String string, Map map) throws JException {
        JetRptReportSet jetRptReportSet = null;
        ReadWriteLock readWriteLock = ReadWriteLock.getReadWriteLock(string);
        Logger.logT("B-tryLockForReading: " + string + " with " + readWriteLock);
        readWriteLock.tryLockForReading();
        Logger.logT("A-tryLockForReading: " + string + " with " + readWriteLock);
        try {
            jetRptReportSet = ResourceKit.loadReportSet0(string, (String)map.get("dep.user"), null);
        }
        catch (Exception exception) {
            throw new JException((Throwable)exception);
        }
        finally {
            Logger.logT("B-unlock: " + string + " with " + readWriteLock);
            readWriteLock.unlockRead();
            Logger.logT("A-unlock: " + string + " with " + readWriteLock);
        }
        ID iD = (ID)map.get("rkey");
        DocumentTag documentTag = new DocumentTag(iD.toString(), string);
        documentTag.setJetRptReportSet(jetRptReportSet);
        this.IMAGE(documentTag, jetRptReportSet);
        return documentTag;
    }

    @Override
    public Object clone(Object object) {
        if (!(object instanceof DocumentTag)) {
            return null;
        }
        return ((DocumentTag)object).cloneIt();
    }

    private void IMAGE(DocumentTag documentTag, JetRptReportSet jetRptReportSet) {
        DoctagDef doctagDef2;
        String[] stringArray = jetRptReportSet.getAllReportsName();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[0]);
        KVMapDef kVMapDef = TemplateKit.getReportTemplateName(jetRptReport);
        jetRptReport.templateName.set(kVMapDef.toString());
        String string = (String)kVMapDef.get((Object)"style");
        documentTag.setReportStyle(string);
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        ArrayList arrayList = new ArrayList();
        basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReport, JetRptReportBody.class, arrayList);
        if (arrayList == null) {
            return;
        }
        for (DoctagDef doctagDef2 : arrayList) {
            Vector vector = doctagDef2.getChildren();
            if (vector == null || vector.isEmpty()) continue;
            boolean bl = false;
            JetRptPagePanel jetRptPagePanel = null;
            int n = -1;
            boolean bl2 = false;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                Iterator iterator;
                ArrayList arrayList2;
                JetObject jetObject = (JetObject)vector.get(i);
                Class<?> clazz = jetObject.getClass();
                if (JetRptPageStart.class.equals(clazz)) {
                    bl = true;
                    jetRptPagePanel = ((JetRptPageStart)jetObject).getPagePanel();
                    n = (Integer)jetRptPagePanel.pageUsage.getValue();
                    if (n == 1) {
                        bl2 = true;
                        documentTag.setPageSizeInfo(TemplateKit.buildPageDef(jetRptPagePanel, kVMapDef));
                    }
                    arrayList2 = new ArrayList();
                    basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptPagePanel, JetRptPageHeaderPanel.class, arrayList2);
                    iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        this.JetLabelToLabelDef(documentTag, (JRObjectTemplate)iterator.next(), n);
                    }
                }
                if (JetRptPageEnd.class.equals(clazz)) {
                    arrayList2 = new ArrayList();
                    basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptPagePanel, JetRptPageFooterPanel.class, arrayList2);
                    iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        this.JetLabelToLabelDef(documentTag, (JRObjectTemplate)iterator.next(), n);
                    }
                    bl = false;
                    jetRptPagePanel = null;
                    bl2 = false;
                    continue;
                }
                if (!JetRptTextField.class.equals(clazz) && !JetRptPicture.class.equals(clazz) || bl2 || !bl) continue;
                this.SEDU(documentTag, (JRObjectTemplate)jetObject, n);
            }
        }
        doctagDef2 = documentTag.getDoctagDef();
        if (doctagDef2.getCoverPageElements() != null || doctagDef2.getBackPageElements() != null) {
            documentTag.setMultiPanels(true);
        }
    }

    private void JetLabelToLabelDef(DocumentTag documentTag, JRObjectTemplate jRObjectTemplate, int n) {
        Vector vector = null;
        vector = jRObjectTemplate instanceof JetRptTabular ? this.LABEL((JetRptTabular)jRObjectTemplate) : jRObjectTemplate.getChildren();
        if (vector == null) {
            return;
        }
        for (JetObject jetObject : vector) {
            if (!(jetObject instanceof JRObjectTemplate)) continue;
            this.SEDU(documentTag, (JRObjectTemplate)jetObject, n);
        }
    }

    private Vector LABEL(JetRptTabular jetRptTabular) {
        Vector<JetRptTabularCell> vector = new Vector<JetRptTabularCell>();
        Vector vector2 = jetRptTabular.getTabularTree();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            IntVector intVector = (IntVector)vector2.get(i);
            int n2 = intVector.size();
            for (int j = 0; j < n2; ++j) {
                int n3 = intVector.elementAt(j);
                vector.add(jetRptTabular.getTabularCell(n3));
            }
        }
        return vector;
    }

    private void SEDU(DocumentTag documentTag, JRObjectTemplate jRObjectTemplate, int n) {
        int n2;
        String string;
        Class<?> clazz = jRObjectTemplate.getClass();
        if (JetRptTextField.class.equals(clazz)) {
            string = "Text";
            n2 = ResourceTypes.LABEL.intType();
        } else if (JetRptPicture.class.equals(clazz)) {
            string = "PictureName";
            n2 = ResourceTypes.IMAGE.intType();
        } else {
            this.JetLabelToLabelDef(documentTag, jRObjectTemplate, n);
            return;
        }
        String string2 = jRObjectTemplate.getProperty(string).getValue().toString();
        LabelDef labelDef = new LabelDef(string2);
        labelDef.setResourceType(n2);
        labelDef.setInstName(jRObjectTemplate.getInstName());
        labelDef.setDispName(jRObjectTemplate.getDisplayName());
        if (n2 == ResourceTypes.LABEL.intType()) {
            EngineInfo2ComponentDef.JetLabelToLabelDef(jRObjectTemplate, labelDef);
        }
        switch (n) {
            case 0: {
                documentTag.addCoverPageElement(labelDef);
                break;
            }
            case 1: {
                documentTag.addContentPageElement(labelDef);
                break;
            }
            case 2: {
                documentTag.addBackPageElement(labelDef);
            }
        }
    }
}

