/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

import com.jinfonet.web.Context;
import com.jinfonet.web.beans.ConditionStyle;
import com.jinfonet.web.beans.KVMapDef;
import com.jinfonet.web.beans.WebRptObject;
import com.jinfonet.web.beans.report.TemplatePoolHolder;
import com.jinfonet.web.beans.report.WebTemplate;
import com.jinfonet.web.util.BitFormat;
import com.jinfonet.web.util.BitFormatManager;
import com.jinfonet.web.util.CharFormat;
import com.jinfonet.web.util.CharFormatManager;
import com.jinfonet.web.util.DateTimeFormat;
import com.jinfonet.web.util.DatetimeFormatManager;
import com.jinfonet.web.util.NumberFormat;
import com.jinfonet.web.util.NumberFormatManager;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONObject;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import jet.dataservice.api.adapter.ChartDataModel;
import jet.dataservice.api.adapter.ChartInfo;
import jet.dataservice.api.adapter.CrosstabDataModel;
import jet.dataservice.api.adapter.TableDataModel;
import jet.dataservice.api.adapter.TableInfo;
import jet.dataservice.api.adapter.WDbValue;
import jet.dataservice.api.adapter.WGroupModel;
import jet.dataservice.api.adapter.WMetaData;
import jet.util.TextBreaker;

public class RenderUtil {
    public static final Locale lc;
    public static final TimeZone tz;
    public static final NumberFormatManager nFormatMgr;
    public static final CharFormatManager cFormatMgr;
    public static final DatetimeFormatManager dFormatMgr;
    public static final BitFormatManager bFormatMgr;
    private static HashMap SEDU;

    private static void SEDU() {
        SEDU = new HashMap();
        SEDU.put("Default", "Arial");
        SEDU.put("Dialog", "Arial");
        SEDU.put("SansSerif", "Arial");
        SEDU.put("Serif", "Times New Roman");
        SEDU.put("Helvetica", "sansserif");
        SEDU.put("TimesRoman", "serif");
        SEDU.put("Courier", "Courier New");
        SEDU.put("DialogInput", "Courier New");
        SEDU.put("ZapfDingbats", "WingDings");
        SEDU.put("Verdana-Bold", "Verdana");
        SEDU.put("TimesNewRomanPS-BoldMT", "Times New Roman");
        SEDU.put("BookAntiqua-Bold", "BookAntiqua");
        SEDU.put("Garamond-Bold", "Garamond");
        SEDU.put("Arial-BoldMT", "Arial");
        SEDU.put("ArialMT", "Arial");
        SEDU.put("Arial-Black", "Arial Black");
        SEDU.put("Century", "Century");
    }

    public static int getCharWidth(String string, WebRptObject webRptObject) {
        Font font = RenderUtil.getFont(webRptObject);
        return RenderUtil.getCharWidth(string, font);
    }

    public static int getCharWidth(String string, ConditionStyle conditionStyle) {
        Font font = RenderUtil.getFont(conditionStyle);
        return RenderUtil.getCharWidth(string, font);
    }

    public static Font getFont(ConditionStyle conditionStyle) {
        String string = conditionStyle.getFontFamily();
        int n = conditionStyle.getFontSize();
        int n2 = 0;
        if (conditionStyle.isItalic()) {
            n2 |= 2;
        }
        if (conditionStyle.isBold()) {
            n2 |= 1;
        }
        Font font = new Font(string, n2, n);
        return font;
    }

    public static Font getFont(WebRptObject webRptObject) {
        boolean bl;
        String string = RenderUtil.getStringProperty(webRptObject, "FontFace", new String[0]);
        if (string.equalsIgnoreCase("Default")) {
            string = "Arial";
        }
        int n = Unit.convertUnitToPixel((int)RenderUtil.getIntProperty(webRptObject, "FontSize", new String[0]), (int)Context.getClientResolution());
        int n2 = 0;
        boolean bl2 = RenderUtil.getBoolProperty(webRptObject, "Bold", new String[0]);
        if (bl2) {
            n2 |= 1;
        }
        if (bl = RenderUtil.getBoolProperty(webRptObject, "Italic", new String[0])) {
            n2 |= 2;
        }
        Font font = new Font(string, n2, n);
        return font;
    }

    public static String getFontFamily(String string) {
        String string2 = string;
        if (SEDU.containsKey(string)) {
            string2 = (String)SEDU.get(string);
        }
        return string2;
    }

    public static int Unit2Point(int n) {
        int n2;
        double d = Unit.convertUnitToInch((int)n);
        int n3 = (int)(d *= 72.0);
        return n3 < (n2 = (int)(d + 0.5)) ? n2 : n3;
    }

    public static int Point2Unit(int n) {
        double d = (double)n / 72.0;
        int n2 = Unit.convertInchToUnit((double)d);
        return n2;
    }

    public static int getCharWidth(String string, Font font) {
        if (string == null) {
            return 0;
        }
        return TextBreaker.charsWidth((String)string, (Font)font);
    }

    public static int getCharHeight(Font font) {
        return RenderUtil.getCharHeight(null, font);
    }

    public static int getCharHeight(String string, Font font) {
        if (string == null) {
            return 0;
        }
        return Math.round(TextBreaker.charsHeight((String)string, (Font)font, (boolean)false));
    }

    public static int getCharHeight(String string, Font font, int n) {
        int n2 = RenderUtil.getCharHeight(string, font);
        TextBreaker textBreaker = new TextBreaker(string, font, n);
        Vector vector = textBreaker.process();
        return n2 * vector.size();
    }

    public static int getCharHeight(String string, WebRptObject webRptObject, int n) {
        Font font = RenderUtil.getFont(webRptObject);
        return RenderUtil.getCharHeight(string, font, n);
    }

    public static String getStringProperty(WebRptObject webRptObject, String string, String ... stringArray) {
        String string2 = null;
        String string3 = "v";
        JSONObject jSONObject = (JSONObject)webRptObject.getPropertyByName(string);
        if (jSONObject != null) {
            if (stringArray != null && stringArray.length > 0) {
                string3 = stringArray[0];
            }
            return jSONObject.optString(string3);
        }
        return string2;
    }

    public static boolean getBoolProperty(WebRptObject webRptObject, String string, String ... stringArray) {
        String string2 = "v";
        JSONObject jSONObject = (JSONObject)webRptObject.getPropertyByName(string);
        if (jSONObject != null) {
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            return jSONObject.optBoolean(string2);
        }
        return false;
    }

    public static int getIntProperty(WebRptObject webRptObject, String string, String ... stringArray) {
        int n = -1;
        String string2 = "v";
        JSONObject jSONObject = (JSONObject)webRptObject.getPropertyByName(string);
        if (jSONObject != null) {
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            return jSONObject.optInt(string2, -1);
        }
        return n;
    }

    public static float getFloatProperty(WebRptObject webRptObject, String string, String ... stringArray) {
        boolean bl = false;
        String string2 = "v";
        JSONObject jSONObject = (JSONObject)webRptObject.getPropertyByName(string);
        if (jSONObject != null) {
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            return jSONObject.optFloat(string2);
        }
        return (float)bl;
    }

    public static int getPaddingWidth(WebRptObject webRptObject) {
        int n = 0;
        n += RenderUtil.getIntProperty(webRptObject, "padding-left", new String[0]);
        return Unit.convertUnitToPixel((int)(n += RenderUtil.getIntProperty(webRptObject, "padding-right", new String[0])), (int)Context.getClientResolution());
    }

    public static int getPaddingHeight(WebRptObject webRptObject) {
        int n = 0;
        n += RenderUtil.getIntProperty(webRptObject, "padding-top", new String[0]);
        return Unit.convertUnitToPixel((int)(n += RenderUtil.getIntProperty(webRptObject, "padding-bottom", new String[0])), (int)Context.getClientResolution());
    }

    public static int getBorderWidth(WebRptObject webRptObject) {
        String string;
        int n = 0;
        String string2 = RenderUtil.getStringProperty(webRptObject, "LeftLine", new String[0]);
        if (string2 != null && !string2.equals("None")) {
            n += RenderUtil.getIntProperty(webRptObject, "BorderWidth", new String[0]);
        }
        if ((string = RenderUtil.getStringProperty(webRptObject, "RightLine", new String[0])) != null && !string.equals("None")) {
            n += RenderUtil.getIntProperty(webRptObject, "BorderWidth", new String[0]);
        }
        return Unit.convertUnitToPixel((int)n, (int)Context.getClientResolution());
    }

    public static int getBorderHeight(WebRptObject webRptObject) {
        String string;
        int n = 0;
        String string2 = RenderUtil.getStringProperty(webRptObject, "TopLine", new String[0]);
        if (string2 != null && !string2.equals("None")) {
            n += RenderUtil.getIntProperty(webRptObject, "BorderWidth", new String[0]);
        }
        if ((string = RenderUtil.getStringProperty(webRptObject, "BottomLine", new String[0])) != null && !string.equals("None")) {
            n += RenderUtil.getIntProperty(webRptObject, "BorderWidth", new String[0]);
        }
        return Unit.convertUnitToPixel((int)n, (int)Context.getClientResolution());
    }

    public static JSONObject createStyle(WebRptObject webRptObject) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("className", (Object)"");
        return jSONObject;
    }

    public static String getColor(String string) {
        if (string != null && !string.isEmpty() && !string.equalsIgnoreCase("transparent")) {
            return "#" + string.substring(2);
        }
        return string;
    }

    public static String getConditonFormatBorder(int n) {
        switch (n) {
            case 1: {
                return "Solid";
            }
            case 2: {
                return "Dashed";
            }
            case 3: {
                return "Dotted";
            }
            case 4: {
                return "dotted";
            }
            case 5: {
                return "Double";
            }
        }
        return "None";
    }

    public static String value2UnFormattedlString(WDbValue wDbValue, int n) {
        if (wDbValue == null) {
            return null;
        }
        if (wDbValue.isNull()) {
            return null;
        }
        if (wDbValue.isArray()) {
            WDbValue[] wDbValueArray = wDbValue.getArray();
            int n2 = wDbValueArray.length;
            String[] stringArray = new String[n2];
            int n3 = wDbValue.getArrayObjectType();
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = RenderUtil.value2UnFormattedlString(wDbValueArray[i], n3);
            }
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n2; ++i) {
                jSONArray.put((Object)stringArray[i]);
            }
            return jSONArray.toString();
        }
        if (n != 12 && n != 1 && n != -7 && wDbValue.getString() != null && wDbValue.getString().trim().length() > 0) {
            return wDbValue.getString();
        }
        String string = null;
        switch (n) {
            case -5: {
                string = String.valueOf(wDbValue.getLong());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = String.valueOf(wDbValue.getInt());
                break;
            }
            case 2: 
            case 3: {
                string = String.valueOf(wDbValue.getBigDecimal());
                break;
            }
            case 6: 
            case 8: {
                string = String.valueOf(wDbValue.getDouble());
                break;
            }
            case 7: {
                string = String.valueOf(wDbValue.getFloat());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                string = wDbValue.getString();
                break;
            }
            case 91: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string = dateTimeFormat.format(wDbValue.getDate());
                break;
            }
            case 92: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string = dateTimeFormat.format(wDbValue.getTime());
                break;
            }
            case 93: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string = dateTimeFormat.format(wDbValue.getTimestamp());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            case -7: {
                string = wDbValue.getString();
            }
        }
        return string;
    }

    public static String value2FormattedString(WDbValue wDbValue, int n, String string) {
        if (wDbValue == null) {
            return "";
        }
        if (wDbValue.isNull()) {
            return "";
        }
        if (wDbValue.isArray()) {
            WDbValue[] wDbValueArray = wDbValue.getArray();
            int n2 = wDbValueArray.length;
            String[] stringArray = new String[n2];
            int n3 = wDbValue.getArrayObjectType();
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = RenderUtil.value2FormattedString(wDbValueArray[i], n3, string);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                if (i == n2 - 1) {
                    stringBuilder.append(stringArray[i]);
                    continue;
                }
                stringBuilder.append(stringArray[i]).append(" ");
            }
            return stringBuilder.toString();
        }
        if (n != 12 && n != 1 && n != -7 && wDbValue.getString() != null && wDbValue.getString().trim().length() > 0) {
            return wDbValue.getString();
        }
        NumberFormat numberFormat = null;
        CharFormat charFormat = null;
        DateTimeFormat dateTimeFormat = null;
        BitFormat bitFormat = null;
        String string2 = null;
        switch (n) {
            case -5: {
                numberFormat = nFormatMgr.getFormat(lc, string, n);
                string2 = numberFormat.format(wDbValue.getLong());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                numberFormat = nFormatMgr.getFormat(lc, string, n);
                string2 = numberFormat.format(wDbValue.getInt());
                break;
            }
            case 2: 
            case 3: {
                numberFormat = nFormatMgr.getFormat(lc, string, n);
                string2 = numberFormat.format(wDbValue.getBigDecimal());
                break;
            }
            case 6: 
            case 8: {
                if (Double.isNaN(wDbValue.getDouble())) {
                    return "NaN";
                }
                numberFormat = nFormatMgr.getFormat(lc, string, n);
                string2 = numberFormat.format(wDbValue.getDouble());
                break;
            }
            case 7: {
                if (Float.isNaN(wDbValue.getFloat())) {
                    return "NaN";
                }
                numberFormat = nFormatMgr.getFormat(lc, string, n);
                string2 = numberFormat.format(wDbValue.getFloat());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                charFormat = cFormatMgr.getFormat(string);
                string2 = charFormat.format(wDbValue.getString());
                break;
            }
            case 91: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string, n);
                string2 = dateTimeFormat.format(wDbValue.getDate());
                break;
            }
            case 92: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string, n);
                string2 = dateTimeFormat.format(wDbValue.getTime());
                break;
            }
            case 93: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string, n);
                string2 = dateTimeFormat.format(wDbValue.getTimestamp());
                break;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bitFormat = bFormatMgr.getFormat(string);
                string2 = bitFormat.format(wDbValue.getString());
            }
        }
        return string2;
    }

    public static String value2FormattedString(String string, int n, String string2) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        NumberFormat numberFormat = null;
        CharFormat charFormat = null;
        DateTimeFormat dateTimeFormat = null;
        BitFormat bitFormat = null;
        String string3 = null;
        switch (n) {
            case -5: {
                numberFormat = nFormatMgr.getFormat(lc, string2, n);
                string3 = numberFormat.format(Long.parseLong(string));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                numberFormat = nFormatMgr.getFormat(lc, string2, n);
                string3 = numberFormat.format(Integer.parseInt(string));
                break;
            }
            case 2: 
            case 3: {
                numberFormat = nFormatMgr.getFormat(lc, string2, n);
                string3 = numberFormat.format(string);
                break;
            }
            case 6: 
            case 8: {
                if (Double.isNaN(Double.parseDouble(string))) {
                    return "NaN";
                }
                numberFormat = nFormatMgr.getFormat(lc, string2, n);
                string3 = numberFormat.format(Double.parseDouble(string));
                break;
            }
            case 7: {
                if (Float.isNaN(Float.parseFloat(string))) {
                    return "NaN";
                }
                numberFormat = nFormatMgr.getFormat(lc, string2, n);
                string3 = numberFormat.format(Float.parseFloat(string));
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                charFormat = cFormatMgr.getFormat(string2);
                string3 = charFormat.format(string);
                break;
            }
            case 91: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string2, n);
                string3 = dateTimeFormat.format(new Date(Long.parseLong(string)));
                break;
            }
            case 92: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string2, n);
                string3 = dateTimeFormat.format(new Time(Long.parseLong(string)));
                break;
            }
            case 93: {
                dateTimeFormat = dFormatMgr.getFormat(lc, tz, string2, n);
                string3 = dateTimeFormat.format(new Timestamp(Long.parseLong(string)));
                break;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bitFormat = bFormatMgr.getFormat(string2);
                string3 = bitFormat.format(string);
            }
        }
        return string3;
    }

    public static String value2UnFormattedlString(String string, int n) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        String string2 = null;
        switch (n) {
            case 91: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string2 = dateTimeFormat.format(new Date(Long.parseLong(string)));
                break;
            }
            case 92: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string2 = dateTimeFormat.format(new Time(Long.parseLong(string)));
                break;
            }
            case 93: {
                DateTimeFormat dateTimeFormat = dFormatMgr.getFormat(lc, tz, StringUtil.getDefaultFormatPattern((int)n), n);
                string2 = dateTimeFormat.format(new Timestamp(Long.parseLong(string)));
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    public static String groupPath2String(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        return StringUtil.intArrayToString((int[][])nArray);
    }

    public static NLSInfo listDataMappingFiles(WebRptObject webRptObject) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        if (webRptObject instanceof TemplatePoolHolder) {
            object = (TemplatePoolHolder)((Object)webRptObject);
            Map map = object.getTPool();
            if (map != null) {
                Set set = map.keySet();
                WebTemplate webTemplate = null;
                String string = null;
                for (String string2 : set) {
                    webTemplate = (WebTemplate)map.get(string2);
                    string = RenderUtil.getStringProperty(webTemplate, "DataMappingFile", new String[0]);
                    if (string != null && !string.isEmpty() && !arrayList.contains(string)) {
                        arrayList.add(string);
                    }
                    if (bl) continue;
                    String string3 = RenderUtil.getStringProperty(webTemplate, "FontFace", "r");
                    bl = string3 != null;
                }
            } else {
                bl = RenderUtil.addAll(arrayList, webRptObject);
            }
        }
        object = new NLSInfo();
        ((NLSInfo)object).setFiles(arrayList);
        ((NLSInfo)object).setFontChangeBy(bl);
        return object;
    }

    public static KVMapDef getDataMappingFiles(WebRptObject webRptObject) {
        KVMapDef kVMapDef = new KVMapDef();
        if (webRptObject instanceof TemplatePoolHolder) {
            TemplatePoolHolder templatePoolHolder = (TemplatePoolHolder)((Object)webRptObject);
            Map map = templatePoolHolder.getTPool();
            if (map != null) {
                Set set = map.keySet();
                WebRptObject webRptObject2 = null;
                String string = null;
                for (String string2 : set) {
                    webRptObject2 = (WebRptObject)map.get(string2);
                    string = RenderUtil.getStringProperty(webRptObject2, "DataMappingFile", new String[0]);
                    if (string == null || string.isEmpty() || kVMapDef.containsKey((Object)string2)) continue;
                    kVMapDef.put((Object)string2, (Object)string);
                }
            } else {
                RenderUtil.add(kVMapDef, webRptObject);
            }
        } else {
            RenderUtil.add(kVMapDef, webRptObject);
        }
        return kVMapDef;
    }

    private static void add(KVMapDef kVMapDef, WebRptObject webRptObject) {
        List list = webRptObject.getChildren();
        if (list == null || list.size() == 0) {
            String string = webRptObject.getInstanceName();
            String string2 = RenderUtil.getStringProperty(webRptObject, "DataMappingFile", new String[0]);
            if (string2 != null && !string2.isEmpty() && !kVMapDef.containsKey((Object)string)) {
                kVMapDef.put((Object)string, (Object)string2);
            }
        } else {
            for (WebTemplate webTemplate : list) {
                RenderUtil.add(kVMapDef, webTemplate);
            }
        }
    }

    private static boolean addAll(List list, WebRptObject webRptObject) {
        List list2 = webRptObject.getChildren();
        boolean bl = false;
        if (list2 == null || list2.size() == 0) {
            String string = RenderUtil.getStringProperty(webRptObject, "DataMappingFile", new String[0]);
            if (string != null && !string.isEmpty() && !list.contains(string)) {
                list.add(string);
            }
            if (!bl) {
                bl = RenderUtil.getBoolProperty(webRptObject, "FontFace", "r");
            }
        } else {
            for (WebTemplate webTemplate : list2) {
                bl = bl || RenderUtil.addAll(list, webTemplate);
            }
        }
        return bl;
    }

    public static List listChartHeatMapBlColNames(ChartDataModel chartDataModel) {
        WGroupModel wGroupModel;
        ArrayList arrayList = new ArrayList();
        ChartInfo chartInfo = chartDataModel.getChartInfo();
        if (chartInfo != null && (wGroupModel = chartInfo.getHeatMapGroupModel()) != null) {
            RenderUtil.append(wGroupModel, arrayList);
        }
        return arrayList;
    }

    public static List listChartOrgBlColNames(ChartDataModel chartDataModel) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ChartInfo chartInfo = chartDataModel.getChartInfo();
        if (chartInfo != null) {
            Object object;
            WMetaData wMetaData = chartInfo.getOrgGroupMeta();
            if (wMetaData != null && (object = wMetaData.getBLColumnName()) != null) {
                arrayList.add(object);
            }
            if ((object = chartInfo.getOrgRecMetas()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    WMetaData wMetaData2 = (WMetaData)iterator.next();
                    String string = wMetaData2.getBLColumnName();
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    public static List listTableBlColNames(TableDataModel tableDataModel) {
        WGroupModel wGroupModel;
        ArrayList arrayList = new ArrayList();
        if (tableDataModel == null) {
            return arrayList;
        }
        TableInfo tableInfo = tableDataModel.getTableInfo();
        if (tableInfo != null && (wGroupModel = tableInfo.getGroupModel()) != null) {
            RenderUtil.append(wGroupModel, arrayList);
        }
        return arrayList;
    }

    private static void append(WGroupModel wGroupModel, List list) {
        WGroupModel wGroupModel2;
        List list2 = wGroupModel.getDetailMetaDatas();
        RenderUtil.bFormatMgr(list2, list);
        list2 = wGroupModel.getGroupMetaDatas();
        RenderUtil.bFormatMgr(list2, list);
        WMetaData wMetaData = wGroupModel.getGroupMetaData();
        if (wMetaData != null) {
            list.add(wMetaData.getBLColumnName());
        }
        if ((wGroupModel2 = wGroupModel.getNext()) != null) {
            RenderUtil.append(wGroupModel2, list);
        }
    }

    private static void bFormatMgr(List list, List list2) {
        if (list != null && list2 != null) {
            for (WMetaData wMetaData : list) {
                list2.add(wMetaData.getBLColumnName());
            }
        }
    }

    public static List listCrosstabBlColNames(CrosstabDataModel crosstabDataModel) {
        ArrayList arrayList = new ArrayList();
        Map map = crosstabDataModel.getAggMetadatas();
        List list = new ArrayList();
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            if (list2 == null) continue;
            list.addAll(list2);
        }
        RenderUtil.bFormatMgr(list, arrayList);
        list = crosstabDataModel.getColMetadatas();
        RenderUtil.bFormatMgr(list, arrayList);
        list = crosstabDataModel.getRowMetadatas();
        RenderUtil.bFormatMgr(list, arrayList);
        return arrayList;
    }

    static {
        nFormatMgr = new NumberFormatManager();
        cFormatMgr = new CharFormatManager();
        dFormatMgr = new DatetimeFormatManager();
        bFormatMgr = new BitFormatManager();
        lc = Locale.getDefault();
        tz = TimeZone.getDefault();
        RenderUtil.SEDU();
    }

    public static class NLSInfo {
        private List SEDU;
        private boolean I;

        public List getFiles() {
            return this.SEDU;
        }

        public void setFiles(List list) {
            this.SEDU = list;
        }

        public boolean isFontChangeBy() {
            return this.I;
        }

        public void setFontChangeBy(boolean bl) {
            this.I = bl;
        }
    }
}

