/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.concurrent;

import com.jinfonet.web.util.JProperties;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.concurrent.Executor;
import com.jinfonet.web.util.concurrent.Signaler;
import com.jinfonet.web.util.concurrent.Task;
import com.jinfonet.web.util.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ExecutorPool {
    private static ExecutorPool SEDU;
    private static int active;
    private static JProperties add;
    private String append;
    private int available;
    private List availableProcessors;
    private Set cancel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorPool getInstance() {
        Class<ExecutorPool> clazz = ExecutorPool.class;
        synchronized (ExecutorPool.class) {
            if (SEDU == null) {
                SEDU = new ExecutorPool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SEDU;
        }
    }

    private ExecutorPool() {
        int n = Integer.parseInt(add.getProperty("pool.size", "7"), 10);
        this.available = active * ExecutorPool.active(n);
        this.append = add.getProperty("pool.name", "ExecutorPool");
        this.availableProcessors = new ArrayList(this.available);
        this.cancel = new HashSet(this.available);
    }

    public int total() {
        return this.available() + this.active();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        List list = this.availableProcessors;
        synchronized (list) {
            return this.availableProcessors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int active() {
        Set set = this.cancel;
        synchronized (set) {
            return this.cancel.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor(long l) throws TimeoutException {
        List list = this.availableProcessors;
        synchronized (list) {
            if (!this.availableProcessors.isEmpty()) {
                ExecutorImpl executorImpl = (ExecutorImpl)this.availableProcessors.remove(0);
                Set set = this.cancel;
                synchronized (set) {
                    this.cancel.add(executorImpl);
                }
                return executorImpl;
            }
            int n = this.active();
            if (n < this.available) {
                String string = this.append + "." + n;
                ExecutorImpl executorImpl = new ExecutorImpl(string, 0L);
                Set set = this.cancel;
                synchronized (set) {
                    this.cancel.add(executorImpl);
                }
                executorImpl.start();
                while (!executorImpl.isAlive()) {
                }
                return executorImpl;
            }
            if (l < 0L) {
                return null;
            }
            long l2 = System.currentTimeMillis();
            try {
                this.availableProcessors.wait(l);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            if (l4 > l) {
                throw new TimeoutException();
            }
            return this.getExecutor(l - l4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU(Executor executor) {
        Collection collection = this.cancel;
        synchronized (collection) {
            this.cancel.remove(executor);
        }
        collection = this.availableProcessors;
        synchronized (collection) {
            this.availableProcessors.add(executor);
            this.availableProcessors.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Executor executor;
        Collection collection = this.cancel;
        synchronized (collection) {
            Iterator iterator = this.cancel.iterator();
            while (iterator.hasNext()) {
                executor = (Executor)iterator.next();
                executor.cancel();
                iterator.remove();
            }
        }
        collection = this.availableProcessors;
        synchronized (collection) {
            while (!this.availableProcessors.isEmpty()) {
                executor = (Executor)this.availableProcessors.remove(0);
                executor.cancel();
            }
        }
        add.clear();
    }

    private static int active(int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
        }
        return n2;
    }

    static {
        active = Runtime.getRuntime().availableProcessors();
        add = Tools.getProperties((String)"ExecutorPool.properties");
    }

    private class ExecutorImpl
    extends Thread
    implements Executor {
        private long SEDU;
        private Signaler access$000;
        private Signaler append;
        private Task execute;

        public ExecutorImpl(String string) {
            super(string);
            this.SEDU = 0L;
            this.access$000 = new Signaler();
            this.append = new Signaler();
        }

        public ExecutorImpl(String string, long l) {
            this(string);
            this.SEDU = l < 0L ? 0L : l;
        }

        @Override
        public void setTask(Task task) {
            this.execute = task;
        }

        @Override
        public void begin() {
            this.access$000.raise(1);
        }

        @Override
        public void cancel() {
            this.access$000.raise(0);
            this.append.waitSignal(1000L);
            this.interrupt();
        }

        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                int n = this.access$000.waitSignal(this.SEDU);
                switch (n) {
                    case 0: {
                        bl = false;
                        this.access$000();
                        break;
                    }
                    case 1: {
                        this.SEDU();
                        break;
                    }
                    case 2: {
                        this.append();
                        break;
                    }
                }
                Thread.yield();
            }
            this.append.raise(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void SEDU() {
            if (this.execute != null) {
                String string = super.getName();
                super.setName(string + "(" + this.execute.getID() + ")");
                try {
                    this.execute.execute();
                }
                catch (Exception exception) {
                }
                finally {
                    this.execute = null;
                    super.setName(string);
                    ExecutorPool.this.SEDU(this);
                }
            }
        }

        private void access$000() {
        }

        private void append() {
        }
    }
}

