/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util.concurrent;

import com.jinfonet.web.util.Discardable;
import com.jinfonet.web.util.ID;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.concurrent.Executor;
import com.jinfonet.web.util.concurrent.ExecutorPool;
import com.jinfonet.web.util.concurrent.Signaler;
import com.jinfonet.web.util.concurrent.Task;
import com.jinfonet.web.util.concurrent.TaskContext;
import com.jinfonet.web.util.concurrent.TaskListener;
import java.util.LinkedList;

public final class TaskManager
implements Task,
Discardable {
    private static TaskManager J = null;
    private static ID SEDU = Tools.parseID((String)"TaskManager");
    private Executor add = null;
    private LinkedList begin;
    private Signaler cancel;
    private Thread clear;
    private boolean currentThread = true;
    private boolean currentTimeMillis = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getInstance() {
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (J == null) {
                J = new TaskManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return J;
        }
    }

    private static void J() {
        J = null;
    }

    private TaskManager() {
        try {
            this.add = ExecutorPool.getInstance().getExecutor(0L);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.cancel = new Signaler();
        this.begin = new LinkedList();
        this.add.setTask(this);
        this.add.begin();
    }

    @Override
    public ID getID() {
        return SEDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.begin;
        synchronized (linkedList) {
            return this.begin.size() + (this.currentTimeMillis ? 1 : 0);
        }
    }

    public void destroy() {
        this.currentThread = false;
        this.add.cancel();
        this.clear.interrupt();
        while (this.clear.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.begin.clear();
        TaskManager.J();
    }

    public void scheduleTask(Task task, long l) {
        this.scheduleTask(task, l, 0L);
    }

    public void scheduleTask(Task task, long l, long l2) {
        if (task == null) {
            return;
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        TimerTask timerTask = new TimerTask(task);
        timerTask.period = l2;
        timerTask.nextExecutionTime = System.currentTimeMillis() + l;
        this.begin(timerTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(ID iD) {
        LinkedList linkedList = this.begin;
        synchronized (linkedList) {
            int n = this.begin.size();
            for (int i = 0; i < n; ++i) {
                TimerTask timerTask = (TimerTask)this.begin.get(i);
                if (!timerTask.task.getID().equals(iD)) continue;
                this.begin.remove(i);
                if (i != 0) break;
                try {
                    this.clear.interrupt();
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    @Override
    public void execute() {
        this.clear = Thread.currentThread();
        while (this.currentThread) {
            int n;
            long l;
            TimerTask timerTask = this.SEDU();
            if (timerTask == null || (l = timerTask.nextExecutionTime - System.currentTimeMillis()) > 0L && (n = this.cancel(l)) < 0) continue;
            this.clear(this.add());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask SEDU() {
        if (this.begin.size() == 0) {
            this.cancel.waitSignal(0L);
        }
        TimerTask timerTask = null;
        LinkedList linkedList = this.begin;
        synchronized (linkedList) {
            try {
                timerTask = (TimerTask)this.begin.getFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask add() {
        TimerTask timerTask = null;
        LinkedList linkedList = this.begin;
        synchronized (linkedList) {
            try {
                timerTask = (TimerTask)this.begin.remove(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void begin(TimerTask timerTask) {
        LinkedList linkedList = this.begin;
        synchronized (linkedList) {
            int n = this.begin.size();
            if (n == 0) {
                this.begin.add(timerTask);
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    TimerTask timerTask2 = (TimerTask)this.begin.get(i);
                    if (timerTask2.nextExecutionTime > timerTask.nextExecutionTime) {
                        if (i != 0) continue;
                        this.begin.add(0, timerTask);
                        this.clear.interrupt();
                        break;
                    }
                    this.begin.add(i + 1, timerTask);
                    break;
                }
            }
        }
        this.cancel.raise(1);
    }

    private int cancel(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(TimerTask timerTask) {
        if (timerTask == null) {
            return;
        }
        try {
            this.currentTimeMillis = true;
            timerTask.execute();
        }
        catch (Exception exception) {
        }
        finally {
            long l = timerTask.period;
            if (l > 0L) {
                timerTask.nextExecutionTime = System.currentTimeMillis() + l;
                this.begin(timerTask);
            }
            this.currentTimeMillis = false;
        }
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
    }

    @Override
    public void setTaskListener(TaskListener taskListener) {
    }

    private static class TimerTask
    implements Task {
        long nextExecutionTime;
        long period = 0L;
        Task task;

        public TimerTask(Task task) {
            this.task = task;
        }

        @Override
        public void execute() {
            this.task.execute();
        }

        @Override
        public void setTaskContext(TaskContext taskContext) {
        }

        @Override
        public void setTaskListener(TaskListener taskListener) {
        }

        @Override
        public ID getID() {
            return null;
        }
    }
}

