/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.DialogInsets;
import guitools.Painter;
import guitools.UIResource;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jet.JResource;

public class MsgBox
extends Dialog {
    public static final int OK = 0;
    public static final int YESNO = 1;
    public static final int OKCANCEL = 2;
    public static final int YESNOCANCEL = 3;
    public static final int ABORTRETRYIGNORE = 4;
    public static final int ID_YES = 0;
    public static final int ID_NO = 1;
    public static final int ID_OK = 2;
    public static final int ID_CANCEL = 3;
    public static final int ID_ABORT = 4;
    public static final int ID_RETRY = 5;
    public static final int ID_IGNORE = 6;
    public static final int ID_YESTOALL = 7;
    public static final int ID_NOTOALL = 8;
    private static final String SEDU = JResource.getDlgText((String)"MsgBox", (String)"Yes");
    private static final String append = JResource.getDlgText((String)"MsgBox", (String)"No");
    private static final String center = JResource.getDlgText((String)"Public", (String)"ok");
    private static final String equals = JResource.getDlgText((String)"Public", (String)"cancel");
    private static final String getButtonSize = JResource.getDlgText((String)"MsgBox", (String)"Abort");
    private static final String getClass = JResource.getDlgText((String)"MsgBox", (String)"Retry");
    private static final String getColor = JResource.getDlgText((String)"MsgBox", (String)"Ignore");
    private String getDefaultToolkit = null;
    private int getDlgText;
    private int getFont;
    private static int getFontMetrics;
    private static int getFrame;
    private static int getHeight;
    private Rectangle getMaxDescent = null;
    private ContentPane getMessage = null;

    public MsgBox(Component component, String string, String string2, int n) {
        this(component, string, n);
        this.setMessage(string2);
        this.setVisible(true);
    }

    MsgBox(Component component, String string, int n) {
        super(UIResource.getFrame((Component)component), string, true);
        this.setLayout(new BorderLayout());
        this.getMessage = new ContentPane();
        this.getMessage.setBackground(UIResource.getColor((Object)"Control Background"));
        this.getMessage.setForeground(UIResource.getColor((Object)"Control Foreground"));
        this.getMessage.setFont(UIResource.getFont((Object)"Control Font"));
        this.add((Component)this.getMessage, "Center");
        this.getFont = n;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Window window = (Window)windowEvent.getSource();
                window.dispose();
            }
        });
    }

    public static int promptWarning(Component component, String string, int n) {
        MsgBox msgBox = new MsgBox(component, JResource.getDlgText((String)"MsgBox", (String)"Warning"), string, n);
        int n2 = msgBox.getRetCode();
        component.requestFocus();
        msgBox = null;
        return n2;
    }

    public static int promptWarning(Component component, String string) {
        return MsgBox.promptWarning(component, string, 0);
    }

    public static int promptError(Component component, Throwable throwable) {
        return MsgBox.promptError(component, null, throwable, 0);
    }

    public static int promptError(Component component, String string, Throwable throwable) {
        return MsgBox.promptError(component, string, throwable, 0);
    }

    public static int promptError(Component component, String string, Throwable throwable, int n) {
        String string2 = "";
        if (string != null && !string.equals("")) {
            string2 = string + ", ";
        }
        string2 = string2 + " - " + throwable.getClass().getName();
        if (throwable.getMessage() != null && !throwable.getMessage().equals("")) {
            string2 = string2 + " : '" + throwable.getMessage() + "'";
        }
        return MsgBox.promptError(component, string2, n);
    }

    public static int promptError(Component component, String string, int n) {
        MsgBox msgBox = new MsgBox(component, JResource.getDlgText((String)"MsgBox", (String)"Error"), string, n);
        int n2 = msgBox.getRetCode();
        component.requestFocus();
        msgBox = null;
        return n2;
    }

    public static int promptError(Component component, String string) {
        return MsgBox.promptError(component, string, 0);
    }

    public static int promptMessage(Component component, String string, int n) {
        MsgBox msgBox = new MsgBox(component, JResource.getDlgText((String)"MsgBox", (String)"Message"), string, n);
        component.requestFocus();
        int n2 = msgBox.getRetCode();
        msgBox = null;
        return n2;
    }

    void setMessage(String string) {
        this.getDefaultToolkit = string;
    }

    Dimension getPreferredSizeOfContentPane() {
        Font font = this.getMessage.getFont();
        Dimension dimension = Painter.layoutText(null, (String)this.getDefaultToolkit, (int)getHeight, (int)(getFrame - 80), (Font)font);
        int n = 60 + Toolkit.getDefaultToolkit().getFontMetrics(font).getHeight() * 2;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = dimension2.height - n;
        if (dimension.height > n2 - 40) {
            dimension.height = n2 - 40;
        }
        this.getMaxDescent = new Rectangle(40, 20, getFrame - 80, dimension.height);
        Dimension dimension3 = this.getMessage.getButtonSize();
        if (this.getFont == 1 || this.getFont == 2) {
            dimension3.width *= 3;
        } else if (this.getFont == 3 || this.getFont == 4) {
            dimension3.width *= 4;
        }
        return new Dimension(Math.max(Math.max(dimension.width, dimension3.width) + 80, getFontMetrics), dimension.height + n);
    }

    @Override
    public void show() {
        this.getMessage.reposContents();
        DialogInsets.center(this);
        this.setResizable(false);
        super.show();
    }

    public int getRetCode() {
        return this.getDlgText;
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        getFontMetrics = dimension.width / 3;
        getFrame = dimension.width * 2 / 3;
        FontMetrics fontMetrics = toolkit.getFontMetrics(UIResource.getFont((Object)"Control Font"));
        getHeight = fontMetrics.getMaxDescent() * 2;
    }

    private class ContentPane
    extends Panel
    implements ActionListener {
        ContentPane() {
            this.setLayout(null);
        }

        Dimension getButtonSize() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            boolean bl = false;
            int n = 0;
            int n2 = (int)((double)fontMetrics.getHeight() * 1.6);
            n = MsgBox.this.getFont == 1 ? Math.max(fontMetrics.stringWidth(SEDU), fontMetrics.stringWidth(append)) : (MsgBox.this.getFont == 2 ? Math.max(fontMetrics.stringWidth(center), fontMetrics.stringWidth(equals)) : (MsgBox.this.getFont == 3 ? Math.max(fontMetrics.stringWidth(SEDU), Math.max(fontMetrics.stringWidth(append), fontMetrics.stringWidth(equals))) : (MsgBox.this.getFont == 4 ? Math.max(fontMetrics.stringWidth(getButtonSize), Math.max(fontMetrics.stringWidth(getClass), fontMetrics.stringWidth(getColor))) : fontMetrics.stringWidth(center) * 3)));
            n = Math.max(n * 2, (int)((double)n2 * 2.5));
            return new Dimension(n, n2);
        }

        void reposContents() {
            Dimension dimension = MsgBox.this.getPreferredSizeOfContentPane();
            this.setSize(dimension);
            int n = dimension.width;
            int n2 = dimension.height;
            Dimension dimension2 = this.getButtonSize();
            int n3 = dimension2.width;
            int n4 = dimension2.height;
            int n5 = n / 2;
            if (MsgBox.this.getFont == 1) {
                int n6 = n3 / 3;
                Button button = new Button(SEDU);
                button.addActionListener(this);
                button.setBounds(n5 - n6 - n3, n2 - 20 - n4, n3, n4);
                this.add(button);
                button = new Button(append);
                button.addActionListener(this);
                button.setBounds(n5 + n6, n2 - 20 - n4, n3, n4);
                this.add(button);
                MsgBox.this.getDlgText = 1;
                button.requestFocus();
            } else if (MsgBox.this.getFont == 2) {
                int n7 = n3 / 3;
                Button button = new Button(center);
                button.addActionListener(this);
                button.setBounds(n5 - n7 - n3, n2 - 20 - n4, n3, n4);
                this.add(button);
                button = new Button(equals);
                button.addActionListener(this);
                button.setBounds(n5 + n7, n2 - 20 - n4, n3, n4);
                this.add(button);
                MsgBox.this.getDlgText = 3;
                button.requestFocus();
            } else if (MsgBox.this.getFont == 3) {
                int n8 = n3 / 3;
                Button button = new Button(SEDU);
                button.addActionListener(this);
                button.setBounds(n5 - n8 - n3 * 3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                button = new Button(append);
                button.addActionListener(this);
                button.setBounds(n5 - n3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                button.requestFocus();
                button = new Button(equals);
                button.addActionListener(this);
                button.setBounds(n5 + n8 + n3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                MsgBox.this.getDlgText = 3;
            } else if (MsgBox.this.getFont == 4) {
                int n9 = n3 / 3;
                Button button = new Button(getButtonSize);
                button.addActionListener(this);
                button.setBounds(n5 - n9 - n3 * 3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                button = new Button(getClass);
                button.addActionListener(this);
                button.setBounds(n5 - n3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                button.requestFocus();
                button = new Button(getColor);
                button.addActionListener(this);
                button.setBounds(n5 + n9 + n3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                MsgBox.this.getDlgText = 5;
            } else {
                MsgBox.this.getFont = 0;
                Button button = new Button(center);
                button.addActionListener(this);
                button.setBounds(n5 - n3 / 2, n2 - 20 - n4, n3, n4);
                this.add(button);
                MsgBox.this.getDlgText = 2;
                button.requestFocus();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SEDU)) {
                MsgBox.this.getDlgText = 0;
            } else if (string.equals(append)) {
                MsgBox.this.getDlgText = 1;
            } else if (string.equals(center)) {
                MsgBox.this.getDlgText = 2;
            } else if (string.equals(equals)) {
                MsgBox.this.getDlgText = 3;
            } else if (string.equals(getButtonSize)) {
                MsgBox.this.getDlgText = 4;
            } else if (string.equals(getClass)) {
                MsgBox.this.getDlgText = 5;
            } else if (string.equals(getColor)) {
                MsgBox.this.getDlgText = 6;
            }
            MsgBox.this.dispose();
        }

        @Override
        public void update(Graphics graphics) {
            Painter.drawText((Graphics)graphics, (Rectangle)MsgBox.this.getMaxDescent, (int)getHeight, (String)MsgBox.this.getDefaultToolkit, (Font)this.getFont(), (Color)this.getForeground(), (boolean)true, (boolean)false, (boolean)false, (int)1);
        }

        @Override
        public void paint(Graphics graphics) {
            this.update(graphics);
        }
    }
}

