/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import com.jinfonet.awt.JFont;
import guitools.Painter;
import guitools.toolkit.RepaintImageListener;
import guitools.toolkit.TComponent;
import guitools.toolkit.TextCaret;
import guitools.toolkit.TextDoAction;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.ImageObserver;
import java.util.Stack;
import jet.log.JRLogger;

public class TextComp
extends TComponent
implements KeyListener,
FocusListener,
MouseListener,
MouseMotionListener,
RepaintImageListener {
    public static final int TOP = 0;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 2;
    private static final Insets SEDU = new Insets(3, 4, 3, 4);
    int hAlignment = 0;
    int vAlignment = 1;
    boolean underline;
    boolean strikeout;
    boolean wordwrap;
    String text = "";
    boolean editable = true;
    boolean overcast;
    int selectionStart;
    int selectionEnd;
    char echoChar;
    String actionCommand;
    transient ActionListener actionListener;
    protected transient TextListener textListener;
    boolean nopaintText;
    int sx;
    int sy;
    int tx;
    int ty;
    FontMetrics fm;
    TextCaret caret = new TextCaret((Component)((Object)this), 600L);
    Image backImg;
    Image img;
    static final Stack undo = new Stack();
    static final Stack redo = new Stack();
    static Clipboard clipBoard = null;
    private static JRLogger actionPerformed = JRLogger.getLogger((String)TextComp.class.getName());
    boolean isNew = true;

    public TextComp() {
        this("");
    }

    public TextComp(String string) {
        this.enableEvents(60L);
        this.text = string == null ? "" : string;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        super.reshape(n, n2, n3, n4);
        if (n3 != dimension.width && dimension.height != n4) {
            this.updateTextPos();
            this.updateCaretPos();
            this.updateBackImage();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.fm == null) {
            Font font = this.getFont();
            this.fm = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
        }
        if (this.tpb != null) {
            this.tpb.addRepaintImageListener((RepaintImageListener)this);
        }
    }

    public void removeNotify() {
        this.caret.stop();
        super.removeNotify();
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.isShowing()) {
            this.fm = font instanceof JFont ? ((JFont)font).getFontMetrics() : this.getToolkit().getFontMetrics(font);
            this.updateTextPos();
        } else {
            this.fm = null;
        }
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public synchronized void setText(String string) {
        String string2 = string = string == null ? "" : string;
        if (!this.text.equals(string)) {
            int n;
            this.text = string;
            int n2 = string.length();
            int n3 = this.selectionStart > n2 ? n2 : this.selectionStart;
            int n4 = n = this.selectionEnd > n2 ? n2 : this.selectionEnd;
            if (n3 != this.selectionStart || n != this.selectionEnd) {
                this.selectionStart = n3;
                this.selectionEnd = n;
                this.updateCaretPos();
            }
            this.processEvent(new TextEvent(this, 900));
            this.updateTextPos();
            this.repaint();
        }
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized String getSelectedText() {
        int n = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
        int n2 = this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
        String string = this.text.substring(n, n2);
        if (this.echoCharIsSet()) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                string2 = string2 + this.echoChar;
            }
            string = string2;
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isOvercast() {
        return this.overcast;
    }

    public synchronized void setOvercast(boolean bl) {
        this.overcast = bl;
    }

    public synchronized int getSelectionStart() {
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int n) {
        this.select(n, this.selectionEnd);
    }

    public synchronized int getSelectionEnd() {
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int n) {
        this.select(this.selectionStart, n);
    }

    public synchronized void select(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.text.length();
        int n6 = n < 0 ? 0 : (n4 = n > n5 ? n5 : n);
        int n7 = n2 < 0 ? 0 : (n3 = n2 > n5 ? n5 : n2);
        if (n4 != this.selectionStart || n3 != this.selectionEnd) {
            boolean bl = this.selectionStart != this.selectionEnd;
            this.selectionStart = n4;
            this.selectionEnd = n3;
            if (!this.updateCaretPos() && (n4 != n3 || bl)) {
                this.repaint();
            }
        }
    }

    public synchronized void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.text.length();
        if (!this.updateCaretPos()) {
            this.repaint();
        }
    }

    public void setCaretPosition(int n) {
        if (this.selectionStart != this.selectionEnd || this.selectionStart != n) {
            String string = this.SEDU();
            if (n < 0) {
                Toolkit.getDefaultToolkit().beep();
                n = 0;
            }
            boolean bl = this.selectionStart != this.selectionEnd;
            int n2 = string.length();
            if (n > n2) {
                Toolkit.getDefaultToolkit().beep();
                n = n2;
            }
            this.selectionStart = n;
            this.selectionEnd = n;
            if (!this.updateCaretPos() && bl) {
                this.repaint();
            }
        }
    }

    public int getCaretPosition() {
        return this.selectionEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.caret.isAlive() && this.isVisible()) {
            this.caret.setVisible(false);
            Dimension dimension = this.getSize();
            n = n < 0 ? 0 : n;
            n2 = n2 < 0 ? 0 : n2;
            n3 = (n3 += n) > dimension.width ? dimension.width - n : n3 - n;
            n4 = n4 > dimension.height ? dimension.height - n2 : (n4 += n2) - n2;
            this.editorPaint(n, n2, n3, n4);
            super.repaint(l, n, n2, n3, n4);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    if (this.img != null) {
                        graphics.clipRect(n, n2, n3, n4);
                        graphics.drawImage(this.img, 0, 0, (ImageObserver)((Object)this));
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
            if (this.isEnabled()) {
                this.caret.setVisible(true);
            }
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            if (this.isNew) {
                this.updateTextPos();
            }
            if (this.caret.isAlive() && !this.nopaintText) {
                if (this.img != null) {
                    graphics.drawImage(this.img, 0, 0, (ImageObserver)((Object)this));
                }
            } else {
                Dimension dimension = this.getSize();
                if (this.hasEraser()) {
                    if (this.editable && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
                }
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 1);
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(1, 1, dimension.width - 2, 1);
                graphics.drawLine(1, 1, 1, dimension.height - 2);
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                if (!this.nopaintText) {
                    this.drawText(graphics, dimension.width, dimension.height);
                }
            }
        }
    }

    protected void drawText(Graphics graphics, int n, int n2) {
        String string = this.SEDU();
        int n3 = string.length();
        int n4 = this.fm.getMaxAscent();
        int n5 = this.caret.isAlive() ? this.sx : this.tx;
        int n6 = this.caret.isAlive() ? this.sy : this.ty;
        int n7 = this.fm.stringWidth(string);
        int n8 = n4 + this.fm.getMaxDescent();
        graphics.clipRect(TextComp.SEDU.left, TextComp.SEDU.top, n - TextComp.SEDU.left - TextComp.SEDU.right, n2 - TextComp.SEDU.top - TextComp.SEDU.bottom);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(string, n5, n6 + n4);
        if (this.underline) {
            graphics.drawLine(n5, n6 + n8, n5 + n7, n6 + n8);
        }
        if (this.strikeout) {
            graphics.drawLine(n5, n6 + n4 * 2 / 3, n5 + n7, n6 + n4 * 2 / 3);
        }
        if (this.caret.isAlive()) {
            int n9;
            int n10;
            int n11 = this.selectionStart == 0 ? this.sx : (n10 = this.selectionStart == n3 ? this.sx + n7 : this.sx + this.fm.stringWidth(string.substring(0, this.selectionStart)));
            int n12 = this.selectionEnd == this.selectionStart ? n10 : (this.selectionEnd == 0 ? this.sx : (n9 = this.selectionEnd == n3 ? this.sx + n7 : this.sx + this.fm.stringWidth(string.substring(0, this.selectionEnd))));
            if (n10 != n9) {
                graphics.setXORMode(new Color(this.getBackground().getRGB()));
                graphics.setColor(this.getForeground());
                graphics.fillRect(n10 < n9 ? n10 : n9, n6, n10 < n9 ? n9 - n10 : n10 - n9, n8);
                graphics.setPaintMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editorPaint(int n, int n2, int n3, int n4) {
        if (this.img != null) {
            int n5 = this.img.getWidth((ImageObserver)((Object)this));
            int n6 = this.img.getHeight((ImageObserver)((Object)this));
            Graphics graphics = this.img.getGraphics();
            try {
                if (this.hasEraser()) {
                    if (this.editable && this.isEnabled()) {
                        graphics.setColor(this.getBackground());
                    } else {
                        graphics.setColor(SystemColor.control);
                    }
                    graphics.fillRect(0, 0, n5, n6);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(0, 0, n5 - 1, 0);
                    graphics.drawLine(0, 0, 0, n6 - 1);
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(1, 1, n5 - 2, 1);
                    graphics.drawLine(1, 1, 1, n6 - 2);
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(1, n6 - 2, n5 - 2, n6 - 2);
                    graphics.drawLine(n5 - 2, 1, n5 - 2, n6 - 2);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
                    graphics.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
                } else if (this.backImg != null) {
                    graphics.drawImage(this.backImg, 0, 0, (ImageObserver)((Object)this));
                }
                this.drawText(graphics, n5, n6);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public void setAlignments(int n, int n2) {
        boolean bl = false;
        if (this.hAlignment != n && n >= 0 && n <= 2) {
            this.hAlignment = n;
            bl = true;
        }
        if (this.vAlignment != n2 && n2 >= 0 && n2 <= 2) {
            this.vAlignment = n2;
            bl = true;
        }
        if (bl) {
            this.updateTextPos();
            if (!this.updateCaretPos()) {
                this.repaint();
            }
        }
    }

    public int getHAlignment() {
        return this.hAlignment;
    }

    public int getVAlignment() {
        return this.vAlignment;
    }

    public void setUnderline(boolean bl) {
        if (this.underline != bl) {
            this.underline = bl;
            this.repaint();
        }
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public void setStrikeout(boolean bl) {
        if (this.strikeout != bl) {
            this.strikeout = bl;
            this.repaint();
        }
    }

    public boolean getStrikeout() {
        return this.strikeout;
    }

    public void setWordwrap(boolean bl) {
        if (this.wordwrap != bl) {
            this.wordwrap = bl;
            this.repaint();
        }
    }

    public boolean getWordwrap() {
        return this.wordwrap;
    }

    public void beforeDrawImage() {
        if (this.caret.isAlive()) {
            this.caret.suspend();
            this.caret.showing = false;
        }
    }

    public void afterDrawImage() {
        if (this.caret.isAlive()) {
            this.caret.resume();
        }
    }

    public void clearStacks() {
        undo.removeAllElements();
        redo.removeAllElements();
    }

    public boolean isEmptyUndo() {
        return undo.isEmpty();
    }

    public boolean isEmptyRedo() {
        return redo.isEmpty();
    }

    public void undo() {
        if (!undo.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)undo.pop();
            switch (textDoAction.type) {
                case 0: {
                    redo.push(this.insert(textDoAction));
                    break;
                }
                case 1: {
                    redo.push(this.delete(textDoAction));
                    break;
                }
                case 2: {
                    redo.push(this.replace(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        if (!redo.isEmpty()) {
            TextDoAction textDoAction = (TextDoAction)redo.pop();
            switch (textDoAction.type) {
                case 0: {
                    undo.push(this.insert(textDoAction));
                    break;
                }
                case 1: {
                    undo.push(this.delete(textDoAction));
                    break;
                }
                case 2: {
                    undo.push(this.replace(textDoAction));
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void cut() {
        if (this.selectionStart != this.selectionEnd) {
            int n = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
            int n2 = this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
            String string = this.text.substring(n, n2);
            if (clipBoard != null) {
                clipBoard.setContents(new StringSelection(string), null);
            }
            this.pushUndo(this.delete(new TextDoAction(1, n, n2, string)));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd && clipBoard != null) {
            clipBoard.setContents(new StringSelection(this.getSelectedText()), null);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void paste() {
        Transferable transferable;
        if (clipBoard != null && (transferable = clipBoard.getContents(null)) != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insert(Painter.adjustString((String)string));
            }
            catch (Exception exception) {
                if (actionPerformed.isErrorEnabled()) {
                    actionPerformed.error((Object)"", (Throwable)exception);
                }
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.text : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.textListener != null) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = keyEvent.getID();
        if (n == 400) {
            this.keyTyped(keyEvent);
        } else if (n == 401) {
            this.keyPressed(keyEvent);
        } else if (n == 402) {
            this.keyReleased(keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.caret.isAlive()) {
                    this.requestFocus();
                }
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 504: {
                this.setCursor(Cursor.getPredefinedCursor(2));
                break;
            }
            case 505: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            this.mouseDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.caret.isAlive()) {
            this.caret.suspend();
            this.setCaretPosition(this.getPos(mouseEvent.getX()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!mouseEvent.isPopupTrigger() && !mouseEvent.isMetaDown() && !mouseEvent.isAltDown() && this.caret.isAlive()) {
            int n = this.getPos(mouseEvent.getX());
            if (mouseEvent.getClickCount() > 1 && this.text.length() > 0) {
                char c = this.text.charAt(n = n == this.text.length() ? --n : n);
                if (Character.isLetterOrDigit(c)) {
                    this.select(this.getPrevWord(n), this.getNextWord(n));
                } else if (Character.isSpaceChar(c)) {
                    this.select(this.selectionStart, n);
                } else {
                    this.select(n, n + 1);
                }
            } else {
                this.select(this.selectionStart, n);
            }
            this.caret.resume();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.select(this.selectionStart, this.getPos(mouseEvent.getX()));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        block34: {
            int n;
            char c;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block33: {
                if (!this.isEnabled()) {
                    return;
                }
                this.caret.suspend();
                bl4 = keyEvent.isAltDown();
                bl3 = keyEvent.isShiftDown();
                bl2 = keyEvent.isControlDown();
                c = keyEvent.getKeyChar();
                n = keyEvent.getKeyCode();
                bl = true;
                if (!keyEvent.isActionKey() || bl4) break block33;
                switch (n) {
                    case 36: {
                        if (bl3) {
                            this.select(0, this.selectionEnd);
                            break;
                        }
                        this.setCaretPosition(0);
                        break;
                    }
                    case 35: {
                        int n2 = this.text.length();
                        if (bl3) {
                            this.select(this.selectionStart, n2);
                            break;
                        }
                        this.setCaretPosition(n2);
                        break;
                    }
                    case 37: {
                        if (bl3 && bl2) {
                            this.select(this.selectionStart, this.movePrevWord(this.selectionEnd - 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.selectionStart, this.selectionEnd - 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.movePrevWord(this.selectionEnd - 1));
                            break;
                        }
                        int n3 = this.selectionStart < this.selectionEnd ? this.selectionStart : (this.selectionStart > this.selectionEnd ? this.selectionEnd : this.selectionStart - 1);
                        this.setCaretPosition(n3);
                        break;
                    }
                    case 39: {
                        if (bl3 && bl2) {
                            this.select(this.selectionStart, this.moveNextWord(this.selectionEnd + 1));
                            break;
                        }
                        if (bl3) {
                            this.select(this.selectionStart, this.selectionEnd + 1);
                            break;
                        }
                        if (bl2) {
                            this.setCaretPosition(this.moveNextWord(this.selectionEnd + 1));
                            break;
                        }
                        int n4 = this.selectionStart < this.selectionEnd ? this.selectionEnd : (this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd + 1);
                        this.setCaretPosition(n4);
                        break;
                    }
                    case 155: {
                        if (this.editable) {
                            this.setOvercast(!this.overcast);
                            break;
                        }
                        break block34;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                break block34;
            }
            if (Character.isISOControl(c) && bl2 && (n == 67 || n == 99) && !bl4 && !bl3) {
                this.copy();
            } else if (this.editable && Character.isISOControl(c)) {
                switch (n) {
                    case 8: {
                        if (bl4 && !bl3 && !bl2) {
                            this.undo();
                            break;
                        }
                        if (bl2) {
                            this.delWord(true);
                            break;
                        }
                        this.delChar(true);
                        break;
                    }
                    case 86: 
                    case 118: {
                        if (bl4 || bl3 || !bl2) break;
                        this.paste();
                        break;
                    }
                    case 88: 
                    case 120: {
                        if (bl4 || bl3 || !bl2) break;
                        this.cut();
                        break;
                    }
                    case 89: 
                    case 121: {
                        if (bl4 || bl3 || !bl2) break;
                        this.redo();
                        break;
                    }
                    case 90: 
                    case 122: {
                        if (bl4 || bl3 || !bl2) break;
                        this.undo();
                        break;
                    }
                    case 127: {
                        if (!bl4 && !bl3 && bl2) {
                            this.delWord(false);
                            break;
                        }
                        if (bl4 || bl3 || bl2) break;
                        this.delChar(false);
                        break;
                    }
                    case 10: {
                        if (bl4 || bl3 || bl2) break;
                        this.processEvent(new ActionEvent(this, 1001, this.getActionCommand(), keyEvent.getModifiers()));
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
        }
        this.caret.resume();
        if (bl) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.editable && !Character.isISOControl(c)) {
            this.insert("" + c);
            this.processEvent(new TextEvent(this, 900));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.editable) {
            this.caret.resume();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.setEditor(focusEvent.getID() == 1004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackImage() {
        Dimension dimension = this.getSize();
        if (this.caret.isAlive() && dimension.width > 0 && dimension.height > 0) {
            this.caret.setVisible(false);
            if (!this.hasEraser()) {
                this.backImg = this.createImage(dimension.width, dimension.height);
                if (this.backImg != null) {
                    Graphics graphics = this.backImg.getGraphics();
                    try {
                        this.nopaintText = true;
                        this.tpb.drawArea(graphics, this.mapBoundsToBoard());
                        this.nopaintText = false;
                        graphics.setColor(this.getForeground());
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
            if (this.img == null || this.img.getWidth((ImageObserver)((Object)this)) != dimension.width || this.img.getHeight((ImageObserver)((Object)this)) != dimension.height) {
                this.img = this.createImage(dimension.width, dimension.height);
            }
            this.repaint();
            this.repaintImage();
            this.caret.setVisible(true);
        }
    }

    public void setEditor(boolean bl) {
        if (bl) {
            if (!this.caret.isAlive()) {
                this.caret.start();
                this.updateBackImage();
                this.updateCaretPos();
            }
        } else if (this.caret.isAlive()) {
            this.caret.stop();
            this.backImg = null;
            this.img = null;
            this.repaint();
        }
    }

    public boolean isEditor() {
        return this.caret.isAlive();
    }

    protected void updateTextPos() {
        if (this.fm != null) {
            Dimension dimension = this.getSize();
            String string = this.SEDU();
            int n = this.fm.stringWidth(string);
            int n2 = this.fm.getMaxAscent() + this.fm.getMaxDescent();
            if (this.hAlignment == 0) {
                this.tx = TextComp.SEDU.left;
            } else if (this.hAlignment == 1) {
                this.tx = (dimension.width - n) / 2;
            } else if (this.hAlignment == 2) {
                this.tx = dimension.width - n - TextComp.SEDU.right;
            }
            if (this.vAlignment == 0) {
                this.ty = TextComp.SEDU.top;
            } else if (this.vAlignment == 1) {
                this.ty = (dimension.height - n2) / 2;
            } else if (this.vAlignment == 2) {
                this.ty = dimension.height - n2 - TextComp.SEDU.bottom;
            }
            this.sx = this.tx;
            this.sy = this.ty;
            this.isNew = false;
        }
    }

    protected boolean updateCaretPos() {
        if (this.fm != null) {
            int n = this.sx;
            Dimension dimension = this.getSize();
            String string = this.SEDU();
            int n2 = this.fm.stringWidth(string);
            if (n2 < dimension.width - 4) {
                this.updateTextPos();
            }
            int n3 = this.selectionEnd == 0 ? 0 : (this.selectionEnd == string.length() ? n2 : this.fm.stringWidth(string.substring(0, this.selectionEnd)));
            int n4 = this.sx + n3;
            n4 = n4 < 2 ? 2 : (n4 > dimension.width - 3 ? dimension.width - 3 : n4);
            this.sx = n4 - n3;
            this.caret.setBounds(n4, this.sy, 2, this.fm.getHeight());
            if (n != this.sx) {
                this.repaint();
                return true;
            }
        }
        return false;
    }

    protected int getPos(int n) {
        int n2;
        int n3 = this.getSize().width - 3;
        int n4 = this.text.length();
        int n5 = this.fm.stringWidth(this.text);
        if (n <= this.sx) {
            n2 = 0;
        } else if (n > this.sx + n5) {
            n2 = n4;
        } else {
            int n6;
            int n7 = 0;
            while ((n6 = this.sx + this.fm.stringWidth(this.text.substring(0, n2 = (n7 + n4) / 2))) != n) {
                if (n6 > n) {
                    n4 = n2;
                } else if (n6 < n) {
                    n7 = n2 + 1;
                }
                if (n7 != n4) continue;
            }
            if (n7 == n4) {
                int n8 = this.fm.charWidth(this.text.charAt(n2));
                n2 = n6 < n ? (n - n6 > n8 / 2 ? n2 + 1 : n2) : (n6 > n ? (n6 - n > n8 / 2 && n2 > 0 ? n2 - 1 : n2) : n2);
            }
        }
        return n2;
    }

    protected void delChar(boolean bl) {
        int n;
        int n2;
        if (this.selectionStart != this.selectionEnd) {
            n2 = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
            n = this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
        } else {
            int n3 = this.text.length();
            if (bl && this.selectionStart == 0 && this.selectionEnd == 0 || !bl && this.selectionStart == n3 && this.selectionEnd == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.selectionEnd - (bl ? 1 : 0);
            n = this.selectionEnd + (bl ? 0 : 1);
        }
        this.pushUndo(this.delete(new TextDoAction(1, n2, n, this.text.substring(n2, n))));
    }

    protected void delWord(boolean bl) {
        int n;
        int n2;
        if (this.selectionStart != this.selectionEnd) {
            n2 = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
            n = this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
        } else {
            int n3 = this.text.length();
            if (bl && this.selectionStart == 0 && this.selectionEnd == 0 || !bl && this.selectionStart == n3 && this.selectionEnd == n3) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            n2 = this.selectionEnd - (bl ? 1 : 0);
            n = this.selectionEnd + (bl ? 0 : 1);
        }
        n2 = bl ? this.getPrevWord(n2) : n2;
        n = bl ? n : this.getNextWord(n);
        this.pushUndo(this.delete(new TextDoAction(1, n2, n, this.text.substring(n2, n))));
    }

    protected void insert(String string) {
        if (this.selectionStart != this.selectionEnd) {
            int n = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
            int n2 = this.selectionStart > this.selectionEnd ? this.selectionStart : this.selectionEnd;
            this.pushUndo(this.replace(new TextDoAction(2, n, n2, string)));
        } else if (this.overcast && this.selectionEnd < this.text.length()) {
            this.pushUndo(this.replace(new TextDoAction(2, this.selectionEnd, this.selectionEnd + string.length(), string)));
        } else {
            this.pushUndo(this.insert(new TextDoAction(0, this.selectionEnd, this.selectionEnd + string.length(), string)));
        }
    }

    TextDoAction delete(TextDoAction textDoAction) {
        textDoAction.type = 0;
        this.text = this.text.substring(0, textDoAction.start) + this.text.substring(textDoAction.end, this.text.length());
        this.selectionEnd = this.selectionStart = textDoAction.start;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction replace(TextDoAction textDoAction) {
        String string = this.text.substring(textDoAction.start, textDoAction.end);
        this.text = this.text.substring(0, textDoAction.start) + textDoAction.str + this.text.substring(textDoAction.end, this.text.length());
        this.selectionEnd = this.selectionStart = textDoAction.start + textDoAction.str.length();
        textDoAction.end = this.selectionStart;
        textDoAction.str = string;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    TextDoAction insert(TextDoAction textDoAction) {
        textDoAction.type = 1;
        this.text = this.text.substring(0, textDoAction.start) + textDoAction.str + this.text.substring(textDoAction.start, this.text.length());
        this.selectionEnd = this.selectionStart = textDoAction.start + textDoAction.str.length();
        textDoAction.end = this.selectionStart;
        if (!this.updateCaretPos()) {
            this.repaint();
        }
        return textDoAction;
    }

    protected void pushUndo(TextDoAction textDoAction) {
        undo.push(textDoAction);
        redo.removeAllElements();
        this.processEvent(new TextEvent(this, 900));
    }

    protected int getPrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.text.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    protected int getNextWord(int n) {
        int n2;
        int n3;
        if ((n = this.skipNextSpaceChar(n)) < (n3 = this.text.length())) {
            char[] cArray = this.text.substring(n).toCharArray();
            n3 = cArray.length;
            if (Character.isLetterOrDigit(cArray[n2])) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Character.isLetterOrDigit(cArray[n2])) continue;
                    return n2 + n;
                }
            }
        }
        return n2 + n;
    }

    protected int movePrevWord(int n) {
        if ((n = this.skipPrevSpaceChar(n)) > 0) {
            char[] cArray = this.text.substring(0, n).toCharArray();
            if (Character.isLetterOrDigit(cArray[--n])) {
                --n;
                while (n >= 0) {
                    if (!Character.isLetterOrDigit(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            } else {
                --n;
                while (n >= 0) {
                    if (Character.isLetterOrDigit(cArray[n]) || Character.isSpaceChar(cArray[n])) {
                        return ++n;
                    }
                    --n;
                }
            }
            ++n;
        }
        return n < 0 ? 0 : n;
    }

    protected int moveNextWord(int n) {
        int n2;
        block5: {
            int n3;
            if ((n = this.skipNextSpaceChar(n)) >= (n3 = this.text.length())) break block5;
            char[] cArray = this.text.substring(n).toCharArray();
            n3 = cArray.length;
            if (Character.isLetterOrDigit(cArray[n2])) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Character.isLetterOrDigit(cArray[n2])) continue;
                    return n2 + n;
                }
            } else {
                while (n2 < n3) {
                    if (Character.isLetterOrDigit(cArray[n2]) || Character.isSpaceChar(cArray[n2])) {
                        return n2 + n;
                    }
                    ++n2;
                }
            }
        }
        return n2 + n;
    }

    protected int skipPrevSpaceChar(int n) {
        if (n > 0 && Character.isSpaceChar(this.text.charAt(n))) {
            --n;
            while (n >= 0) {
                if (!Character.isSpaceChar(this.text.charAt(n))) {
                    return ++n;
                }
                --n;
            }
        }
        return n < 0 ? 0 : n;
    }

    protected int skipNextSpaceChar(int n) {
        int n2 = this.text.length();
        if (n < n2 && Character.isSpaceChar(this.text.charAt(n))) {
            while (n < n2) {
                if (!Character.isSpaceChar(this.text.charAt(n))) {
                    return n;
                }
                ++n;
            }
        }
        return n;
    }

    protected String paramString() {
        String string = super.paramString() + ",text=" + this.text;
        if (this.editable) {
            string = string + ",editable=" + this.editable;
        }
        if (this.overcast) {
            string = string + ",overcast=" + this.overcast;
        }
        return string + ",selection=" + this.selectionStart + "-" + this.selectionEnd;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public synchronized void setEchoChar(char c) {
        this.echoChar = c;
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.caret.stop();
        }
        super.setEnabled(bl);
        this.repaint();
    }

    private String SEDU() {
        String string = this.text;
        if (this.echoChar != '\u0000') {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < string.length(); ++i) {
                stringBuffer.setCharAt(i, this.echoChar);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static {
        try {
            clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable throwable) {
            clipBoard = null;
        }
    }
}

