/*
 * Decompiled with CFR 0.152.
 */
package jet.cache;

import jet.cache.store.MemoryStoreEvictionPolicy;

public class CacheConfiguration
implements Cloneable {
    protected String name;
    protected int maxElementsInMemory;
    protected long maxMemorySize;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    protected boolean eternal;
    protected long timeToIdleSeconds;
    protected long timeToLiveSeconds;

    public CacheConfiguration clone() throws CloneNotSupportedException {
        return (CacheConfiguration)super.clone();
    }

    public final void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        this.name = string;
    }

    public final void setMaxElementsInMemory(int n) {
        this.maxElementsInMemory = n;
    }

    public final void setMemoryStoreEvictionPolicy(String string) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(string);
    }

    public final void setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public final void setMaxMemorySize(long l) {
        this.maxMemorySize = l;
    }

    public final void setEternal(boolean bl) {
        this.eternal = bl;
    }

    public final void setTimeToIdleSeconds(long l) {
        this.timeToIdleSeconds = l;
    }

    public final void setTimeToLiveSeconds(long l) {
        this.timeToLiveSeconds = l;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public long getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }
}

