/*
 * Decompiled with CFR 0.152.
 */
package jet.cache;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jet.cache.Cache;
import jet.cache.CacheCeilingSpaceControler;
import jet.cache.CacheConfiguration;
import jet.cache.CacheException;
import jet.cache.CacheManager;
import jet.cache.CachedData;
import jet.cache.Status;
import jet.cache.store.MemoryStore;
import jet.cache.store.MemoryStoreEvictionPolicy;
import jet.cache.store.Store;
import jet.server.log.ServiceLogger;

public class CacheImpl
implements Cache {
    private static final int LRU = 8192;
    private static final int SEDU = 0;
    private static final long STATUS_ALIVE = 0x3200000L;
    private static final MemoryStoreEvictionPolicy STATUS_SHUTDOWN = MemoryStoreEvictionPolicy.LRU;
    private static final boolean STATUS_UNINITIALISED = false;
    private static final long addAll = 0L;
    private static final long append = 0L;
    private static InetAddress asList;
    private CacheManager available;
    private CacheConfiguration clone;
    private CacheCeilingSpaceControler close = null;
    private boolean containsKey;
    private String create;
    private long currentTimeMillis;
    private Store dispose;
    private long equals;
    private long format;
    private long get;
    private Status getAbsolutePath;
    private long getKeyArray;

    public CacheImpl(String string) {
        this(string, 0, 0x3200000L, STATUS_SHUTDOWN, false, 0L, 0L);
    }

    public CacheImpl(String string, int n) {
        this(string, n, 0x3200000L, STATUS_SHUTDOWN, false, 0L, 0L);
    }

    public CacheImpl(String string, long l) {
        this(string, 0, l, STATUS_SHUTDOWN, false, 0L, 0L);
    }

    public CacheImpl(String string, boolean bl) {
        this(string, 0, 0x3200000L, STATUS_SHUTDOWN, bl, 0L, 0L);
    }

    public CacheImpl(String string, int n, long l, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean bl, long l2, long l3) {
        this.SEDU(Status.STATUS_UNINITIALISED);
        this.clone = new CacheConfiguration();
        this.clone.setName(string);
        this.clone.setMaxElementsInMemory(n);
        this.clone.setMaxMemorySize(l);
        this.clone.setMemoryStoreEvictionPolicyFromObject(memoryStoreEvictionPolicy);
        this.clone.setEternal(bl);
        this.clone.setTimeToIdleSeconds(l3);
        this.clone.setTimeToLiveSeconds(l2);
        this.create = this.STATUS_UNINITIALISED();
    }

    public CacheImpl(String string, CacheCeilingSpaceControler cacheCeilingSpaceControler) {
        this(string, 0, 0x3200000L, STATUS_SHUTDOWN, false, 0L, 0L);
        this.close = cacheCeilingSpaceControler;
    }

    private synchronized void LRU(CachedData cachedData) {
        if (!cachedData.isLifespanSet()) {
            cachedData.setTimeToLive((int)this.clone.getTimeToLiveSeconds());
            cachedData.setTimeToIdle((int)this.clone.getTimeToIdleSeconds());
            cachedData.setEternal(this.clone.isEternal());
        }
    }

    private synchronized void SEDU(Status status) {
        this.getAbsolutePath = status;
    }

    private void STATUS_ALIVE() throws IllegalStateException {
        if (!this.getAbsolutePath.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.clone.getName() + " Cache is not alive.");
        }
    }

    private void STATUS_SHUTDOWN() throws IllegalStateException {
        if (this.getAbsolutePath.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("The " + this.clone.getName() + " Cache is disposed.");
        }
    }

    private String STATUS_UNINITIALISED() {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer().append(asList).append("-").append(new UID());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            stringBuffer = new StringBuffer().append(this.clone.getName()).append("-").append(System.currentTimeMillis());
        }
        return stringBuffer.toString();
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        if (this.dispose != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        CacheImpl cacheImpl = (CacheImpl)super.clone();
        cacheImpl.clone = this.clone.clone();
        cacheImpl.create = this.STATUS_UNINITIALISED();
        return cacheImpl;
    }

    @Override
    public synchronized void dispose() throws IllegalStateException {
        this.STATUS_SHUTDOWN();
        if (this.dispose != null) {
            this.dispose.dispose();
        }
        this.SEDU(Status.STATUS_SHUTDOWN);
    }

    @Override
    public synchronized void evictExpiredElements() {
        Object[] objectArray;
        for (Object object : objectArray = this.dispose.getKeyArray()) {
            this.addAll(object, false);
        }
    }

    @Override
    public final synchronized CachedData get(Object object) throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        long l = System.currentTimeMillis();
        CachedData cachedData = this.addAll(object, true);
        if (cachedData == null) {
            ++this.get;
            ServiceLogger.logDebug(this.clone.getName() + " cache - Miss");
        } else {
            ++this.currentTimeMillis;
        }
        long l2 = System.currentTimeMillis();
        this.getKeyArray += l2 - l;
        return cachedData;
    }

    @Override
    public float getAverageGetTime() {
        if (this.currentTimeMillis == 0L) {
            return 0.0f;
        }
        return (float)this.getKeyArray / (float)this.currentTimeMillis;
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        return this.clone;
    }

    @Override
    public final CacheManager getCacheManager() {
        return this.available;
    }

    @Override
    public final String getGuid() {
        return this.create;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized InputStream getInputStream(File file) throws IllegalStateException, IOException {
        this.STATUS_ALIVE();
        InputStream inputStream = null;
        String string = file.getAbsolutePath();
        CachedData cachedData = null;
        if (this.containsKey(string)) {
            cachedData = this.get(string);
            inputStream = cachedData != null ? cachedData.toInputStream() : new FileInputStream(file);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            if ((long)n < this.getMaxMemorySize()) {
                byte[] byArray = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                try {
                    dataInputStream.readFully(byArray);
                }
                finally {
                    dataInputStream.close();
                }
                cachedData = new CachedData(string, byArray);
                this.put(cachedData);
                inputStream = cachedData.toInputStream();
            } else {
                inputStream = fileInputStream;
            }
        }
        return inputStream;
    }

    @Override
    public final List getKeys() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Object> list = Arrays.asList(this.dispose.getKeyArray());
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public final synchronized long getMaxMemorySize() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        return this.clone.getMaxMemorySize();
    }

    @Override
    public final synchronized int getMaxSize() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        return this.clone.getMaxElementsInMemory();
    }

    @Override
    public final synchronized long getMemorySize() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        return this.dispose.getMemorySize();
    }

    @Override
    public final String getName() {
        return this.clone.getName();
    }

    @Override
    public final synchronized int getSize() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        return this.getKeys().size();
    }

    @Override
    public final synchronized Status getStatus() {
        return this.getAbsolutePath;
    }

    public int hashCode() {
        return this.create.hashCode();
    }

    @Override
    public synchronized void initialise() {
        if (!this.getAbsolutePath.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Cannot initialise the " + this.clone.getName() + " cache because its status is not STATUS_UNINITIALISED");
        }
        this.dispose = MemoryStore.create(this);
        this.dispose.setCeilingSpaceControler(this.close);
        this.SEDU(Status.STATUS_ALIVE);
        if (this.containsKey) {
            ServiceLogger.logDebug("Cache: " + this.clone.getName() + " is disabled.");
        }
    }

    @Override
    public synchronized boolean isDisabled() {
        return this.containsKey;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.dispose.containsKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isExpired(CachedData cachedData) throws IllegalStateException, NullPointerException {
        this.STATUS_ALIVE();
        CachedData cachedData2 = cachedData;
        synchronized (cachedData2) {
            return cachedData.isExpired();
        }
    }

    @Override
    public final synchronized void put(CachedData cachedData) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        if (this.containsKey) {
            return;
        }
        if (cachedData == null || cachedData.getObjectKey() == null) {
            return;
        }
        cachedData.resetAccessStatistics();
        String string = cachedData.getObjectKey();
        boolean bl = this.containsKey(string);
        if (bl) {
            cachedData.updateAccessStatistics();
        }
        this.LRU(cachedData);
        if (ServiceLogger.isLoggable(4, 6)) {
            String string2 = null;
            string2 = cachedData.value == null && cachedData.valueObj != null ? String.format("Cache: put cacheData[key=%s, valueObj=%s, size=%s]:", string, cachedData.valueObj, cachedData.getMemorySize()) : String.format("Cache: put cacheData[key=%s, value=%s, size=%s]:", string, Arrays.asList(new byte[][]{cachedData.value}), cachedData.getMemorySize());
            ServiceLogger.logDebug(string2, 6);
        }
        this.dispose.put(cachedData);
    }

    @Override
    public final synchronized boolean remove(Object object) throws IllegalStateException {
        CachedData cachedData = this.dispose.remove(object);
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(String.format("Cache: remove[key=%s]:", object), 6);
        }
        return cachedData != null;
    }

    @Override
    public final synchronized void removeCachedInputStream(File file) throws IllegalStateException {
        this.dispose.remove(file.getAbsolutePath());
    }

    @Override
    public synchronized void removeAll() throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        this.dispose.removeAll();
    }

    private synchronized CachedData addAll(Object object, boolean bl) {
        CachedData cachedData = bl ? this.dispose.get(object) : this.dispose.getQuiet(object);
        if (cachedData != null) {
            if (this.isExpired(cachedData)) {
                ServiceLogger.logDebug("Memory cache hit, but element expired");
                if (bl) {
                    ++this.format;
                }
                this.remove(object);
                cachedData = null;
            } else if (bl) {
                ++this.equals;
            }
        }
        return cachedData;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.available = cacheManager;
    }

    @Override
    public synchronized void setDisabled(boolean bl) {
        this.containsKey = bl;
    }

    @Override
    public final synchronized void setMaxMemorySize(long l) throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        this.clone.setMaxMemorySize(l);
        this.dispose.setMemorySize(l);
    }

    @Override
    public final void setName(String string) throws IllegalArgumentException {
        if (!this.getAbsolutePath.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Only unitialised caches can have their names set.");
        }
        this.clone.setName(string);
    }

    @Override
    public final synchronized void setMaxSize(int n) throws IllegalStateException, CacheException {
        this.STATUS_ALIVE();
        this.clone.setMaxElementsInMemory(n);
        this.dispose.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray(File file) throws IOException {
        byte[] byArray = null;
        if (file != null) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (fileInputStream != null) {
                try {
                    int n;
                    byte[] byArray2 = new byte[8192];
                    while ((n = fileInputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                }
                finally {
                    fileInputStream.close();
                    byteArrayOutputStream.close();
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    @Override
    public void putCacheObj(Object object, Object object2, long l) throws IllegalArgumentException, CacheException {
        this.STATUS_ALIVE();
        if (!this.containsKey(object) && l < this.getMaxMemorySize()) {
            CachedData cachedData = new CachedData((String)object, object2, l);
            this.put(cachedData);
        }
    }

    @Override
    public void putCacheObjAlways(Object object, Object object2, long l) throws IllegalArgumentException, CacheException {
        this.STATUS_ALIVE();
        if (!this.containsKey(object)) {
            CachedData cachedData = new CachedData((String)object, object2, 0L);
            this.put(cachedData);
        }
    }

    @Override
    public Object getCacheObj(Object object) throws IllegalStateException, CacheException {
        CachedData cachedData;
        this.STATUS_ALIVE();
        Object object2 = null;
        if (this.containsKey(object) && (cachedData = this.get(object)) != null) {
            object2 = cachedData.getValueObj();
        }
        return object2;
    }

    @Override
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(" name=").append(this.clone.getName()).append(" status=").append(this.getAbsolutePath).append(" maxElementsInMemory=").append(this.clone.getMaxElementsInMemory()).append(" maxMemorySize=").append(this.clone.getMaxMemorySize()).append(" memoryStoreEvictionPolicy=").append(this.clone.getMemoryStoreEvictionPolicy()).append(" eternal=").append(this.clone.isEternal()).append(" timeToIdleSeconds=").append(this.clone.getTimeToIdleSeconds()).append(" timeToLiveSeconds=").append(this.clone.getTimeToLiveSeconds()).append(" hitCount=").append(this.currentTimeMillis).append(" memoryStoreHitCount=").append(this.equals).append(" missCountNotFound=").append(this.get).append(" missCountExpired=").append(this.format).append(" ]");
        return stringBuffer.toString();
    }

    static {
        try {
            asList = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError("Unable to set localhost. This prevents creation of a GUID. Cause was: " + unknownHostException.getMessage(), 2);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ServiceLogger.logError("InetAddress is being blocked by your runtime environment. " + noClassDefFoundError.getMessage(), 2);
        }
    }
}

